/************************************************************************
*									*
* The SB-Prolog System							*
* Copyright SUNY at Stony Brook, 1986; University of Arizona,1987	*
*									*
************************************************************************/

/*-----------------------------------------------------------------
SB-Prolog is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the SB-Prolog General Public
License for full details.

Everyone is granted permission to copy, modify and redistribute
SB-Prolog, but only under the conditions described in the
SB-Prolog General Public License.   A copy of this license is
supposed to have been given to you along with SB-Prolog so you
can know your rights and responsibilities.  It should be in a
file named COPYING.  Among other things, the copyright notice
and this notice must be preserved on all copies. 
------------------------------------------------------------------ */

$record_export([$erase/1,$recorda/3,$recordz/3,$recorded/3]).

$record_use($buff, [_,_,_,$buff_code/4,_,_,_,_,_,_,_]).
$record_use($bmeta, [_,_,_,_,_,$functor0/2,_,_,_,_,_,_,$is_buffer/1]).
$record_use($assert,[_,_,$asserta/2,_,$assertz/2,_,_,_,_,_,_,_,_]).
$record_use($decompile,[_,$clause/3,_,_]).
$record_use($bio,[_,_,_,$nl/0,_,$tell/1,_,$telling/1,$told/0,_,_,_,_,_,_]).
$record_use($io,[$write/1,_,_,_,_,_,$errmsg/1]).

/* $erase(Clref):  retracts the fact referenced by Clref.  It
does this by simply making the first instruction of the clause a
fail instruction. */

$erase(Clref) :-
     $is_buffer(Clref),
     $opcode(fail, FailOp),
     $buff_code(Clref,12,3 /*pb*/ , FailOp /*fail*/ ).

$recorda(Key,Term,Ref) :-
     $chk_record_args(Key,Ref),
     $functor0(Key,F),
     $asserta('_$record_db'(F,Term),Ref).

$recordz(Key,Term,Ref) :-
     $chk_record_args(Key,Ref),
     $functor0(Key,F),
     $assertz('_$record_db'(F,Term),Ref).

$recorded(Key,Term,Ref) :-
     $chk_record_args(Key,Ref),
     (nonvar(Key) ->
          $functor0(Key,F) ;
	  Key = F
     ),
     $clause('_$record_db'(F,Term),_,Ref).

$chk_record_args(Key,Ref) :-
     (nonvar(Key) ; $is_buffer(Ref)) ->
          true ;
	  ($errmsg('*** Error: uninstantiated key and DB-ref in recorda/recordz/recorded ***'),
	   fail
	  ).


/* ---------------------------------------------------------------------- */
