/************************************************************************
*									*
* The SB-Prolog System							*
* Copyright SUNY at Stony Brook, 1986; University of Arizona, 1987	*
*									*
************************************************************************/

/*-----------------------------------------------------------------
SB-Prolog is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the SB-Prolog General Public
License for full details.

Everyone is granted permission to copy, modify and redistribute
SB-Prolog, but only under the conditions described in the
SB-Prolog General Public License.   A copy of this license is
supposed to have been given to you along with SB-Prolog so you
can know your rights and responsibilities.  It should be in a
file named COPYING.  Among other things, the copyright notice
and this notice must be preserved on all copies. 
------------------------------------------------------------------ */
/* $statistics.P */

$statistics_export([$statistics/0,$statistics/2]).

$statistics_use($glob,[$globalset/1,_,_]).
$statistics_use($io,[_,_,_,$print/1]).
$statistics_use($osys,[$cputime/1,_,_,_]).
$statistics_use($bio,[_,_,_,$nl/0,_,_,_,$telling/1,$told/0,_,_,_,_,_,_]).
$statistics_use($buff,[_,_,_,_,$symtype/2,_,_,_,_,_,_]).



/* These predicates are provided primarily for compatibility with
   Quintus Prolog.							*/

$stats0(A,B,C,D,E,F,G,H) :- '_$builtin'(40).
$statistics :- '_$builtin'(41).

$statistics(runtime,[Tot,Curr]) :-
	$symtype('_$cputime'(_),CDef),
	(CDef > 0 -> '_$cputime'(Last) ; Last = 0),
	$cputime(Tot), Curr is Tot - Last,
	$globalset('_$cputime'(Tot)).
$statistics(core,X) :- $statistics(memory,X).
$statistics(memory,[Mem,0]) :-
	$stats0(MaxP,_,_,_,_,MaxStk,MaxTrail,_),
	Mem is MaxP+MaxStk+MaxTrail.
$statistics(heap,X) :- $statistics(program,X).
$statistics(program,[Used,Free]) :-
	$stats0(MaxP,Used,_,_,_,_,_,_),
	Free is MaxP-Used.
$statistics(global_stack,[Used,Free]) :-
	$stats0(_,_,Used,Free,_,_,_,_).
$statistics(local_stack,[Used,Free]) :-
	$stats0(_,_,_,Free,Used,_,_,_).
$statistics(trail,[Used,Free]) :-
	$stats0(_,_,_,_,_,_,Size,Used),
	Free is Size-Used.
$statistics(garbage_collection,[0,0]).
$statistics(stack_shifts,[0,0]).

/* ------------------------------ $statistics.P ------------------------------ */
