/**/# -*- Mode: Text;  -*-
/**/# File: Makefile.mach.cpp
/**/# /* Author: Heinz Schmidt (hws@csis.dit.csiro.AU) */
/**/# Copyright (C) CSIRO Division of Information Technology, 1992
/**/#
/**/# COPYRIGHT NOTICE: This code is provided "AS IS" WITHOUT ANY WARRANTY
/**/# and is subject to the terms of the SATHER LIBRARY GENERAL PUBLIC
/**/# LICENSE contained in the file: "sather/doc/license.txt" of the Sather
/**/# distribution. The license is also available from ICSI, 1947 Center
/**/# St., Suite 600, Berkeley CA 94704, USA.
/**/#*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
/**/#* FUNCTION: Makefile header included by all Makefiles. The file 
/**/#*    consists of three parts: 
/**/#*        Makefile.site: you normally need to edit only this one.
/**/#*        Makefile.mach: the machine dependent part and defaults.
/**/#*           This is machine generated you do not want to change it.
/**/#*           When porting you want to change Makefile.mach.cpp
/**/#*           instead.
/**/#*        Makefile.gen: the generic make plans.
/**/#*  
/**/#*    This file contains the default macros possible overridden
/**/#*    by machine dependent settings.
/**/#*
/**/#* HISTORY:
/**/#*  Feb  1 19:32 1992 (hws): Extracted from top level Makefile. Avoids
/**/#*    the need to adapt 10 Makefiles when defaults change upon ports.
/**/#* Created: Sat Feb  1 19:30:33 1992 (hws)
/**/#*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
/**/# These are default options you do *NOT* want to modify.


#if defined(i386) && defined(M_SYSV) 
/**/# We assume that i386_ and M_SYSV_ are enough to make sure. If this
/**/# raises problems make above more specific. Ideally we would like
/**/# vanilla   "make config" do the right thing.
#   define SCO
#endif


#if defined(SCO)
/**/#*   This flag may be non-standard, pass it in the make config step **
/**/#*   SCO UNIX, SYSV R3.2 has ar in /binm/ar, hope that is alright ** 
AR = ar
#else
AR = /bin/ar
#endif

AR = /bin/ar
AS = /bin/as
AWK = /bin/awk

COMPRESS = /usr/ucb/compress
CP = /bin/cp

/**/# I tried /lib/cpp on NeXT but this confuses make by  "/**/#" -> " #"
/**/# If your cc is not properly installed you may
/**/# do         make CPP="(/lib/cpp | sed s,' \#','#',g ) <" config
/**/# instead, overriding the current CPP setting
CPP = cc -E

ECHO = /bin/echo
ED = /bin/ed
FALSE = /bin/false
FIND = /usr/bin/find

#ifdef SCO
INSTALL = cp
LN = cp
#else
INSTALL = /usr/bin/install
LN = /bin/ln -s
#endif

#if (defined(sony) && defined(SYSTYPE_BSD)) \
    || (defined(mips) && !defined(ultrix))
/**/# _Sony BSD_ libm.a or _RISCOS_ libm.a
MATHLIB=/usr/lib/cmplrs/cc/libm.a
#else
#  if defined(hpux)
MATHLIB=/lib/libm.a
#  else
MATHLIB=/usr/lib/libm.a
#  endif
#endif

MD = /bin/mkdir
MV = /bin/mv

#ifdef M_SYSV
/**/# _SysV_ simulation of ranlib
RANLIB = ar st
#else
#  if defined (NeXT) || defined (hpux)
RANLIB = /bin/ranlib
#  else
RANLIB = /usr/bin/ranlib
#  endif
#endif

RM = /bin/rm -f
SED = /bin/sed
SHELL = /bin/sh

#ifdef SCO
TAR = tar
#else
TAR = /bin/tar
#endif

TRUE = /bin/true
WC = /usr/ucb/wc
YACC = /usr/bin/yacc

/**/# Problems with your ARCHITECTURE or PORTING? 
/**/# You may have to change here if you are porting.
/**/#
/**/#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
/**/# Architecture specific settings, extended with each port and perhaps
/**/# replacing some of the defaults above.

/**/# #include ${TOPDIR}/makemach
/**/# -*- Mode: Text;  -*-
/**/# File: makemach.cpp
/**/# /* Author: Heinz Schmidt (hws@csis.dit.csiro.AU) */
/**/# 
/**/# Copyright (C) CSIRO Division of Information Technology, 1992
/**/# COPYRIGHT NOTICE: This code is provided "AS IS" WITHOUT ANY WARRANTY
/**/# and is subject to the terms of the SATHER LIBRARY GENERAL PUBLIC
/**/# LICENSE contained in the file: "sather/doc/license.txt" of the Sather
/**/# distribution. The license is also available from ICSI, 1947 Center
/**/# St., Suite 600, Berkeley CA 94704, USA.
/**/#*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
/**/#* FUNCTION: Machine dependent setting for Makefile.header
/**/#*           (All makefiles should be rewritten to use imake).
/**/#* HISTORY:
/**/#* Created: Mon Feb  3 00:27:40 1992 (hws)
/**/#*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

/**/# The following conditionals are used so far and the
/**/# current setting is depicted in the generated file.
/**/# If you are porting to a new machine please record the new option here.
/**/# It may help someone else interpreting compile conditionalizations.
/**/# 
/**/# Architectures:
/**/# sparc_: sparc, sun3_: sun3, sun4_: sun4,
/**/# mips_: mips, hpux_: hpux, vax_: vax, sony_: sony,
/**/# sequent_: sequent, vax_: vax, mips_: mips, MIPSEL_: MIPSEL,
/**/# NeXT_: NeXT, mc68000_: mc68000, hp9000s300_: hp9000s300,
/**/# i386_: i386, ibm032_: ibm032, _IBMR2_: _IBMR2,
/**/# SCO_: SCO
/**/# 
/**/# Operating systems:
/**/# unix_: unix, bsd4_2_: bsd4_2, bsd4_3_: bsd4_3, SYSTYPE_BSD: SYSTYPE_BSD
/**/# SYSV_: SYSV, SYSTYPE_SYSV_: SYSTYPE_SYSV, M_SYSV_: M_SYSV
/**/# ultrix_: ultrix, __MACH___: __MACH__

/**/# MACHINE DEPENDENT REDEFINITIONS OF FLAGS

/**/# -O is a bad option for compiling the cs MAIN_.c
/**/# because cc crashes due to size. The main routine
/**/# itself is relatively small. Other than this the options can be
/**/# just like CFLAGS. MAINFLAGS is used when the MAIN_.c of 
/**/# the sather compiler is processed. It has lots of symbols
/**/# and requires special table sizes on some unixes.
/**/# Since we include this header file, every make file sees the
/**/# defaults, can save them or append to them or replace them.

/**/# These are passed to cc, TCLIBS is only used in some tests etc/test
CC = cc
CFLAGS = -O -DSATHER -DGC_ 
TCLIBS =
MFLAGS =

/**/# cc flags when compiling the big compiler MAIN_.c
MAINFLAGS= -DSATHER -DGC_
/**/# some systems even want a different compiler in this case.
MAINCC=${CC}

/**/# These are only passed to the make step which compiles the
/**/# boot compiler and can be used to override flags in the make file
/**/# that was generated when the distribution was constructed on another
/**/# machine: compiler/cs.cs.boot/mkCS
BOOTFLAGS=
/**/# These are passed to cs and can include -cflags, -cc etc., cf.
/**/# doc/cs_options.txt. Will show up in the make file created
/**/# by the compiler during the installation.
CSFLAGS = -w

#ifdef NeXT
CFLAGS= -O -DSATHER
MAINFLAGS= -DSATHER
#endif

#ifdef mips
#    ifdef bsd4_2
MAINFLAGS= -DSATHER -DGC_ -w -Wf,-XNd10000 -Wf,-XNc100
#    else
#      ifdef ultrix
MAINFLAGS= -DSATHER -DGC_ -w -Wf,-XNd12000 -Wf,-XNc100
#      else
MAINFLAGS= -DSATHER -DGC_ -systype bsd43 -w -Wf,-XNd10000 -Wf,-XNc100
CFLAGS= -O -DSATHER -Olimit 847 -DGC_ -systype bsd43
CSFLAGS= -w -cflags "${CFLAGS}"
#      endif
#    endif
#endif

#ifdef SCO
CFLAGS= -O -DSATHER -DGC_ -DSYSV -DSCO
CSFLAGS= -w -cflags "${CFLAGS} -lsocket"
BOOTFLAGS= "CLIB=-lsocket"
MAINFLAGS= -DSATHER -DGC_ -DSYSV -DSCO
MAINCC=rcc
MATHLIB=/lib/libm.a
#endif
 
#ifdef hpux
#  ifdef hpux8 
/**/# Enforce user flag -Dhpux8 that is used in some code.
MAINFLAGS= -DSATHER -DGC_ -DSYSV -Dhpux8 -w -Wf,-XNd10000 -Wf,-XNc100
CFLAGS= -O -DSATHER -DGC_ -DSYSV -Dhpux8
#  else
#    ifdef hpux7
/**/# Enforce user flag -Dhpux7 that is used in some code.
MAINFLAGS= -DSATHER -DGC_ -DSYSV -Dhpux7 -w -Wf,-XNd10000 -Wf,-XNc100
CFLAGS= -O -DSATHER -DGC_ -DSYSV -Dhpux7
#    else
MAINFLAGS= -DSATHER -DGC_ -DSYSV -w -Wf,-XNd10000 -Wf,-XNc100
CFLAGS= -O -DSATHER -DGC_ -DSYSV
#    endif
#  endif
#endif

#ifdef aix
MAINFLAGS= -DSATHER -DGC_ -DSYSV
CFLAGS= -O -DSATHER -DGC_ -DSYSV
#endif

#ifdef att
MAINFLAGS= -DSATHER -DGC_ -DSYSV -DUSG
CFLAGS= -O -DSATHER -DGC_ -DSYSV -DUSG
#endif

#if defined(vax) && defined(ultrix)
MAINFLAGS= -DSATHER -DGC_ -w -W0,-Nn10000
#endif

#if defined(sony) && defined(SYSTYPE_BSD)
MAINFLAGS= -DSATHER -DGC_ -Dmips -w -Wf,-XNd10000 -Wf,-XNc100
CFLAGS= -O -DSATHER -DGC_ -Dmips
MATHLIB=/usr/lib/cmplrs/cc/libm.a
#endif

#ifdef sequent
CC = gcc
CFLAGS= -traditional -O -DSATHER -DGC_ -Dsequent -w 
MAINFLAGS= -traditional -DSATHER -DGC_ -Dsequent -w 
TCLIBS=-llocal
CSFLAGS= -w -cflags "${CFLAGS}"
#endif

/**/# WHILE PORTING ...
/**/# MACHINE DEPENDENT SUBSYSTEM INCLUSION
/**/# The following variables help skipping installations of part of the
/**/# system that may require adaptation.

/**/# The Sather debugger (sdb) is based on the GNU debugger. The current
/**/# distribution contains only the setting for sparc. You need
/**/# to run your local Gnu gdb directory against debugger/C and
/**/# edit the local make file there. We really should make this
/**/# via a gdb.${ARCH} directory and links into it for the 3 or 4 files
/**/# that are machine dependent.
/**/# YES or NO controls whether sdb installation skipped.

#ifdef sparc
SKIPSDB = NO
#else
SKIPSDB = YES
#endif

/**/# The Garbage Collector (GC) may require a new machine dependent
/**/# patch if the machine is not yet supported.
/**/# YES or NO controls whether gc installation skipped.
#ifdef NeXT
SKIPGC = YES
#else
SKIPGC = NO
#endif
/**/# GC V1.9 runs now on Dec mipses and RT too.
/**/# #if defined(mips) & defined(ultrix) & defined(bsd4_2)
/**/# SKIPGC = YES
/**/# #else
/**/# SKIPGC = NO
/**/# #endif

/**/# 
/**/# Local flags while developing, porting etc.
LOCFLAGS =


/**/# This part should perhaps stay as it is. See also the note below.
/**/# 
/**/# Do not delete param passing for sather home and topdir, ever.
/**/# "make dist" will run clean on the development system!
/**/# Do not include CFLAGS param passing here, so every make file 
/**/# can see the shared defaults (XCFLAGS) and append to them or redefine them
/**/# appropirately.
/**/# Moreover pass on make parameters (${MAKE}) so we can do the few non-interfering
/**/# things "make ARCH=mips -f Makefile" on disjoint subdirectories for different
/**/# architectures. 

MKCMD = ${MAKE} SATHER_HOME=${SATHER_HOME} TOPDIR=${TOPDIR}

CS = ${TOPDIR}/bin.${ARCH}/cs -mak ${SATHER_MAKE}
