/* unix__90.c : Sather class: UNIX */

#include "all_.h"
#include "c_names_.h"
#include "offsets_.h"

static char __sather_compiled__;
extern int unlink();
extern ptr getenv();
extern int system();
extern exit();
extern int rmdir();
extern int fork();
extern int acct();
extern int chdir();
extern int chroot();
extern ptr c_object_base_();
extern int execve();
extern int mkdir();
extern int getegid();
extern int geteuid();
extern int getgid();
extern int gethostname();
extern int getpid();
extern int getppid();
extern int getuid();
extern int ioctl();
extern int link();
extern profil();
extern int rename();
extern int sethostname();
extern int setregid();
extern int setreuid();
extern sync();
extern int umask();
extern ptr str_ptr_();
extern int putenv_();
extern /*shared*/ int errno;
extern ptr getcwd_();
extern ptr getlogin();
#define c_object_base_(a) ((ptr)((ptr)a + ob_base_size_(TYPE_(a)) + 1*SI_))
#include <errno.h>

extern int STR20_length_();
extern ptr STR20_from_c_str_();
extern ptr STR20_create_();
extern ptr STR20_s_();
extern ptr STR20_c_();
#include "macros_.h"



/*shared*/ int UNI90_unix_error_;
int UNI90_acct_();
int UNI90_chdir_();
int UNI90_chroot_();
int UNI90_execve_();
int UNI90_fork_();
int UNI90_getegid_();
int UNI90_geteuid_();
int UNI90_getgid_();
int UNI90_gethostname_();
int UNI90_getpid_();
int UNI90_getppid_();
int UNI90_getuid_();
int UNI90_ioctl_();
int UNI90_link_();
int UNI90_mkdir_();
UNI90_profil_();
int UNI90_rename_();
int UNI90_rmdir_();
int UNI90_sethostname_();
int UNI90_setregid_();
int UNI90_setreuid_();
UNI90_sync_();
int UNI90_umask_();
int UNI90_unlink_();
int UNI90_system_();
ptr UNI90_getenv_();
int UNI90_putenv_();
ptr UNI90_getcwd_();
ptr UNI90_login_name_();
UNI90_exit_();
ptr UNI90_initialize_();
extern int attr_ent_UNI90[];

int UNI90_acct_(self__,acctfile__)
ptr self__;
ptr acctfile__;
{
   int res__ = S_int_VOID_;

   res__ = acct(str_ptr_(acctfile__));
   UNI90_unix_error_ = errno;
   return (res__);
}

int UNI90_chdir_(self__,dirname__)
ptr self__;
ptr dirname__;
{
   int res__ = S_int_VOID_;

   res__ = chdir(str_ptr_(dirname__));
   UNI90_unix_error_ = errno;
   return (res__);
}

int UNI90_chroot_(self__,dirname__)
ptr self__;
ptr dirname__;
{
   int res__ = S_int_VOID_;

   res__ = chroot(str_ptr_(dirname__));
   UNI90_unix_error_ = errno;
   return (res__);
}

int UNI90_execve_(self__,prog__,argv__,envp__)
ptr self__;
ptr prog__;
ptr argv__;
ptr envp__;
{
   int res__ = S_int_VOID_;
   ptr new_argv__ = S_ptr_VOID_;
   int argv_sz__ = S_int_VOID_;
   int i__ = S_int_VOID_;
   ptr new_envp__ = S_ptr_VOID_;
   int envp_sz__ = S_int_VOID_;
   int i_53_ = S_int_VOID_;
   ptr c_argv__ = S_ptr_VOID_;
   ptr c_envp__ = S_ptr_VOID_;

   new_argv__ = S_ptr_VOID_;
   if ((argv__ != 0)) {
      argv_sz__ = IATT_(argv__,4);
      new_argv__ = new1_(76,argv_sz__,0);
      i__ = S_int_VOID_;
      while (1) {
         if ((i__ >= argv_sz__)) break;
         if ((PATT_(argv__, 8 + ((i__) << 2)) != 0)) {
            PATT_(new_argv__, 8 + ((i__) << 2)) = str_ptr_(PATT_(argv__, 8 + ((i__) << 2)));
         }
         else {
         }
         i__ = (i__ + 1);
      }
   }
   else {
   }
   new_envp__ = S_ptr_VOID_;
   if ((envp__ != 0)) {
      envp_sz__ = IATT_(envp__,4);
      new_envp__ = new1_(76,envp_sz__,0);
      i_53_ = S_int_VOID_;
      while (1) {
         if ((i_53_ >= envp_sz__)) break;
         if ((PATT_(envp__, 8 + ((i_53_) << 2)) != 0)) {
            PATT_(new_envp__, 8 + ((i_53_) << 2)) = str_ptr_(PATT_(envp__, 8 + ((i_53_) << 2)));
         }
         else {
         }
         i_53_ = (i_53_ + 1);
      }
   }
   else {
   }
   c_argv__ = S_ptr_VOID_;
   c_envp__ = S_ptr_VOID_;
   if ((new_argv__ != 0)) {
      c_argv__ = c_object_base_(new_argv__);
   }
   else {
   }
   if ((new_envp__ != 0)) {
      c_envp__ = c_object_base_(new_envp__);
   }
   else {
   }
   res__ = execve(str_ptr_(prog__),c_argv__,c_envp__);
   UNI90_unix_error_ = errno;
   return (res__);
}

int UNI90_fork_(self__)
ptr self__;
{
   int res__ = S_int_VOID_;

   res__ = fork();
   UNI90_unix_error_ = errno;
   return (res__);
}

int UNI90_getegid_(self__)
ptr self__;
{
   int res__ = S_int_VOID_;

   res__ = getegid();
   UNI90_unix_error_ = errno;
   return (res__);
}

int UNI90_geteuid_(self__)
ptr self__;
{
   int res__ = S_int_VOID_;

   res__ = geteuid();
   UNI90_unix_error_ = errno;
   return (res__);
}

int UNI90_getgid_(self__)
ptr self__;
{
   int res__ = S_int_VOID_;

   res__ = getgid();
   UNI90_unix_error_ = errno;
   return (res__);
}

int UNI90_gethostname_(self__,name__,namelen__)
ptr self__;
ptr name__;
int namelen__;
{
   int res__ = S_int_VOID_;

   res__ = gethostname(str_ptr_(name__),IATT_(name__,4));
   UNI90_unix_error_ = errno;
   return (res__);
}

int UNI90_getpid_(self__)
ptr self__;
{
   int res__ = S_int_VOID_;

   res__ = getpid();
   UNI90_unix_error_ = errno;
   return (res__);
}

int UNI90_getppid_(self__)
ptr self__;
{
   int res__ = S_int_VOID_;

   res__ = getppid();
   UNI90_unix_error_ = errno;
   return (res__);
}

int UNI90_getuid_(self__)
ptr self__;
{
   int res__ = S_int_VOID_;

   res__ = getuid();
   UNI90_unix_error_ = errno;
   return (res__);
}

int UNI90_ioctl_(self__,des__,request__,arg__)
ptr self__;
int des__;
int request__;
int arg__;
{
   int res__ = S_int_VOID_;

   res__ = ioctl(des__,request__,arg__);
   UNI90_unix_error_ = errno;
   return (res__);
}

int UNI90_link_(self__,name1__,name2__)
ptr self__;
ptr name1__;
ptr name2__;
{
   int res__ = S_int_VOID_;

   res__ = link(str_ptr_(name1__),str_ptr_(name2__));
   UNI90_unix_error_ = errno;
   return (res__);
}

int UNI90_mkdir_(self__,name__,mode__)
ptr self__;
ptr name__;
int mode__;
{
   int res__ = S_int_VOID_;

   res__ = mkdir(str_ptr_(name__),mode__);
   UNI90_unix_error_ = errno;
   return (res__);
}

UNI90_profil_(self__,buff__,bufsiz__,offset__,scale__)
ptr self__;
ptr buff__;
int bufsiz__;
int offset__;
int scale__;
{

   profil(str_ptr_(buff__),bufsiz__,offset__,scale__);
}

int UNI90_rename_(self__,from__,to__)
ptr self__;
ptr from__;
ptr to__;
{
   int res__ = S_int_VOID_;

   res__ = rename(str_ptr_(from__),str_ptr_(to__));
   UNI90_unix_error_ = errno;
   return (res__);
}

int UNI90_rmdir_(self__,name__)
ptr self__;
ptr name__;
{
   int res__ = S_int_VOID_;

   res__ = rmdir(str_ptr_(name__));
   UNI90_unix_error_ = errno;
   return (res__);
}

int UNI90_sethostname_(self__,name__,namelen__)
ptr self__;
ptr name__;
int namelen__;
{
   int res__ = S_int_VOID_;

   res__ = sethostname(str_ptr_(name__),STR20_length_(name__));
   return (res__);
}

int UNI90_setregid_(self__,rgid__,egid__)
ptr self__;
int rgid__;
int egid__;
{
   int res__ = S_int_VOID_;

   res__ = setregid(rgid__,egid__);
   UNI90_unix_error_ = errno;
   return (res__);
}

int UNI90_setreuid_(self__,ruid__,euid__)
ptr self__;
int ruid__;
int euid__;
{
   int res__ = S_int_VOID_;

   res__ = setreuid(ruid__,euid__);
   UNI90_unix_error_ = errno;
   return (res__);
}

UNI90_sync_(self__)
ptr self__;
{

   sync();
}

int UNI90_umask_(self__,numask__)
ptr self__;
int numask__;
{
   int res__ = S_int_VOID_;

   res__ = umask(numask__);
   return (res__);
}

int UNI90_unlink_(self__,name__)
ptr self__;
ptr name__;
{
   int res__ = S_int_VOID_;

   res__ = unlink(str_ptr_(name__));
   UNI90_unix_error_ = errno;
   return (res__);
}

int UNI90_system_(self__,com__)
ptr self__;
ptr com__;
{
   int res__ = S_int_VOID_;

   res__ = system(str_ptr_(com__));
   UNI90_unix_error_ = errno;
   return (res__);
}

ptr UNI90_getenv_(self__,name__)
ptr self__;
ptr name__;
{
   ptr res__ = S_ptr_VOID_;

   res__ = STR20_from_c_str_(0,getenv(str_ptr_(name__)));
   UNI90_unix_error_ = errno;
   return (res__);
}

int UNI90_putenv_(self__,name__,val__)
ptr self__;
ptr name__;
ptr val__;
{
   int res__ = S_int_VOID_;
   ptr arg__ = S_ptr_VOID_;

   arg__ = STR20_s_(STR20_c_(STR20_s_(STR20_create_(0),name__),'='),val__);
   res__ = putenv_(str_ptr_(arg__));
   return (res__);
}

ptr UNI90_getcwd_(self__)
ptr self__;
{
   ptr res__ = S_ptr_VOID_;
   ptr c_str__ = S_ptr_VOID_;

   c_str__ = getcwd_();
   if ((c_str__ != 0)) {
      res__ = STR20_from_c_str_(0,c_str__);
   }
   else {
      UNI90_unix_error_ = errno;
   }
   return (res__);
}

ptr UNI90_login_name_(self__)
ptr self__;
{
   ptr res__ = S_ptr_VOID_;
   ptr c_str__ = S_ptr_VOID_;

   c_str__ = getlogin();
   if ((c_str__ != 0)) {
      res__ = STR20_from_c_str_(0,c_str__);
   }
   else {
   }
   return (res__);
}

UNI90_exit_(self__,i__)
ptr self__;
int i__;
{

   exit(i__);
}

ptr UNI90_initialize_(self__,initarg__)
ptr self__;
ptr initarg__;
{
   ptr res__ = S_ptr_VOID_;

   res__ = self__;
   return (res__);
}

