/* * Last edited: Jun  4 01:06 1991 (bilmes) */
/* File: sather/C/time_.c
   Author: Stephen M. Omohundro
   Created: Tue Sep 25 17:14:23 1990
   Copyright (C) International Computer Science Institute, 1990

   COPYRIGHT NOTICE: This code is provided "AS IS" WITHOUT ANY WARRANTY
   and is subject to the terms of the SATHER LIBRARY GENERAL PUBLIC
   LICENSE contained in the file: "sather/doc/license.txt" of the Sather
   distribution. The license is also available from ICSI, 1947 Center
   St., Suite 600, Berkeley CA 94704, USA.

   Time related functions.
   Modified by: Jeff Bilmes, Tue Oct 30 12:06:02 1990
    -- make a bit more general.
*/

#include <sys/time.h>
#include <sys/resource.h>
#include <sys/types.h>
#include <sys/timeb.h>

static struct rusage start_ru_;
static struct rusage mark_ru_;

/* Initializes st. */
extern void start_clock_()
{
  getrusage(RUSAGE_SELF,&start_ru_);
}

/* mark clock, mark the current time for the next report time. */
void mark_clock_()
{
  getrusage(RUSAGE_SELF,&mark_ru_);
}

/* get user time between last start_clock and mark_clock */
float get_usr_()
{
  float st=start_ru_.ru_utime.tv_sec+.000001*start_ru_.ru_utime.tv_usec;
  float et=mark_ru_.ru_utime.tv_sec+.000001*mark_ru_.ru_utime.tv_usec;
  return (et-st);
}

/* get system time between last start_clock and mark_clock */
float get_sys_()
{
  float st=start_ru_.ru_stime.tv_sec+.000001*start_ru_.ru_stime.tv_usec;
  float et=mark_ru_.ru_stime.tv_sec+.000001*mark_ru_.ru_stime.tv_usec;
  return (et-st);
}

/* Time since 00:00:00 GMT, Jan. 1, 1970 in seconds. */
double time_() 
{
  static struct timeb t;
  ftime(&t);
  return(t.time+(t.millitm/1000.));
}

