;;; -*-Scheme-*-
;;;
;;;	$Header: bufott.scm,v 1.2 89/04/28 22:47:36 GMT cph Rel $
;;;
;;;	Copyright (c) 1986, 1989 Massachusetts Institute of Technology
;;;
;;;	This material was developed by the Scheme project at the
;;;	Massachusetts Institute of Technology, Department of
;;;	Electrical Engineering and Computer Science.  Permission to
;;;	copy this software, to redistribute it, and to use it for any
;;;	purpose is granted, subject to the following restrictions and
;;;	understandings.
;;;
;;;	1. Any copy made of this software must include this copyright
;;;	notice in full.
;;;
;;;	2. Users of this software agree to make their best efforts (a)
;;;	to return to the MIT Scheme project any improvements or
;;;	extensions that they make, so that these may be included in
;;;	future releases; and (b) to inform MIT of noteworthy uses of
;;;	this software.
;;;
;;;	3. All materials developed as a consequence of the use of this
;;;	software shall duly acknowledge such use, in accordance with
;;;	the usual standards of acknowledging credit in academic
;;;	research.
;;;
;;;	4. MIT has made no warrantee or representation that the
;;;	operation of this software will be error-free, and MIT is
;;;	under no obligation to provide any services, by way of
;;;	maintenance, update, or otherwise.
;;;
;;;	5. In conjunction with products arising from the use of this
;;;	material, there shall be no use of the name of the
;;;	Massachusetts Institute of Technology nor of any adaptation
;;;	thereof in any advertising, promotional, or sales literature
;;;	without prior written consent from MIT in each case.
;;;
;;; NOTE: Parts of this program (Edwin) were created by translation
;;; from corresponding parts of GNU Emacs.  Users should be aware that
;;; the GNU GENERAL PUBLIC LICENSE may apply to these parts.  A copy
;;; of that license should have been included along with this file.
;;;

;;;; Buffer Output Ports, Truncating

(declare (usual-integrations))

(define (with-output-to-mark-truncating mark limit-column thunk)
  (call-with-current-continuation
   (lambda (continuation)
     (with-output-to-port
	 (output-port/copy
	  buffer-output-port-template
	  (make-buffer-output-port-state
	   (mark-left-inserting mark)
	   limit-column
	   (lambda () (continuation unspecific))))
       thunk))))

(define (truncation-protect thunk)
  (let ((state (output-port/state (current-output-port))))
    (if (not (buffer-output-port-state? state))
	(error "current port not of correct type" state))
    (call-with-current-continuation
     (lambda (continuation)
       (with-buffer-output-port-state/return
	state
	(lambda () (continuation unspecific))
	thunk)))))

(define-structure (buffer-output-port-state
		   (conc-name buffer-output-port-state/))
  (mark false read-only true)
  (limit-column false read-only true)
  (return false))

(define with-buffer-output-port-state/return
  (object-component-binder buffer-output-port-state/return
			   set-buffer-output-port-state/return!))

(define (operation/write-char port char)
  (let ((state (output-port/state port)))
    (let ((mark (buffer-output-port-state/mark state)))
      (if (or (char=? char #\newline)
	      (< (let ((column (mark-column mark)))
		   (+ column (char-column-length char column)))
		 (buffer-output-port-state/limit-column state)))
	  (insert-char char mark)
	  ((buffer-output-port-state/return state))))))

(define (operation/write-string port string)
  (let ((state (output-port/state port)))
    (let ((mark (buffer-output-port-state/mark state))
	  (limit-column (buffer-output-port-state/limit-column state)))
      (let ((end (string-length string))
	    (output-line
	     (lambda (start end)
	       (insert-substring string
				 start
				 (substring-column->index string start end
							  (mark-column mark)
							  limit-column)
				 mark))))
	(let loop ((start 0))
	  (let ((index (substring-find-next-char string start end #\newline)))
	    (if (not index)
		(begin
		  (output-line start end)
		  (if (>= (mark-column mark) limit-column)
		      ((buffer-output-port-state/return state))))
		(begin
		  (output-line start index)
		  (insert-newline mark)
		  (loop (1+ index))))))))))

(define (operation/print-self state port)
  (unparse-string state "to buffer (truncating) at ")
  (unparse-object state
		  (buffer-output-port-state/mark (output-port/state port))))

(define buffer-output-port-template
  (make-output-port `((PRINT-SELF ,operation/print-self)
		      (WRITE-CHAR ,operation/write-char)
		      (WRITE-STRING ,operation/write-string))
		    false))