#| -*-Scheme-*-

$Header: Sgraph.scm,v 14.11 89/06/22 23:50:45 GMT cph Rel $

Copyright (c) 1988, 1989 Massachusetts Institute of Technology

This material was developed by the Scheme project at the Massachusetts
Institute of Technology, Department of Electrical Engineering and
Computer Science.  Permission to copy this software, to redistribute
it, and to use it for any purpose is granted, subject to the following
restrictions and understandings.

1. Any copy made of this software must include this copyright notice
in full.

2. Users of this software agree to make their best efforts (a) to
return to the MIT Scheme project any improvements or extensions that
they make, so that these may be included in future releases; and (b)
to inform MIT of noteworthy uses of this software.

3. All materials developed as a consequence of the use of this
software shall duly acknowledge such use, in accordance with the usual
standards of acknowledging credit in academic research.

4. MIT has made no warrantee or representation that the operation of
this software will be error-free, and MIT is under no obligation to
provide any services, by way of maintenance, update, or otherwise.

5. In conjunction with products arising from the use of this material,
there shall be no use of the name of the Massachusetts Institute of
Technology nor of any adaptation thereof in any advertising,
promotional, or sales literature without prior written consent from
MIT in each case. |#

;;;; Starbase Graphics Interface
;;; package: (runtime starbase-graphics)

(declare (usual-integrations))

(define (initialize-package!)
  (set! *graphics-drawing-mode* drawing-mode:dominant)
  (set! *graphics-line-style* 0)
  (set-default-character-attributes!))

(define-primitives
  ;; Defined in "Sgraph.c".
  (graphics-name-device 2)
  (graphics-set-coordinates 6)
  (graphics-initialize 0)
  (graphics-close 0)
  (graphics-clear 0)
  (graphics-move 2)
  (graphics-line 2)
  (graphics-pixel 2)
  (graphics-set-line-style 1)
  (graphics-set-drawing-mode 1)
  (set-clip-rectangle 2)
  (graphics-label 1)
  (graphics-set-letter 3)
  (graphics-set-rotation 1)
  (prim-print-graphics print-graphics 1)
  (prim-print-graphics-inverse print-graphics-inverse 1)

  ;; Defined in "SgX.c".
  (x-graphics-open-display 1)
  (x-graphics-close-display 0)
  (x-graphics-old-open-window 5)
  (x-graphics-close-window 0)
  (x-graphics-map-window 0)
  (x-graphics-unmap-window 0)
  (x-graphics-raise-window 0)
  (x-graphics-lower-window 0)
  (x-graphics-create-raster 0)
  (x-graphics-delete-raster 0)
  (x-graphics-start-retain 0)
  (x-graphics-stop-retain 0))

(define-integrable drawing-mode:erase 0)
(define-integrable drawing-mode:non-dominant 1)
(define-integrable drawing-mode:complement 2)
(define-integrable drawing-mode:dominant 3)

(define *graphics-drawing-mode*)
(define *graphics-line-style*)

;;;; Student Graphics Interface

(define (graphics-available?)
  (implemented-primitive-procedure? graphics-line))

(define (x-graphics-available?)
  (implemented-primitive-procedure? x-graphics-open-display))

(define (init-graphics #!optional x-origin y-origin)
  (graphics-name-device "/dev/crt" "hp300h")
  (let ((width 1024)
	(height 768))
    (let ((x-origin
	   (if (default-object? x-origin) (quotient width 2) x-origin))
	  (y-origin
	   (if (default-object? y-origin) (quotient height 2) y-origin)))
      (graphics-set-coordinates (- x-origin)
				(- y-origin)
				0
				(-1+ (- width x-origin))
				(-1+ (- height y-origin))
				0)))
  (init-graphics/internal))

(define (x-graphics-initialize display x y width height
			       #!optional x-origin y-origin border-width)
  (let ((x-origin (if (default-object? x-origin) (quotient width 2) x-origin))
	(y-origin (if (default-object? y-origin) (quotient height 2) y-origin))
	(border-width (if (default-object? border-width) 4 border-width)))
    (and (x-graphics-open-display display)
	 (begin
	   (graphics-name-device
	    (x-graphics-old-open-window x y width height border-width)
	    "Xn")
	   (graphics-set-coordinates (- x-origin)
				     (- y-origin)
				     0
				     (-1+ (- width x-origin))
				     (-1+ (- height y-origin))
				     0)
	   (x-graphics-create-raster)
	   (x-graphics-map-window)
	   (init-graphics/internal)
	   true))))

(define (init-graphics/internal)
  (graphics-initialize)
  (set-graphics-drawing-mode drawing-mode:dominant)
  (set-graphics-line-style 0))

(define (clear-graphics)
  (graphics-clear)
  (graphics-move 0 0))

(define-integrable (position-pen x y)
  (graphics-move (round x) (round y)))

(define-integrable (draw-point x y)
  (draw-point/internal x y drawing-mode:dominant))

(define-integrable (clear-point x y)
  (draw-point/internal x y drawing-mode:erase))

(define (draw-pixel x y #!optional drawing-mode)
  (if (default-object? drawing-mode)
      (graphics-pixel (round x) (round y))
      (draw-point/internal x y drawing-mode)))

(define (draw-point/internal x y drawing-mode)
  (with-graphics-drawing-mode drawing-mode
    (lambda ()
      (graphics-pixel (round x) (round y)))))

(define-integrable (draw-line-to x y)
  (graphics-line (round x) (round y)))

(define (draw-line x y #!optional line-style)
  (if (default-object? line-style)
      (draw-line-to x y)
      (draw-line/internal x y line-style)))

(define (erase-line x y)
  (with-graphics-drawing-mode drawing-mode:erase
    (lambda ()
      (draw-line/internal x y 1))))

(define (draw-line/internal x y line-style)
  (with-graphics-line-style line-style
    (lambda ()
      (graphics-line (round x) (round y)))))

(define (print-graphics filename)
  (prim-print-graphics (canonicalize-output-filename filename)))

(define (print-graphics-inverse filename)
  (prim-print-graphics-inverse (canonicalize-output-filename filename)))

(define (set-graphics-drawing-mode drawing-mode)
  (graphics-set-drawing-mode drawing-mode)
  (set! *graphics-drawing-mode* drawing-mode))

(define (with-graphics-drawing-mode drawing-mode thunk)
  (dynamic-wind (lambda ()
		  (graphics-set-drawing-mode drawing-mode))
	        thunk
		(lambda ()
		  (graphics-set-drawing-mode *graphics-drawing-mode*))))

(define (set-graphics-line-style line-style)
  (graphics-set-line-style line-style)
  (set! *graphics-line-style* line-style))

(define (with-graphics-line-style line-style thunk)
  (dynamic-wind (lambda ()
		  (graphics-set-line-style line-style))
		thunk
		(lambda ()
		  (graphics-set-line-style *graphics-line-style*))))

;;;; Character Stuff

(define *graphics-character-size*)
(define *graphics-character-aspect*)
(define *graphics-character-slant*)
(define *graphics-character-rotation*)

(define (graphics-text text #!optional size rotation aspect slant)
  (with-character-attributes
   (if (default-object? size) *graphics-character-size* size)
   (if (default-object? rotation) *graphics-character-rotation* rotation)
   (if (default-object? aspect) *graphics-character-aspect* aspect)
   (if (default-object? slant) *graphics-character-slant* slant)
   (lambda () (graphics-label text))))

(define (set-default-character-attributes!)
  (set! *graphics-character-size* 50)
  (set! *graphics-character-aspect* 0.7)
  (set! *graphics-character-slant* 0)
  (set! *graphics-character-rotation* 0))

(define (reset-character-attributes!)
  (graphics-set-letter *graphics-character-size*
		       *graphics-character-aspect*
		       *graphics-character-slant*)
  (graphics-set-rotation *graphics-character-rotation*))

(define (set-character-attributes! #!optional size rotation aspect slant)
  (if (not (default-object? size)) (set! *graphics-character-size* size))
  (if (not (default-object? aspect)) (set! *graphics-character-aspect* aspect))
  (if (not (default-object? slant)) (set! *graphics-character-slant* slant))
  (if (not (default-object? rotation))
      (set! *graphics-character-rotation* rotation))
  true)

(define (with-character-attributes size rotation aspect slant thunk)
  (let ((old-size) (old-rot) (old-aspect) (old-slant))
    (dynamic-wind
     (lambda ()
       (set! old-size (set! *graphics-character-size* size))
       (set! old-rot (set! *graphics-character-rotation* rotation))
       (set! old-aspect (set! *graphics-character-aspect* aspect))
       (set! old-slant (set! *graphics-character-slant* slant))
       (reset-character-attributes!))
     thunk
     (lambda ()
       (set! *graphics-character-size* (set! old-size size))
       (set! *graphics-character-rotation* (set! old-rot rotation))
       (set! *graphics-character-aspect* (set! old-aspect aspect))
       (set! *graphics-character-slant* (set! old-slant slant))
       (reset-character-attributes!)))))