/* mktemp.c zilla - substitute mktemp. process- and MACHINE-unique filenames.
 * i.e. processes N on two different machines will create different names.
 * Used by cgmm
 * modified
 * 26sep
 * 30apr        logic change in mktemp
 * 18feb        major rewrite
 * aug          port to unix
 */

#include <theusual.h>
#include <assert.h>
#include <constants.h>

/* use our own local random number generator:
 * 1. dont depend on having ZS available for linking
 * 2. dont want to risk altering the seed of the ZS generator
 *    as a bug/side effect.  - this could mess up other code!
 */

static int4 my_rndseed = 31415927;

#   define rnd_a  16807
#   define rnd_m  2147483647
#   define rnd_q  127773		/* m div a */
#   define rnd_r  2836		/* m mod a */

static int4 myrnd()
{
    register int4 lo,hi,test;

    hi = my_rndseed / rnd_q;
    lo = my_rndseed % rnd_q;
    test = rnd_a * lo - rnd_r * hi;
    if (test > 0) 
	my_rndseed = test;
    else
	my_rndseed = test + rnd_m;

    return(my_rndseed);
} /*myrnd*/


#if Emac
/* caller should pass a string with a string of XXXXXXXXXXXs in it.
 * fills in XXXXXX with random characters
 */
char *
Zmktemp(as)
  char *as;
{
  char tmpbuf[CMAXPATH];
  register char *s,*t;
  long savseed;
  
  s = as;
  while(*s && *s != 'X') s++;
  
  if (*s == 'X') {
    my_rndseed = Zcurtime();
    
    while(*s == 'X') {
      *s++ = (char)((int)'A' + (myrnd()%26));
    }    
  }
  else Zquit(1,"Zmktemp bad arg\n");
  
  return(as);
}
#endif /*mac*/


#if Eunix
/* caller should pass a string with a LONG string of XXXXXXXXXXXs in it.
 * fills in XXXXXX with 1. pid, 2. gethostid, 3. random characters
 * Callers argument string is NOT modified!
 */

char *
Zmktemp(template)
  char *template;
{
  char tmpbuf[CMAXPATH];
  static char sbuf[CMAXPATH];
  register char *s,*t,*u;
  
  t = template;
  s = sbuf;
  while(*t != 'X') *s++ = *t++;
  
  sprintf(tmpbuf,"%d.%d.",getpid(),gethostid());
  u = tmpbuf;
  while((*t == 'X') && (*u != (char)0)) {
    *s = *u;
    s++; t++; u++;
  }
  
  if (*t == 'X') {
    my_rndseed = Zcurtime();
    
    while(*t == 'X') {
      *s++ = (char)((int)'A' + (myrnd()%26));
      t++;
    }    
  }
  
  Ztrace(("Zmktemp %s\n",sbuf));
  return(sbuf);
}
#endif /*unix*/


/* return a string which is unique to the host,
 * and hopefully across the net.
 * The string will even usually be unique within a given prefix,
 * but this is not guaranteed.
 */

#if Eunix
char *
Zuniqnam(prefix)
     char *prefix;
{
  static char tmpbuf[CMAXPATH];
  char tmpbuf2[CMAXPATH];
  register char *s;
  int i;
  
  str_cpy(tmpbuf,prefix);
  sprintf(tmpbuf2,"%d%d",getpid(),gethostid());
  str_cat(tmpbuf,tmpbuf2);
  
  /* goto end of string */
  s = tmpbuf;	while(*s) s++;
  
  /* add 4 random characters too! */
  my_rndseed = Zcurtime();
  
  for( i=0; i < 4; i++ ) {
    *s++ = (char)((int)'A' + (myrnd()%26));
  }
  
  assert((s-tmpbuf) < CMAXPATH);
  *s = (char)0;
  
  return(tmpbuf);
}/*uniqnam*/
#endif


#if Emac
char *
Zuniqnam(prefix)
     char *prefix;
{
  static char tmpbuf[CMAXPATH];
  register char *s;
  int i;
  
  str_cpy(tmpbuf,prefix);
  
  /* goto end of string */
  s = tmpbuf;	while(*s) s++;
  
  /* add 4 random characters too! */
  my_rndseed = Zcurtime();
  
  for( i=0; i < 6; i++ ) {
    *s++ = (char)((int)'A' + (myrnd()%26));
  }
  
  assert((s-tmpbuf) < CMAXPATH);
  *s = (char)0;
  
  return(tmpbuf);
}/*uniqnam*/
#endif /*mac*/



