#!/bin/sh

# This script creates an interpreter that is linked together statically
# with your extensions (on machines that don't support incremental linking).
# 
# The first argument is the executable to be created, the remaining
# arguments are the .o-files of your extensions and optional libraries.
#
# For example, to create an instance of the interpreter containing the X11
# extensions and all the Athena widgets, call in the toplevel directory:
#
#   src/link-scheme xscheme lib/util/*.o lib/xt/*.o lib/xaw/*.o
#                           -lXaw -lXt -lXmu -lXext -lX11 

if [ $# = 0 ]
then
    echo Usage: "$0: output-file [object-files]"
    exit 1
fi
ofiles=@ofiles@
aout=$1
if [ -f $aout ]
then
    echo $aout already exists.
    exit 1
fi
shift
extensions=$*

# A special case is required for AIX.  The AIX linker discards all object
# files whose external symbols are not referenced.  This stupid `garbage
# collection' cannot be switched off.  Since extensions do not have entry
# points that are called directly, they are garbage collected away by the
# linker (the interpreter scans its symbol table on startup to find the
# entry points and calls them indirectly by using the symbol values).
#
# To avoid this, we have to create an `export list' containing at least one
# external function from each extension.  We are using the init_ functions,
# as it is guaranteed that each extensions exports at least one such function.
#
# We grep in the nm output for all lines of this form (i.e. entries that
# start with .init_ and have a symbol type of "extern"):
# 
# .init_foobar      |    113520|extern|             |      |     |.text
#
# then select the symbol name, and delete the initial period.

case @system@ in
*-aix*-*)
    echo Creating export list for stupid AIX linker:
    for e in $extensions
    do
	case $e in
	-l*) ;;
	  *)
	    nm -e $e | grep '^\.init_.*|extern|' | sed -e 's/[|.]//g' \
		| awk '{print $1}' >> exportlist
	    ;;
	esac
    done
    cat exportlist
    @cc@ -o $aout -bexport:exportlist $ofiles $extensions @ldflags@
    rm exportlist
    ;;
*)
    @cc@ -o $aout $ofiles $extensions @ldflags@
    ;;
esac
chmod +x $aout
