/* frame class */

/*
 * Copyright 1989 Jonathan Lee.  All rights reserved.
 *
 * Permission to use, copy, and/or distribute for any purpose and
 * without fee is hereby granted, provided that both the above copyright
 * notice and this permission notice appear in all copies and derived works.
 * Fees for distribution or use of this software or derived works may only
 * be charged with express written permission of the copyright holder.
 * This software is provided ``as is'' without express or implied warranty.
 */

#ifndef lint
static char SccsId[] = "@(#)Frame.c	1.9 2/23/90";
#endif

#include "fools.h"

/* Return a new frame whose parent is par (a NULL parent may be specified). */
Obj newFrame(alloc, par)
     F_OBJ alloc;
     Obj par;
{
    Obj new;

    new = (*alloc)(Frame);
    if (DATA(new, parent, frameInst) = par) objLink(par);

    return new;
}

/* Compare key to the symbol stored in the binding.  Returns negative if
 * the key is less than, zero if equal, or positive if greater than the
 * binding. */
static int fgetcmp(key, binding)
     Obj key, binding;
{
    return (long)key - (long)objCar(binding);
}

/* Get the binding of key in frame (returns NULL if key is not defined). */
Obj objGetBinding(key, frame)
     Obj key, frame;
{
    Tree ret;
    Obj ptr;

    if (ret = DATA(frame, local, frameInst))
	if (ret = treeFind((Ptr)key, ret, fgetcmp))
	    return (Obj)treeRoot(ret);

    if (ptr = DATA(frame, formals, frameInst)) {
	int offset;

	offset = 0;
	while (CLASS(ptr) == Pair) {
	    if (key == objCar(ptr))
		return newFBinding(gcTemp, key, 0, offset);
	    offset++;
	    ptr = objCdr(ptr);
	}
    }

    return (Obj)NULL;
}

/* Get the val bound to key in frame (returns NULL if key is not defined). */
Obj objGet(key, frame)
     Obj key, frame;
{
    Tree ret;
    Obj *fixed;

    /* create tree for locals when necesary */
    if (ret = DATA(frame, local, frameInst))
	if (ret = treeFind((Ptr)key, ret, fgetcmp))
	    return objUnbind((Obj)treeRoot(ret), frame);

    if (fixed = DATA(frame, fixed, frameInst)) {
	Obj ptr;

	ptr = DATA(frame, formals, frameInst);
	while (CLASS(ptr) == Pair) {
	    if (key == objCar(ptr))
		return *fixed;
	    fixed++;
	    ptr = objCdr(ptr);
	}
    }

    return (Obj)NULL;
}

/* Get the first val bound to key in the frame->parent chain (returns
 * NULL if not key is not defined). */
Obj objLookup(key, frame)
     Obj key, frame;
{
    Obj val;
    
    while (frame) {
	if (val = objGet(key, frame)) return val;
	frame = DATA(frame, parent, frameInst);
    }
    return (Obj)NULL;
}

struct finsert_s {
    Obj key, val;
};

/* compare symbol field of key to the symbol in the car of binding */
static int fcmp(key, binding)
     struct finsert_s *key;
     Obj binding;
{
    return (long)key->key - (long)objCar(binding);
}

/* Decide what to put in the tree.  When old is NULL, the node is empty
 * so a new binding pair can be made.  Otherwise, old is destructively
 * modified to incorporate the new value. */
static Ptr finsert(new, old)
     struct finsert_s *new;
     Obj old;
{
    Obj ret;
    
    if (old) {
	objSetCdr(old, new->val);
	return (Ptr)old;
    }
    ret = newBinding(gcNew, new->key, new->val);
    objLink(ret);

    return (Ptr)ret;
}

/* Bind key to value in frame and return the binding.  If a binding for
 * key already exists, a new binding is not created--the original is
 * modified. */
Obj objPut(key, item, frame)
     Obj key, item, frame;
{
    struct finsert_s binding;
    Tree t;

    binding.key = key;
    binding.val = item;

    if ((t = DATA(frame, local, frameInst)) == (Tree)NULL)
	DATA(frame, local, frameInst) = t = treeNew();

    return (Obj)treeInsert((Ptr)&binding, t, fcmp, finsert);
}

/* Move the fixed vector of frame from stack to heap
 *
 * If link is TRUE then each obj in the fixed vector is linked. */
void saveFrame(frame, link)
     Obj frame;
     Boolean link;
{
    int numfixed;
    Obj *new, *old, temp;

    ASSERT(objIsClass(frame, Frame) && !checkCond(frame, ZAP));
    setCond(frame, ZAP);
    if ((numfixed = DATA(frame, numfixed, frameInst)) == 0) return ;

    old = DATA(frame, fixed, frameInst);
    DATA(frame, fixed, frameInst) = new =
	(numfixed > 0) ? NEWVEC(Obj, numfixed) : (Obj *)NULL;

    if (link) {
	while (--numfixed >= 0)
	    if (temp = *new++ = *old++)
		objLink(temp);
    }
    else while (--numfixed >= 0) *new++ = *old++;
}

/* Unlink the parent frame, free the tree used as local storage, unlink
 * its bindings, and free the fixed binding vector. */
static void frameDestroy(frame)
     Obj frame;
{
    Tree ptr;
    Obj *fixed, temp;

    if ((temp = DATA(frame, parent, frameInst)) != (Obj)NULL)
	objUnlink(temp);
    if (ptr = DATA(frame, local, frameInst))
	treeFree(ptr, _objUnlink);
    if ((temp = DATA(frame, formals, frameInst)) != (Obj)NULL)
	objUnlink(temp);
    if (fixed = DATA(frame, fixed, frameInst)) {
	int num, save;

	num = save = DATA(frame, numfixed, frameInst);
	while (--num >= 0) {
	    Obj val = *fixed++;
	    if (val) objUnlink(val);
	}
	if (checkCond(frame, ZAP)) {
	    if (save > 0)
		(void)free((char *)DATA(frame, fixed, frameInst));
	}
    }
}

/* frame class struct */
basicClass_t protoFrame =
    DEFBASIC(Basic, frameInst_t, (F_VOID)NULL, frameDestroy, "frame");
