; -*- Mode: Lisp; Syntax: Common-Lisp; -*-
; File files.lisp / Copyright (c) 1989 Jonathan Rees / See file COPYING

(lisp:defparameter translator-files
  '("P-RECORD"   ; record package
    "P-UTILS"    ; tables and fluids
    "LIST"       ; list utilities
    "NODE"       ; budding node abstraction
    "ALPHA"      ; front end
    "DERIVE"     ; derived expression types
    "SCHEMIFY"   ; degenerate back end
    "MODULE"	 ; signatures and meta-environments
    "SSIG"	 ; Scheme signature
    "STRATEGY"	 ; LETREC strategy anaylzer
    "VERSION"

    ;; CL-specific stuff
    "EMIT"	 ; code emission utilities
    "GENERATE"   ; CL code generator
    "BUILTIN"    ; CL info about scheme built-ins
    "TRANSLATE"	 ; phase coordination and file transducer
    ))

(lisp:defparameter *boot-file-type*
  (preferred-case #+:DEC "BOOT-FAS" #-:DEC "BBIN"))

#+Symbolics
(lisp:progn 
  (fs:define-canonical-type :boot-bin #,*boot-file-type*)

  (lisp:setq fs:*auxiliary-loadable-file-types*
	     (cons '(:boot-bin :load-stream-function
			       si:load-binary-file-internal)
		   (lisp:remove :boot-bin fs:*auxiliary-loadable-file-types*
				:key #'car)))

  (lisp:setf (lisp:get :boot-bin :binary-file-byte-size)
	     (lisp:get :bin :binary-file-byte-size)))
