;;; Flags for open(2) and fcntl(2).
;;; Copyright (c) 1993 by Olin Shivers.

(define-syntax define-open-flags
  (syntax-rules ()
    ((define-errnos form ...)
     (begin (define-enum-constant "open" . form) ...))))

(define-open-flags
  (read			0)
  (write		1)
  (read+write		2)
  (append		8)
  (create		#x0200)
  (exclusive		#x0800)
  (no-control-tty	#x8000)
  (nonblocking		#x4000)
  (truncate		#x0400)

;;; Not POSIX.
  (no-delay	4)
  (sync		#x2000))

(define open/access-mask
  (bitwise-ior open/read
	       (bitwise-ior open/write open/read+write)))
