;;; The packages that scsh uses/defines.
;;; Copyright (c) 1994 by Olin Shivers.

;;; You link up a scsh package by defining a package named OS-DEPENDENT
;;; that provides the POSIX-FDFLAGS POSIX-ERRNO and POSIX-SIGNALS interfaces.
;;; Anything else it provides should be specified in an interface called
;;; OS-EXTRAS-INTERFACE. See the SCSH structure below.
;;; Then the SCSH structure can be instantiated.
;;;
;;; The architecture directories, like next/ and irix/ and so forth,
;;; provide packages that can serve as the OS-DEPENDENT package. E.g.,
;;; the NEXT-DEFS package, defined in next/packages.
;;;
;;; This whole mechanism would be better solved with a functor.
;;;     -Olin


(define-structure error-package (export error)
  (open signals))


(define-structure scsh-utilities scsh-utilities-interface
  (open scheme bitwise error-package)
  (files utilities))


;;; This guy goes into the FOR-SYNTAX part of scsh's syntax exports.
(define-structure scsh-syntax-helpers
  (export transcribe-extended-process-form)
  (open scheme
	receiving	; receive
	error-package
	syntactic	; generated?
	scsh-utilities	; check-arg, optional-arg
	)
  (files syntax-helpers))


(define-structure scsh-regexp-package scsh-regexp-interface
  (open	defrec-package
	scsh-utilities
	define-foreign-syntax
	receiving
	error-package
	scheme)
  (files re))


(define-structure char-set-package char-set-interface  
  (open scheme ascii)
  (files char-set))


;; When I hack READ-DELIMITED! to to Unix ports in C, we'll also need
;; DEFINE-FOREIGN, ERRNO-ERROR and FD-INPORT?

(define-structure field-reader-package scsh-field-reader-interface
  (open scheme
	receiving		; receive
	char-set-package
	scsh-utilities
	error-package		; error
	scsh-regexp-package
	)
  (files fr))


(define-structures
  ((awk-expander-package (export expand-awk))
   (awk-support-package (export next-range next-:range
				next-range: next-:range:)))
  (open scheme
	receiving		; receive
	scsh-utilities	
	error-package		; error
	char-set-package
	)
  (files awk))
	 

(define-structure awk-package awk-interface
  (open scheme awk-support-package scsh-regexp-package receiving)
  (for-syntax (open scheme awk-expander-package))
  (begin (define-syntax awk expand-awk)))


(define-structure scsh
  (compound-interface posix-fdflags-interface
		      posix-errno-interface
		      posix-signals-interface
		      sockets-network-interface	; Standard Network Interface
		      os-extras-interface	; Extra stuff from OS.
		      scsh-errors-interface
		      scsh-io-interface
		      scsh-file-interface
		      scsh-process-interface
		      scsh-process-state-interface
		      scsh-user/group-db-interface
		      scsh-command-line-interface
		      scsh-signals-interface
		      scsh-environment-interface
		      scsh-home-interface
		      scsh-string-interface
		      scsh-file-names-interface
		      scsh-misc-interface
		      scsh-high-level-process-interface
		      scsh-starter-interface
		      scsh-time-interface 		; new in 0.2
		      scsh-sockets-interface 		; new in 0.3
		      scsh-field-reader-interface 	; new in 0.3

		      ;; This stuff would probably be better off kept
		      ;; in separate modules, but we'll toss it in for now.
		      (interface-of ascii)		; char<->ascii
		      string-ports-interface
		      awk-interface
		      )
  (for-syntax (open scheme scsh-syntax-helpers))
  (open externals
	structure-refs
	cig-aux
	receiving
	defrec-package
	define-foreign-syntax
	formats
	os-dependent	; OS dependent stuff.
	ascii
	records
	extended-ports
	ports
	build
	bigbit
	bitwise
	signals
	conditions
	scsh-utilities
	handle
	fluids
	scheme

	scsh-regexp-package
	char-set-package
	
	awk-package
	field-reader-package
	)

  (access command-processor
	  environments
	  escapes
	  ports		; S48's force-output
	  scheme	; For accessing the normal I/O operators.
	  formats
	  records)
  (begin
    (define set-batch-mode?! (structure-ref command-processor
					    set-batch-mode?!))
    (define with-continuation (structure-ref escapes with-continuation))
    (define start-command-processor
      (structure-ref command-processor start-command-processor))
    (define environment-for-commands
      (structure-ref command-processor environment-for-commands))
    (define command-loop
      (structure-ref command-processor command-loop))
    (define with-interaction-environment
      (structure-ref environments with-interaction-environment))
    (define user-context (structure-ref command-processor user-context)))
  (files syntax
	 syscalls
	 fname
	 stringcoll
	 scsh-condition
	 rw
	 newports
	 fdports
	 wait
	 waitcodes		; OS dependent code.
	 filesys
	 fileinfo
	 glob
	 filemtch
	 time			; New in release 0.2.
	 network		; New in release 0.3.
	 scsh
	 top))

(define-structure defrec-package (export (define-record :syntax))
  (open scheme records)
  (files defrec))

(define-structure defenum-package (export (define-enum-constant :syntax))
  (files enumconst))
