;;; Signal constant definitions for "generic"
;;; Copyright (c) 1994 by Olin Shivers.
;;; Copyright (c) 1994 by Brian D. Carlstrom.

(define-syntax define-signals
  (syntax-rules ()
    ((define-signals form ...)
     (begin (define-enum-constant "signal" . form) ...))))

;;POSIX only defined here.

(define-signals
  ;; POSIX
  (hup	1)	; hangup 
  (int	2)	; interrupt 
  (quit	3)	; quit 
  (ill	4)	; illegal instruction (not reset when caught) 
  (trap 5)      ; trace trap (not reset when caught)
  (iot	6)	; IOT instruction 
  (abrt	6)	; compat
  (emt	7)	; EMT instruction 
  (fpe	8)	; floating point exception 
  (kill	9)	; kill (cannot be caught or ignored) 
  (segv	11)	; segmentation violation
  (sys  12)     ; bad argument to system call
  (pipe	13)	; write on a pipe with no one to read it 
  (alrm	14)	; alarm clock 
  (term	15)	; software termination signal from kill 
  (urg  16)     ; urgent condition on IO channel
  (stop	17)	; sendable stop signal not from tty 
  (tstp	18)	; stop signal from tty 
  (cont	19)	; continue a stopped process 
  (chld	20)	; to parent on child stop or exit 
  (cld  20)     ; compat				
  (ttin	21)	; to readers pgrp upon background tty read 
  (ttou	22)	; like TTIN for output if (tp->t_local&LTOSTOP) 
  (io   23)     ; input/output possible signal
  (xcpu 24)     ; exceeded cpu time limit
  (xfsz 25)     ; exceeded file size limit
  (vtalrm 26)   ; virtual time alarm
  (prof 27)     ; profiling time alarm
  (winch 28)    ; window size changes
  (lost	29)     ; sys-v rec lock: notify user upon server crash
  
  ;; User defined
  (usr1 30)	; user defined signal 1 
  (usr2 31)	; user defined signal 2 
  )
