;;;; Utility functions for debugging in Scheme.

;;; Print writes all it's arguments, separated by spaces.  Print
;;; outputs a newline at the end and returns the value of the last
;;; argument.
(define (print . args)
  (define result #f)
  (for-each (lambda (x) (set! result x) (write x) (display #\ )) args)
  (newline)
  result)

;;; TRACEF REALLY NEEDS A `PRINT ANYTHING ON ONE LINE' ROUTINE.  DOES
;;; SOMEONE CARE TO WRITE IT?

;;; to TRACE type
;;; (set! <symbol> (tracef <symbol>)) or
;;; (set! <symbol> (tracef <symbol> '<symbol>)) or
;;; (define <symbol> (tracef <function>)) or
;;; (define <symbol> (tracef <function> '<symbol>))

;;; to UNTRACE type
;;; (set! <symbol> (untracef <symbol>))

(define tracef
  (let ((null? null?)			;These bindings are so that
	(not not)			;tracef will not trace parts
	(car car)			;of itself.
	(cdr cdr)
	(eq? eq?)
	(write write)
	(display display)
	(newline newline)
	(apply apply)
	(for-each for-each))
    (lambda (function . optname)
      (let ((name (if (null? optname) function (car optname))))
	(lambda args
	  (cond ((and (not (null? args))
		      (eq? (car args) '**special-untrace-object**)
		      (null? (cdr args)))
		 function)
		(else
		 (display "CALL [")
		 (write name)
		 (display #\ )
		 (for-each (lambda (x) (write x) (display #\ )) args)
		 (display "]")
		 (newline)
		 (let ((ans (apply function args)))
		   (display "RETURNED [")
		   (write name)
		   (display " ==> " )
		   (write ans)
		   (display "]")
		   (newline)
		   ans))))))))

;;; the reason I use a symbol for **special-untrace-object** is so
;;; that functions can still be untraced if this file is read in twice.

(define (untracef function)
  (function '**special-untrace-object**))

;;;; MODULES
;;; Modules have been eliminated from common-lisp but here they are
;;; for Scheme:

(define *modules* '())

(define (provide <module-name>)
  (if (symbol? <module-name>)
      (set! <module-name> (symbol->string <module-name>)))
  (if (not (member <module-name> *modules*))
      (set! *modules* (cons <module-name> *modules*))))

(define (require <module-name> . opts)
  (if (not (member <module-name> *modules*))
      (if (null? opts)
	  (load (if (symbol? <module-name>)
		    (symbol->string <module-name>)
		    <module-name>))
	  (for-each load opts))))
