/* Scheme implementation intended for JACAL.
   Copyright (C) 1990, 1991, 1992 Aubrey Jaffer.
   See the file "COPYING" for terms applying to this program */

#ifdef vms
# ifndef CHEAP_CONTINUATIONS

   typedef int jmp_buf[17];
   extern int setjump(jmp_buf env);
   extern int longjump(jmp_buf env, int ret);

#  define setjmp setjump
#  define longjmp longjump
# else
#  include <setjmp.h>
# endif
#else				/* ndef vms */
# include <setjmp.h>
#endif				/* ndef vms */

typedef struct {jmp_buf jmpbuf; SCM dynenv;} regs;
#define JMPBUF(x) (((regs *)CHARS(x))->jmpbuf)
#define SETJMPBUF SETCDR
#define DYNENV(x) (((regs *)CHARS(x))->dynenv)
extern SCM dynwinds;
void dowinds();
