; "dynwind.scm", wind-unwind-protect for Scheme
; Copyright (c) 1992, Aubrey Jaffer

;This facility is a generalization of Common Lisp `unwind-protect',
;designed to take into account the fact that continuations produced by
;CALL-WITH-CURRENT-CONTINUATION may be reentered.

;  (dynamic-wind <thunk1> <thunk2> <thunk3>)		procedure

;The arguments <thunk1>, <thunk2>, and <thunk3> must all be procedures
;of no arguments (thunks).

;DYNAMIC-WIND calls <thunk1>, <thunk2>, and then <thunk3>.  The value
;returned by <thunk2> is returned as the result of DYNAMIC-WIND.
;<thunk3> is also called just before <thunk2> calls any continuations
;created by CALL-WITH-CURRENT-CONTINUATION.  If <thunk2> captures its
;continuation as an escape procedure, <thunk1> is invoked just before
;continuing that continuation.

;;;WARNING: This code has no provision for dealing with errors or
;;;interrupts.  If an error or interrupt occurs while using
;;;dynamic-wind, the dynamic environment will be that in effect at the
;;;time of the error or interrupt.

(define dynamic:winds '())

(define (dynamic-wind <thunk1> <thunk2> <thunk3>)
  (<thunk1>)
  (set! dynamic:winds (cons (cons <thunk1> <thunk3>) dynamic:winds))
  (let ((ans (<thunk2>)))
    (set! dynamic:winds (cdr dynamic:winds))
    (<thunk3>)
    ans))

(define call-with-current-continuation
  (let ((oldcc call-with-current-continuation))
    (lambda (proc)
      (let ((winds dynamic:winds))
	(oldcc
	 (lambda (cont)
	   (proc (lambda (c2)
		   (dynamic:do-winds winds (- (length dynamic:winds)
					      (length winds)))
		   (cont c2)))))))))

(define (dynamic:do-winds to delta)
  (cond ((eq? dynamic:winds to))
	((negative? delta)
	 (dynamic:do-winds (cdr to) (+ 1 delta))
	 ((caar to))
	 (set! dynamic:winds to))
	(else
	 (let ((from (cdar dynamic:winds)))
	   (set! dynamic:winds (cdr dynamic:winds))
	   (from)
	   (dynamic:do-winds to (+ -1 delta))))))
