; By david carlton, carlton@husc.harvard.edu.  This code is in the
; public domain.

;  (VALUES <obj> ...)					procedure
;
;The VALUES procedure takes any number of arguments, and passes
;(returms) them to its continuation.
;
;  (CALL-WITH-VALUES <thunk> <proc>)			procedure
;
;<Thunk> must be a procedure of no arguments, and <proc> must be a
;procedure.  CALL-WITH-VALUES calls <thunk> with a continuation that,
;when passed some values, calls <proc> with those values as arguments.
;
;Except for continuations created by the CALL-WITH-VALUES procedure,
;all continuations take exactly one value, as now; the effect of
;passing no value or more than one value to continuations that were not
;created by the CALL-WITH-VALUES procedure is unspecified.

(require 'record)

(define values:*values-rtd*
  (make-record-type "values"
		    '(values)))

(define values
  (let ((make-values (record-constructor values:*values-rtd*)))
    (lambda x
      (if (and (not (null? x))
	       (null? (cdr x)))
	  (car x)
	  (make-values x)))))

(define call-with-values
  (let ((access-values (record-accessor values:*values-rtd* 'values))
	(values-predicate? (record-predicate values:*values-rtd*)))
    (lambda (producer consumer)
      (let ((result (producer)))
	(if (values-predicate? result)
	    (apply consumer (access-values result))
	    (consumer result))))))
