@part[PREFACE, Root "TMAN.MSS"]         @comment{ -*-System:TMAN-*-}


@XPrefaceSection[Preface]

This manual describes @tau[], a programming language being developed at the
Yale University Computer Science Department@Cite[Rees82], and its
current implementations.  It is a reference manual, intended to define
the language and to describe the general direction of its development.
It is @i[not] intended as an introduction or a tutorial.

The bulk of this document describes @tau[] as a programming language.
However, chapters @ref[Program Chapter],
@ref[User chapter],
and @ref[Debugging Chapter] describe pragmatic features which are
specific to the current implementations.  To help underscore the
distinction between language and implementation, the implementations
are referred to not as
@i[@tau[]] but as @i[@timp[]].

The reader is expected to have some programming experience; the reader
may also find a knowledge of Lisp helpful, although @tau[] is different
enough from Lisp that prior experience with Lisp might actually be
a hindrance.

Chapter @ref[FutureChapter] describes ways in which
the language is deficient and directions in which it is likely to grow.
Also, the implementations are not faithful to the language definition presented
in the manual; section @ref[BugsSection] catalogs known deviations.

Please send questions and comments about the language, this manual,
or the various implementations of the system, via ARPAnet mail to
Rees@@Yale.ARPA, Usenet mail to ...decvax!yale-comix!rees, or via U.S.
Mail to

@begin[display]
Jonathan Rees
Department of Computer Science
Yale University
P.O. Box 2158 Yale Station
New Haven, Connecticut 06520
Telephone (203) 432-4666
@end[display]

Announcements of interest to @Tau[] users are regularly broadcast
via Arpanet and Usenet electronic mail to the mailing list
T-Users@@Yale.ARPA; send mail to T-Users-Request@@Yale.ARPA if you
want to be added to (or removed from) this list.  Send reports
about errors in the manual or implementations to T-Bugs@@Yale.ARPA.



James R. Meehan's current address is:
@begin[display]
Cognitive Systems, Inc.
234 Church St.
New Haven, Connecticut 06510
@end[display]

The @Tau[] project has been funded exclusively by the Computing Facility
of the Yale Computer Science Department.

TOPS-20, VMS, and VAX are trademarks of Digital Equipment Corporation.
Domain and Aegis are trademarks of Apollo Computer, Inc.  UNIX is a
trademark of Bell Laboratories.


@XPrefaceSection[Notes on this edition]

The fourth edition includes, among others, the following additions
and changes, many of which correspond to new features in @Timp[] version
2.7:
@itemize[
    New procedures:
    bitwise logical operators,
    @tc[MAKE-LOCALE], @tc[MAKE-EMPTY-LOCALE], @tc[LOCALE?]
    @tc[*VALUE],
    @tc[*DEFINE],
    @tc[*LSET],
    @tc[CHAR->STRING],
    @tc[ASSERT],
    @tc[SYNTAX-ERROR],
    @tc[READ-ERROR],
    @tc[PROJ1] et al.,
    @tc[OBJECT-HASH],
    @tc[OBJECT-UNHASH],
    @tc[WALK-POPULATION],
    @tc[MAKE-LIST-READER],
    @tc[MAKE-READ-TABLE],
    @tc[MACRO-EXPANDER?],
    @tc[INVOKE-MACRO-EXPANDER],
    @tc[OBJECT-FILE?],
    @tc[OBJECT-FILE-STREAM?],
    @tc[TC-SYNTAX-TABLE],
    @tc[TC-MACRO-DEFINITION-ENV],
    @tc[WRITE-LINE],
    @tc[WRITE-SPACES],
    @tc[MAKE-BROADCAST-STREAM].

    New special forms: @tc[IMPORT], @tc[MODIFY],
    @tc[DEFINE-LOCAL-SYNTAX], @tc[MACRO-EXPANDER],
    @tc[COMMENT], @tc[IGNORE], @tc[IGNORABLE].

    New character names (@tc[LEFT-PAREN] and others).

    Escape character syntax explained.

    Sample implementation of @tc[DELAY] and @tc[FORCE] provided.

    Name changes: @tc[*THE-USER-ENV*] is now called @tc[*SCRATCH-ENV*];
    @tc[*THE-BASE-ENV*] is @tc[*STANDARD-ENV*];
    @tc[DEFINE-MACRO] is @tc[DEFINE-SYNTAX];
    @tc[GEN-ID] is @tc[GENERATE-SYMBOL];
    @tc[SYMBOLCONC] is @tc[CONCATENATE-SYMBOL].

    Features withdrawn: @tc[FLOOR], @tc[CEILING],
    @tc[ENV-LOOKUP],
    @tc[CONS-FROM-FREELIST],
    @tc[RETURN-TO-FREELIST],
    @tc[SET-DELIMITED-LIST-SYNTAX-IN-TABLE],
    dispatch read macros.
]

This document is still far from finished.  Future work required
includes the following projects.

@begin[itemize]
The preface ought to have a paragraph or two describing the organization
of the manual.

The @qu"language overview" and @qu"language principles" sections need
to be expanded.
There should be a description of the memory model of objects,
in which objects are modeled by pointers into memory.

The form of procedure and special form description should be explained.

The section on types needs expansion and examples.

Tail recursion should be explained.

@tc[MAKE-ECHO-STREAM] should be described.

The external syntax of numbers should be described.  Chapter
@ref{Syntax Chapter} needs to give more detail.

Need to document @tc[HANDLER] so that people know what to set a structure
handler to.  Need to describe keyword clauses in @tc[OBJECT] syntax.

There should be examples of the use of @tc[JOIN] in implementing type
hierarchies and heterarchies.

The introduction to the streams chapter needs work.
Also, stream positions should be documented and implemented.

There should be a section giving a brief description of how the
implementation works at the machine level.  A full description should be
relegated to an independent document, which should be written.

Need to discuss the VM system and reorganize the presentation of the user
interface.  Many more remarks on error handling and debugging are in
order.
@end[itemize]

@XPrefaceSection[Acknowledgements]

The authors wish to thank Kent Pitman for his continuing assistance
in making @tau[] true.

Gerry Sussman has provided essential guidance and inspiration.

Guy Steele wrote most of the compiler we're using, and has otherwise
been a strong influence, originating much of the project's design
philosophy and shaping and inspiring many of its features.

This document borrows from the @i[Lisp Machine Manual] @cite[WEINREB81]
and the @i[Common Lisp Reference Manual] @cite[STEELE81COM].
We are grateful to their authors.

We wish to acknowledge the influence and valuable advice provided
during the design process by the following people at Yale, MIT, and
elsewhere:  Alan Bawden, Richard Bryan,
David Byrne,
George Carrette, William
Clinger, Peter Deutsch, John Ellis, William Ferguson, Christopher
Hanson, Carl Hoffman, David Kranz, David Littleboy,
Drew McDermott, Nathaniel Mishkin,
Robert Nix, Jim Philbin, John Ramsdell, Christopher Riesbeck, John
Ruttenberg, Olin Shivers, and Steve Wood.

Thanks to Judy Martel for her patient proofreading.

The NIL project at MIT was the source of many of @Tau[]'s good ideas.
NIL is the work of Richard Bryan, Glenn Burke, George Carrette, Michael
Genereseth, Robert Kerns, Jim Purtilo, John White, and one of the
present authors (JR).

Jim Purtilo wrote the integer arithmetic package used in the current
implementation while he was working on the NIL project.

We appreciate the patience of our user community, at Yale and elsewhere,
who have had to put up with an incompatible, incomplete, and untuned new
system.

Finally, we wish to thank John O'Donnell for helping to shelter us from
the real world, and for having the foresight, or perhaps folly, to
initiate the project in the first place.

@dc{ Send $5.00 for your name here. }

@dc{ where to put the trademark notices? }
