(herald (back_end riscgen)
  (env t (orbit_top defs)))

;;; Copyright (c) 1985 Yale University
;;;     Authors: N Adams, R Kelsey, D Kranz, J Philbin, J Rees.
;;; This material was developed by the T Project at the Yale University Computer 
;;; Science Department.  Permission to copy this software, to redistribute it, 
;;; and to use it for any purpose is granted, subject to the following restric-
;;; tions and understandings.
;;; 1. Any copy made of this software must include this copyright notice in full.
;;; 2. Users of this software agree to make their best efforts (a) to return
;;;    to the T Project at Yale any improvements or extensions that they make,
;;;    so that these may be included in future releases; and (b) to inform
;;;    the T Project of noteworthy uses of this software.
;;; 3. All materials developed as a consequence of the use of this software
;;;    shall duly acknowledge such use, in accordance with the usual standards
;;;    of acknowledging credit in academic research.
;;; 4. Yale has made no warrantee or representation that the operation of
;;;    this software will be error-free, and Yale is under no obligation to
;;;    provide any services, by way of maintenance, update, or otherwise.
;;; 5. In conjunction with products arising from the use of this material,
;;;    there shall be no use of the name of the Yale University nor of any
;;;    adaptation thereof in any advertising, promotional, or sales literature
;;;    without prior written consent from Yale in each case.
;;;

(define (generate-nil-test node)
  (destructure (((then else #f #f arg) (call-args node)))
    (let ((acc (->addressable node (leaf-value arg))))
      (emit-compare jump-op/jn= nil-reg acc then else))))


(define (generate-header-type-test node tag)
  (destructure (((then else #f #f arg) (call-args node)))
    (let ((acc (->register node (leaf-value arg))))
      (emit risc/and (machine-num #x7f) acc scratch)
      (emit-compare jump-op/jn= scratch (machine-num tag) else then))))

(define (generate-tag-type-test node tag)
  (destructure (((then else #f #f arg) (call-args node)))
    (let ((acc (->register node (leaf-value arg))))
      (emit risc/and (machine-num 3) acc scratch)
      (emit-compare jump-op/jn= scratch (machine-num tag) else then))))

(define (generate-nonvalue-test node)
  (destructure (((then else #f #f arg) (call-args node)))
    (let ((acc (->register node (leaf-value arg))))
      (emit risc/and (machine-num #xff) acc scratch)
      (emit-compare jump-op/jn= scratch (machine-num header/nonvalue) else then))))


(define (generate-one-arg node compute)
  (destructure (((cont arg) (call-args node)))
      (let* ((var (leaf-value arg))
             (acc (->register node var))
	     (t-reg (get-target-register node cont acc nil)))
	(compute acc t-reg)
	(mark-continuation node t-reg))))
    
(define (generate-closure-enclosing-object node)
  (generate-one-arg
   node
   (lambda (acc t-reg)
     (emit risc/load 'l (reg-offset acc -2) extra) ;template
     (emit risc/load 'uw (reg-offset extra template/pointer) scratch)
     (emit risc/sub scratch acc t-reg))))

(define (generate-template-enclosing-object node)
  (generate-one-arg
   node
   (lambda (acc t-reg)
     (emit risc/load 'l (reg-offset acc template/offset) scratch)
     (emit risc/sub scratch acc t-reg))))

;;; %make-extend template = AN, bytes = scratch, extend returned in an
(define (generate-make-vector-extend node)
  (destructure (((#f type length size) (call-args node)))
    (let ((acc (->register node (leaf-value length))))
      (free-register node AN)
      (emit risc/sll (machine-num 6) acc AN)
      (emit risc/or (machine-num (leaf-value type)) AN AN)
      (lock AN))
    (let ((acc (lookup-value node (leaf-value size))))
      (generate-move acc scratch)
      (generate-slink-call slink/make-extend))  
    (unlock AN)
    (mark-continuation node AN)))

(define (generate-make-extend node)
  (destructure (((#f template size) (call-args node)))
    (let ((acc (lookup-value node (leaf-value template))))
      (free-register node AN)
      (generate-move acc AN)
      (lock AN))
    (let ((acc (lookup-value node (leaf-value size))))
      (generate-move acc scratch)
      (generate-slink-call slink/make-extend))  
    (unlock AN)
    (mark-continuation node AN)))

(define (generate-make-cell node)
  (let* ((cont ((call-arg 1) node))
	 (reg (get-target-register node cont nil nil)))
    (cond ((and (lambda-node? cont)
		(eq? (variable-definition (car (lambda-variables cont))) 'one))
	   (mark-continuation node reg))
          (else
           (free-register node AN)
           (generate-move (machine-num 4) scratch)               ; 1 slot
           (generate-move (machine-num header/cell) AN)
           (generate-slink-call slink/make-extend)  
           (mark-continuation node AN)))))

;;; %make-pair returns pair in AN
(define (generate-make-pair node)
  (free-register node AN)
  (generate-slink-call slink/make-pair)
  (mark-continuation node AN))           


(define (generate-slink-ref node)
  (generate-primitive-reg-ref node 'slink))

(define (generate-task-ref node)
  (generate-primitive-reg-ref node 'task))

(define (generate-set-slink-ref node)
  (generate-set-primitive-reg-ref node 'slink))

(define (generate-set-task-ref node)
  (generate-set-primitive-reg-ref node 'task))


(define (generate-primitive-reg-ref node reg)
  (destructure (((cont arg) (call-args node)))
   (if (fixnum? (leaf-value arg))
    (let ((t-reg (get-target-register node cont nil nil)))
      (xcase reg
	((slink) (emit risc/load 'l (reg-offset nil-reg (leaf-value arg)) t-reg)))
      (mark-continuation node t-reg)))))
                                                                  

(define (generate-set-primitive-reg-ref node reg)
  (destructure (((#f arg val) (call-args node))) 
   (if (fixnum? (leaf-value arg))
       (let ((acc (->register node (leaf-value val))))
         (xcase reg
	   ((slink) (emit risc/store 'l acc (reg-offset nil-reg (leaf-value arg)))))))))

  
(define (generate-stack-pointer node)
  (let ((cont ((call-arg 1) node)))
    (let ((dest (get-target-register node cont nil nil)))
      (generate-move SP dest)
      (mark-continuation node dest))))

(define (generate-frame-header node)
  (generate-one-arg
   node
   (lambda (acc t-reg)
     (emit risc/load 'l (reg-offset acc -2) extra)
     (emit risc/sub (machine-num 2) extra t-reg))))

(define (generate-frame-sp node)
  (generate-one-arg
   node
   (lambda (acc t-reg)
     (emit risc/add (machine-num 2) acc t-reg))))

;;; %nary-setup required = scratch
(define (generate-nary-setup node required)             
  (if (eq? (lambda-strategy node) strategy/stack)
      (emit risc/sub NARGS zero NARGS))                           ; !!!
  (generate-move (machine-num required) vector)
  (generate-slink-call slink/nary-setup)  
  (mark (lambda-rest-var node) AN))

                                      
