(herald ieee_float
  (env tsys))

;;; Flonum dismemberment.

;;; Returns sign, and normalized mantissa and exponent  
;;; PRECISION is number of bits desired in the mantissa 
;;; EXCESS is the exponent excess
;;; HIDDEN-BIT-IS-1.? is true if the hidden bit preceeds the
;;;  binary point (it does in Apollo IEEE, does not on the VAX).

(define (normalize-float-parts sign m e precision excess hidden-bit-is-1.?)
  (let* ((have (integer-length m))
         (need (fx- precision have))
         (normalized-m (%ash m need))
         (normalized-e (- (+ e 
                             precision 
                             excess
                             (if hidden-bit-is-1.? -1 0))
                           need)))
     (return (if (= sign 1) 0 1) normalized-m normalized-e)))

;;; Floating point bit fields.

;;; <n,s> means bit field of length s beginning at bit n of the first
;;; WORD (not longword)
;;;                    sign      exponent   MSB       fraction
;;; Apollo IEEE flonum <15,1>    <4,11>     hidden    <0,4>+next 3 words
;;; VAX11 flonum (D)   <15,1>    <7,8>      hidden    <0,7>+next 3 words
;;; Apollo IEEE flonum - binary point follows  hidden MSB, 53 bits of
;;;     precision, if hidden bit is included
;;; VAX11 flonum (D)   - binary point precedes hidden MSB, 56 bits of
;;;     precision, if hidden bit is included 


(define (string->flonum s)
  (kludgy-string->flonum s))

(lset *print-flonums-kludgily?* t)

(define-handler double-float
  (object nil
    ((extended-number-type self) %%flonum-number-type)
    ((print self stream)
     (if *print-flonums-kludgily?*
         (print-flonum-kludgily self stream)
         (print-flonum self stream)))))
                                               
