;;; -*-Scheme-*-
;;;
;;; $Id: mitutil.sch,v 1.8 1993/02/25 22:28:31 cph Exp $
;;;
;;; Copyright (c) 1993 Massachusetts Institute of Technology
;;;
;;; This material was developed by the Scheme project at the
;;; Massachusetts Institute of Technology, Department of Electrical
;;; Engineering and Computer Science.  Permission to copy this
;;; software, to redistribute it, and to use it for any purpose is
;;; granted, subject to the following restrictions and understandings.
;;;
;;; 1. Any copy made of this software must include this copyright
;;; notice in full.
;;;
;;; 2. Users of this software agree to make their best efforts (a) to
;;; return to the MIT Scheme project any improvements or extensions
;;; that they make, so that these may be included in future releases;
;;; and (b) to inform MIT of noteworthy uses of this software.
;;;
;;; 3. All materials developed as a consequence of the use of this
;;; software shall duly acknowledge such use, in accordance with the
;;; usual standards of acknowledging credit in academic research.
;;;
;;; 4. MIT has made no warrantee or representation that the operation
;;; of this software will be error-free, and MIT is under no
;;; obligation to provide any services, by way of maintenance, update,
;;; or otherwise.
;;;
;;; 5. In conjunction with products arising from the use of this
;;; material, there shall be no use of the name of the Massachusetts
;;; Institute of Technology nor of any adaptation thereof in any
;;; advertising, promotional, or sales literature without prior
;;; written consent from MIT in each case.

;;;; Utilities from MIT Scheme

(define-external (error:wrong-type-argument object name procedure) mitutil)
(define-external (error:wrong-number-of-arguments procedure arity args)
  mitutil)
(define-external (serror procedure message . objects) mitutil)
(define-external (vector-copy vector) mitutil)
(define-external (list-copy list) mitutil)
(define-external (sort l pred) mitutil)
(define-external (append-map procedure list . lists) mitutil)
(define-external (for-all? list predicate) mitutil)
(define-external (symbol-append . symbols) mitutil)
(define-external (append! . lists) mitutil)
(define-external (reverse! list) mitutil)
(define-external (write-string string . port) mitutil)
(define-external (call-with-values generator consumer) mitutil)
(define-external (values . x) mitutil)

(define-in-line (fix:= x y) (= x y))
(define-in-line (fix:< x y) (< x y))
(define-in-line (fix:> x y) (> x y))
(define-in-line (fix:<= x y) (<= x y))
(define-in-line (fix:>= x y) (>= x y))

(define-in-line (fix:+ x y) (+ x y))
(define-in-line (fix:- x y) (- x y))
(define-in-line (fix:* x y) (* x y))
(define-in-line (fix:quotient x y) (quotient x y))
(define-in-line (fix:remainder x y) (remainder x y))

(define-in-line (fix:and x y) (bit-and x y))
(define-in-line (fix:xor x y) (bit-xor x y))
(define-in-line (fix:or x y) (bit-or x y))
(define-in-line (fix:lsh x y) (bit-lsh x y))
(define-in-line (fix:not x) (bit-not x))

(define-in-line (system-pair-car pair) (car pair))
(define-in-line (system-pair-set-car! pair object) (set-car! pair object))
(define-in-line (system-pair-cdr pair) (cdr pair))
(define-in-line (system-pair-set-cdr! pair object) (set-cdr! pair object))

(define-in-line (call-with-values generator consumer)
  (apply consumer (generator)))

(define-in-line (values . x)
  x)

(define-constant unspecific
  `'UNSPECIFIC)

(define-in-line (exact-integer? object)
  (fixed? object))

(define-in-line (exact-nonnegative-integer? object)
  (and (exact-integer? object)
       (not (negative? object))))

;;;; Macros

;;; DEFINE-SMACRO was obtained together with DEFINE-STRUCTURE; see the
;;; implementation history of DEFINE-STRUCTURE.

(define-macro define-smacro		; (define-smacro (foo x y z) body)
  (lambda (form expander)
    (expander
     `(DEFINE-MACRO
	,(caadr form)
	(LAMBDA (XFORMX XEXPANDERX)
	  (XEXPANDERX
	   (LET ,(let loop
		     ((bvl (cdadr form))
		      (access-expr '(CDR XFORMX)))
		   (cond ((null? bvl)
			  '())
			 ((symbol? bvl)
			  `((,bvl ,access-expr)))
			 ((pair? bvl)
			  `((,(car bvl) (CAR ,access-expr))
			    ,@(loop (cdr bvl) `(CDR ,access-expr))))
			 (else
			  (error (car form)
				 "Ill-formed bvl: ~S"
				 (cdadr form)))))
	     ,@(cddr form))
	   XEXPANDERX)))
     expander)))

(define-smacro (define-integrable . body)
  `(DEFINE-IN-LINE ,@body))

(define-smacro (named-lambda bvl . body)
  `(LAMBDA ,(cdr bvl) ,@body))

(define-smacro (without-interrupts thunk)
  `(,thunk))

;;; Original author: RHH, September, 1989.
;;; Stolen on January 17, 1993 by Jim Miller for use with UITK
;;; implemented in Scheme->C.  Removed debugging support.
;;; Subsequently modified by CPH.

;;; Components can be:
;;;   a symbol NAME
;;;   a list: (NAME DEFAULT-VALUE)
;;; Produces (in-lined)
;;;   constructor procedure: (MAKE-<name> comp1 ...)
;;;   predicate procedure: (<name>? object)
;;;   accessor procedures: (<name>-<component> object)
;;;   modifier procedures: (SET-<name>-<component>! object new-value)

;;; Note: The MAKE- procedure has required arguments for all
;;;       components that do not have default values. 

;;; Example:
;;; (define-structure dot x y (color 'black))
;;; (define a-dot (make-dot 3 4))
;;; (set-dot-color! a-dot 'green)
;;; (list (dot-x a-dot) (dot-color a-dot)) -> (3 green)

(define-smacro (define-structure name+opts . components)
  (let ((symbol-format
	 (lambda args
	   (string->symbol (apply format #f args))))
	(size (+ 1 (length components)))
	(name (if (pair? name+opts) (car name+opts) name+opts))
	(options (if (pair? name+opts) (cdr name+opts) '()))
	(field-names
	 (map (lambda (component)
		(if (pair? component)
		    (car component)
		    component))
	      components)))
    (let ((field-indexes
	   (let loop ((names field-names) (index 0))
	     (if (null? names)
		 '()
		 (cons index (loop (cdr names) (+ index 1))))))
	  (methods-name (symbol-format "~A:~A" '%RECORD-METHODS name))
	  (object-name
	   (string->uninterned-symbol (symbol->string 'OBJECT)))
	  (contents-name
	   (string->uninterned-symbol (symbol->string 'CONTENTS)))
	  (renames
	   (map (lambda (component)
		  (and (not (pair? component))
		       (string->uninterned-symbol (symbol->string component))))
		components)))
      `(BEGIN
	 (DEFINE ,methods-name
	   (MAKE-%DEFSTRUCT-METHODS 'RECORD ',name ',field-names
				    ',field-indexes #F))
	 (DEFINE-IN-LINE
	   (,(let ((option (assq 'CONSTRUCTOR options)))
	       (if option
		   (cadr option)
		   (symbol-format "~A-~A" 'MAKE name)))
	    ,@(let loop ((components components) (renames renames))
		(cond ((null? components)
		       '())
		      ((car renames)
		       (cons (car renames)
			     (loop (cdr components) (cdr renames))))
		      (else
		       (loop (cdr components) (cdr renames))))))
	   (MAKE-%DEFSTRUCT-%RECORD ,methods-name
				    ,@(map (lambda (component rename)
					     (or rename
						 (cadr component)))
					   components
					   renames)))
	 (DEFINE-IN-LINE (,(symbol-format "~A?" name) OBJ)
	   (AND (%RECORD? OBJ)
		(EQ? (%RECORD-METHODS OBJ) ,methods-name)))
	 ,@(map (lambda (field-name index)
		  `(DEFINE-IN-LINE (,(symbol-format "~A-~A" name field-name)
				    ,object-name)
		     (%RECORD-REF ,object-name ,index)))
		field-names
		field-indexes)
	 ,@(map (lambda (field-name index)
		  `(DEFINE-IN-LINE (,(symbol-format "~A-~A-~A!"
						    'SET name field-name)
				    ,object-name
				    ,contents-name)
		     (%RECORD-SET! ,object-name ,index ,contents-name)))
		field-names
		field-indexes)))))

(define-external (make-%defstruct-methods type name field-names field-indexes
					  print-procedure)
  mitutil)
(define-external (set-%defstruct-methods-print-procedure! methods
							  print-procedure)
  mitutil)
(define-external (make-%defstruct-%record methods . fields) mitutil)
(define-external (%defstruct-%record-description record) mitutil)