;;; -*-Scheme-*-
;;;
;;; $Id: examples.scm,v 1.4 1993/02/23 10:27:24 cph Exp $
;;;
;;; Copyright (c) 1993 Massachusetts Institute of Technology
;;;
;;; This material was developed by the Scheme project at the
;;; Massachusetts Institute of Technology, Department of Electrical
;;; Engineering and Computer Science.  Permission to copy this
;;; software, to redistribute it, and to use it for any purpose is
;;; granted, subject to the following restrictions and understandings.
;;;
;;; 1. Any copy made of this software must include this copyright
;;; notice in full.
;;;
;;; 2. Users of this software agree to make their best efforts (a) to
;;; return to the MIT Scheme project any improvements or extensions
;;; that they make, so that these may be included in future releases;
;;; and (b) to inform MIT of noteworthy uses of this software.
;;;
;;; 3. All materials developed as a consequence of the use of this
;;; software shall duly acknowledge such use, in accordance with the
;;; usual standards of acknowledging credit in academic research.
;;;
;;; 4. MIT has made no warrantee or representation that the operation
;;; of this software will be error-free, and MIT is under no
;;; obligation to provide any services, by way of maintenance, update,
;;; or otherwise.
;;;
;;; 5. In conjunction with products arising from the use of this
;;; material, there shall be no use of the name of the Massachusetts
;;; Institute of Technology nor of any adaptation thereof in any
;;; advertising, promotional, or sales literature without prior
;;; written consent from MIT in each case.

;;;; Examples of SOS Meta-Object Protocol

;;;; Dynamic Variables

(define-class <dynamic-class> (<class>))

(let ((slot-name (string->uninterned-symbol (symbol->string 'DYNAMIC-SLOTS))))
  (define-method compute-slots ((class <dynamic-class>))
    (let ((slots (call-next-method class)))
      (if (there-exists? slots
	    (lambda (slot)
	      (eq? (slot-allocation slot) 'DYNAMIC)))
	  (cons (make-slot slot-name class 'INSTANCE (lambda () '()) '())
		slots)
	  slots)))

  (let ((get-alist (slot-accessor slot-name))
	(set-alist (slot-modifier slot-name)))
    (define-method compute-virtual-slot-accessors
	((class <dynamic-class>) slot)
      (if (eq? (slot-allocation slot) 'DYNAMIC)
	  (values (lambda (object)
		    (let ((entry (assq name (get-alist object))))
		      (if entry
			  (cdr entry)
			  (error:uninitialized-instance-slot object slot))))
		  (lambda (object new-value)
		    (let ((alist (get-alist object)))
		      (let ((entry (assq name alist)))
			(if entry
			    (set-cdr! entry new-value)
			    (set-alist object
				       (cons (cons name new-value)
					     alist))))))
		  (lambda (object)
		    (assq name (get-alist object))))
	  (call-next-method class slot)))))

;;;; Class Variables

(define-class <class-variable-class> (<class>)
  (class-variable-index initializer (lambda () 0))
  class-variable-storage)

(define class-variable-index (slot-accessor 'CLASS-VARIABLE-INDEX))
(define class-variable-storage (slot-accessor 'CLASS-VARIABLE-STORAGE))

(let ((set-class-variable-storage! (slot-modifier 'CLASS-VARIABLE-STORAGE)))
  (define-method initialize-instance
      ((class <class-variable-class>) name direct-superclasses direct-slots)
    (call-next-method class name direct-superclasses direct-slots)
    (let ((index (class-variable-index class)))
      (if (> index 0)
	  (let ((storage (make-vector index)))
	    (set-class-variable-storage! class storage)
	    (for-each
	     (lambda (slot)
	       (if (class-slot? slot)
		   (let ((initializer (slot-initializer slot)))
		     (if initializer
			 (vector-set!
			  storage
			  (slot-property slot 'CLASS-VARIABLE-INDEX)
			  (initializer))))))
	     (slot-descriptors class)))))))

(let ((set-class-variable-index! (slot-modifier 'CLASS-VARIABLE-INDEX)))
  (define-method compute-slot-descriptor
      ((class <class-variable-class>) slot-arguments)
    (let ((slot (call-next-method class slot-arguments)))
      (if (class-slot? slot)
	  (make-slot (slot-name slot)
		     (slot-class slot)
		     (slot-allocation slot)
		     (slot-initializer slot)
		     (cons* 'CLASS-VARIABLE-INDEX
			    (let ((index (class-variable-index class)))
			      (set-class-variable-index! class
							 (+ index 1))
			      index)
			    (slot-plist slot)))
	  slot))))

(define-method compute-virtual-slot-accessors
    ((class <class-variable-class>) slot)
  (if (class-slot? slot)
      (let ((index (slot-property slot 'CLASS-VARIABLE-INDEX)))
	(values (lambda (instance)
		  instance
		  (vector-ref (class-variable-storage class) index))
		(lambda (instance object)
		  instance
		  (vector-set! (class-variable-storage class) index object))
		(lambda (instance)
		  instance
		  #t)))
      (call-next-method class slot)))

(define (class-slot? slot)
  (eq? 'CLASS (slot-allocation slot)))