/*  $Header: attrib.g,v 3.0 88/04/13 16:35:51 jos Locked $ */
/*
 *  This file is part of the Amsterdam SGML Parser.
 *
 *  Copyright: Faculteit Wiskunde en Informatica
 *             Department of Mathematics and Computer Science
 *             Vrije Universiteit Amsterdam
 *             The Netherlands
 *
 *  Authors:   Sylvia van Egmond
 *             Jos Warmer
 */
{
#include "types.h"
#include "att_chk.h"
#include "att_gen.h"
#include "element.h"
#include "group.h"
#include "lexical.h"
#include "modes.h"
}

att_val_spec(String literal;)
 :
	[ att_val(literal)
        | att_val_literal(literal)  { att_change_s(literal); }
        ] ;

att_val_literal(String str;) { Bool error = FALSE; }:
	[ [ TOK_LIT		{ enter_mode(MODE_LIT_ERO); }
	    rcdata(str, LITLEN, FALSE, &error)
                        { if (error)
			     report(WAR_LITLEN, NOTFATAL, 0, 0, 
				    "attribute value length", LITLEN);
                        }
	    TOK_LIT		{ leave_mode(); }
	  ]
	| [ TOK_LITA		{ enter_mode(MODE_LITA_ERO); }
	    rcdata(str, LITLEN, FALSE, &error)
                        { if (error)
			     report(WAR_LITLEN, NOTFATAL, 0, 0,
				    "attribute value length", LITLEN);
                        }
	    TOK_LITA		{ leave_mode(); }
	] ] ;

att_val(String string;) :    /*  only allowed when attribute value contains */
                            /* nothing but name characters */
        [ name_token(string, FALSE) ];

att_def_list_decl
{
    P_Group    assoc_g;
    P_Attlist  att_list;
    int        attcnt = 0;
} :
	[ MDO_ATTLIST                                  { enter_mode(MODE_MD); }
	      { assoc_g = group_create(); }
	  ps_plus assoc_elem_type(assoc_g)
	      { att_list = new_attlist(assoc_g); }
	  ps_plus att_def_list(att_list, &attcnt)
	      {
		  store_attlist(att_list);
		  if (attcnt > ATTCNT)
		      report(WAR_ATTCNT, NOTFATAL, assoc_g, 0);
	      }
	  TOK_MDC                                      { leave_mode(); }
	] ;

att_def_list(P_Attlist  att_list; int *attcnt;)
{
    P_Attdef   att_def;
} :
	[ att_def(&att_def, attcnt)
	      {
		  add_attdef(att_list, att_def);
		  (*attcnt)++;
	      }
	  ps_plus
	]+ ;

att_def(P_Attdef *att_def; int *nm_tokens;)
{
    int         declared_value;
    char        att_name[NAMELEN + 1];
    P_Group     range = 0;
    P_Iterator  it;
    String      name;
    int         key;
    char        att_val[LITLEN + 1] ;
    String      char_range[80];
    int         i = 0;
    int         j;
    Bool        twice;
    int         nr = 1, norm = 0;

    att_val[0] = '\0';
} :
        [ name(att_name, NAMECASE_GENERAL)                /* was : att_name */
	  ps_plus declared_val(&declared_value, &range)
	  ps_plus default_val(&key, att_val)
	      {
		/* TEST CORRECTNESS OF att_val (if any) */
		it = group_iterator(range);
		while( name = next_name(it) ){
		    /*
		     *  Check if name is alreadfy defined in  char_range.
		     *  If not, add it to char_range.
		     */
		    twice = FALSE;
		    for(j=0; j<i; j++){
			if( streq(char_range[j], name) ){
			    twice = TRUE;
			    break;
			}
		    }
		    if( twice ){
			report(ATTR_RANGE, FATAL, 0, 0, name);
		    } else {
			char_range[i++] = name;
		    }
		}
		char_range[i] = 0;
		if (declared_value == ENUMERATE) *nm_tokens += i;
		norm = norm_val_length(att_val, declared_value);
		if (norm > LITLEN) {
		     report(WAR_LITLEN, NOTFATAL, 0, 0,
			    "normalized attribute value length", LITLEN);
		}
		if( (key==UNDEFINED) or (key==FIXED) ){
		    check_attr(att_name, att_val, declared_value, char_range, &nr);
		    if ((declared_value == ENUMERATE) or
			(declared_value == NMTOKEN) or
			(declared_value == NMTOKENS))
			*nm_tokens += nr;
		    *att_def = new_attdef(strsave(att_name), declared_value,
					  range, key, strsave(att_val) );
		} else {
		    *att_def = new_attdef(strsave(att_name), declared_value,
					  range, key, 0 );
		}
	      }
	] ;

declared_val(int* value; P_Group *range;)
{
    String str;
} :
        [   keyword(value, &str)					/* 145 */
	    {
		if( not check_int(*value, CDATA, ENTITY, ID, IDREF, IDREFS,
				    NAME, NAMES, NMTOKEN, NMTOKENS, NOTATION,
				    NUMBER, NUMBERS, NUTOKEN, NUTOKENS, 0) )
		{
		    report(KEY_WRONG, FATAL, 0, 0, str, "declared value",
			   "CDATA,ENTITY,NUTOKENS, etc", "CDATA");
		    *value = CDATA;
		}
	    }
            [%while( *value==NOTATION )
              ps_plus
		  { *range = group_create(); }
	      name_group(*range, NAMECASE_GENERAL)
            ]?
          | [
		  { *range = group_create(); }
              name_token_group(*range, NAMECASE_GENERAL)
		  { *value = ENUMERATE; }
            ]
        ] ;

default_val(int* key; String att_val;)
{
    String str;
} :
        [ TOK_RNI
          keyword(key, &str)
	  {
	      if( not check_int(*key, FIXED, REQUIRED, CURRENT, CONREF,
				       IMPLIED, 0) )
	      {
		  report(KEY_WRONG, FATAL, 0, 0, str, "default value",
			 "FIXED, REQUIRED, CURRENT, CONREF, IMPLIED","IMPLIED");
		  *key = IMPLIED;
	      }
	  }
          [%while( *key==FIXED )
            ps_plus att_val_spec(att_val)
          ]?
        ]
	|
	[
	  att_val_spec(att_val)
	      { *key = UNDEFINED; }
	]
	;
