/* $Header: capacity.c,v 3.1 89/09/25 09:19:01 sylvia Exp $ */
/*
 *  This file is part of the Amsterdam SGML Parser.
 *
 *  Copyright: Faculteit Wiskunde en Informatica
 *             Department of Mathematics and Computer Science
 *             Vrije Universiteit Amsterdam
 *             The Netherlands
 *
 *  Authors:   Sylvia van Egmond
 *             Jos Warmer
 */

#include "types.h"
#include "att_gen.h"
#include "capacity.h"
#include "element.h"
#include "node.h"

int grp_capacity(node, level)
P_Node node;
int   *level;
{
	int        nr = 0;
	P_Iterator it;
	P_Node     nd;
	int        lvl, lvl1 = 0;

	if ((node_type(node) == GI) or (node_type(node) == KEY))
	    return(1);

	it = group_iterator(node_group(node));
	while (nd = next_node(it)) {
	    lvl = 0;
	    nr += grp_capacity(nd, &lvl);
	    lvl1 = ((lvl1 > lvl)?lvl1:lvl);
	}
	*level = lvl1 + 1;
	return(nr);
}

int entcap = 0, entchcap = 0, mapcap = 0, notcap = 0, notchcap = 0;

void capacity_points()
{
	P_Element  elem;
	P_Iterator elem_it, name_it;
	String     name;
	P_Group    excep;
	int        attcap = 0, attchcap = 0, avgrpcap = 0, elemcap = 0;
	int        exgrpcap = 0, exnmcap = 0, grpcap = 0, idcap = 0;
	int        idrefcap = 0, totalcap = 0;
	Bool       cont;
	int        grpgtcnt, grplvl;
	int	   tmp_elemcap;
	FILE      *fp;

	elem_it = element_iterator();
	while (elem = next_element(elem_it)) {
	    tmp_elemcap = 0;
	    cont = FALSE;
	    name_it = group_iterator(name_group(elem));
	    while (name = next_name(name_it)) {
	      if (strcmp(name, DOCUMENT) != 0) tmp_elemcap++;
	      else cont = TRUE;
	      if (cont) break;
	    }
	    if (cont) continue;
	    grplvl = 0;
	    grpgtcnt = grp_capacity(content(elem), &grplvl);
	    if (grpgtcnt > GRPGTCNT) {
		report(ER_GRPGTCNT, FATAL, name_group(elem), 0);
	    }
	    if (grplvl > GRPLVL) {
		report(WAR_GRPLVL, NOTFATAL, name_group(elem), 0);
	    }
	    elemcap += tmp_elemcap;
	    grpcap += (grpgtcnt * tmp_elemcap);
	    if (excep = exclusions(elem)) {
	      exgrpcap++;
	      while (name = next_name(excep)) exnmcap++;
	    }
	    if (excep = inclusions(elem)) {
	      exgrpcap++;
	      while (name = next_name(excep)) exnmcap++;
	    }
	}
	attr_cap_points(&attcap, &attchcap, &avgrpcap, &idcap, &idrefcap);

#ifdef DEBUG
	fprintf(fpdg, "%d entities defined with %d characters of text.\n", entcap, entchcap);
	fprintf(fpdg, "%d element types declared with %d model tokens and\n", elemcap, grpcap);
	fprintf(fpdg, "   %d exception groups with %d names.\n", exgrpcap, exnmcap);
	fprintf(fpdg, "%d attributes declared with %d group members and\n", attcap, avgrpcap);
	fprintf(fpdg, "   %d characters of default value text.\n", attchcap);
	fprintf(fpdg, "%d IDs and %d IDREFs specified.\n", idcap, idrefcap);
	fprintf(fpdg, "%d data content notations with %d text characters.\n", notcap, notchcap);
	fprintf(fpdg, "%d short reference maps declared.\n", mapcap);
#endif

	mapcap   *= ((32 * NAMELEN) + NAMELEN);
	attcap   *= NAMELEN;	avgrpcap *= NAMELEN;
	entcap   *= NAMELEN;	elemcap  *= NAMELEN;
	exgrpcap *= NAMELEN;	exnmcap  *= NAMELEN;
	grpcap   *= NAMELEN;	idcap    *= NAMELEN;
	idrefcap *= NAMELEN;	notcap   *= NAMELEN;

	totalcap = attcap + avgrpcap + elemcap + entcap + exgrpcap;
	totalcap += exnmcap + grpcap + idcap + idrefcap + mapcap;
	totalcap += notcap;
	totalcap += attchcap + entchcap + notchcap;
#ifdef DEBUG
	fprintf(fpdg, "%d capacity points required (%d%% of 35000 permitted).\n\n", totalcap, totalcap / 350);
#endif

	if (attcap > CAP_VAL) {
	  report(ER_CAPACITY, FATAL, 0, 0, "attcap", attcap);
	}
	if (attchcap > CAP_VAL) {
	  report(ER_CAPACITY, FATAL, 0, 0, "attchcap", attchcap);
	}
	if (avgrpcap > CAP_VAL) {
	  report(ER_CAPACITY, FATAL, 0, 0, "avgrpcap", avgrpcap);
	}
	if (elemcap > CAP_VAL) {
	  report(ER_CAPACITY, FATAL, 0, 0, "elemcap", elemcap);
	}
	if (entcap > CAP_VAL) {
	  report(ER_CAPACITY, FATAL, 0, 0, "entcap", entcap);
	}
	if (entchcap > CAP_VAL) {
	  report(ER_CAPACITY, FATAL, 0, 0, "entchcap", entchcap);
	}
	if (exgrpcap > CAP_VAL) {
	  report(ER_CAPACITY, FATAL, 0, 0, "exgrpcap", exgrpcap);
	}
	if (exnmcap > CAP_VAL) {
	  report(ER_CAPACITY, FATAL, 0, 0, "exnmcap", exnmcap);
	}
	if (grpcap > CAP_VAL) {
	  report(ER_CAPACITY, FATAL, 0, 0, "grpcap", grpcap);
	}
	if (idcap > CAP_VAL) {
	  report(ER_CAPACITY, FATAL, 0, 0, "idcap", idcap);
	}
	if (idrefcap > CAP_VAL) {
	  report(ER_CAPACITY, FATAL, 0, 0, "idrefcap", idrefcap);
	}
	if (mapcap > CAP_VAL) {
	  report(ER_CAPACITY, FATAL, 0, 0, "mapcap", mapcap);
	}
	if (notcap > CAP_VAL) {
	  report(ER_CAPACITY, FATAL, 0, 0, "notcap", notcap);
	}
	if (notchcap > CAP_VAL) {
	  report(ER_CAPACITY, FATAL, 0, 0, "notchcap", notchcap);
	}
	if (totalcap > CAP_VAL) {
	  report(ER_CAPACITY, FATAL, 0, 0, "totalcap", totalcap);
	}

	fatal_report();

	fp = fopen(DOC_cappoint, "w");
	if (fp == 0) {
	    report(FILE_OPEN, FATAL, 0, 0, DOC_cappoint);
	}
	totalcap = totalcap - entcap - entchcap - mapcap;
	fprintf(fp, "int totalcap = %d;\n", totalcap);
	fprintf(fp, "int entcap = %d;\n", entcap);
	fprintf(fp, "int entchcap = %d;\n", entchcap);
	fprintf(fp, "int mapcap = %d;\n", mapcap);
	fclose(fp);
}
