/*  $Header: dtd.g,v 3.0 88/04/13 16:35:35 jos Locked $ */
/*
 *  This file is part of the Amsterdam SGML Parser.
 *
 *  Copyright: Faculteit Wiskunde en Informatica
 *             Department of Mathematics and Computer Science
 *             Vrije Universiteit Amsterdam
 *             The Netherlands
 *
 *  Authors:   Sylvia van Egmond
 *             Jos Warmer
 */
{
#include "types.h"
#include "element.h"
#include "entity.h"
#include "in.h"
#include "lexical.h"
#include "modes.h"
#include "node.h"
#include "notation.h"

static int dsc_string[] = {TOK_DSC, 0};

#ifdef DEBUG
static Bool debug = FALSE;

void debug_dtd(b)
Bool b;
{
	debug = b;
}
#endif
}

prolog               : [ [ other_prolog ]*
			 doc_type_decl          /* was : base_doc_type_decl */
			 [ other_prolog ]* 
                       ] ;

other_prolog         : [ comment_decl | processing_instr | s ] ;

name_token_group(P_Group g; Bool upper_case_subst;)
{
    char string[NAMELEN + 1];
    int  conn, first_con = 0;
    int  grpcnt;
    Bool error = FALSE;
} :
	[ TOK_GRPO                             { enter_mode(MODE_GRP); }
	  ts_star name_token(string, upper_case_subst)
	      {
		group_add(g, strsave(string));
		grpcnt = 1;
	      }
	  ts_star 
	  [ connector(&conn) ts_star 
	    name_token(string, upper_case_subst) ts_star
		{
		  grpcnt++;
		  if (!error and (grpcnt > GRPCNT)) {
		      error = TRUE;
		      report(WAR_GRPCNT, NOTFATAL, 0, 0, GRPCNT);
		  }
		  if( first_con == TOK_NOD ){
		      first_con = conn;
		      group_add(g, strsave(string));
		  } else {
		      group_add(g, strsave(string));
		  }
		}
	  ]*
	  TOK_GRPC                                     { leave_mode(); }
	] ;

number(String str;)
{
    int  i;
    Bool error = FALSE;
} :
        [ TOK_DIGIT
	      { str[0] = current_value(); i=1; }
	  [ %while(1) TOK_DIGIT
	      { if (!error and (i >= NAMELEN)) {
		  str[i] = '\0';
		  report(WAR_NAMELEN, NOTFATAL, 0, 0, str, NAMELEN);
		  error = TRUE;
		}
		else if (!error) { str[i]= current_value(); i++; }
	      }
	  ]*
	      { str[i]='\0'; }
        ] ;

ds : [%default s | TOK_EE | param_ent_ref | comment_decl |
       processing_instr | marked_sect_decl | marked_sect_close ]
     ;

doc_type_decl
{
    char         doc_name[NAMELEN + 1];
    P_Extern_id  ex_id = 0 ;
    P_Node       doc_node;
    P_Group      doc_group;
} :
        [ MDO_DOCTYPE                                   { enter_mode(MODE_MD); }
	      {
		DEB("start doctype decl\n");
	      }
          ps_plus
	  name(doc_name, NAMECASE_GENERAL) ps_star   /* was  :doc_type_name() */
	      {
		DEB1("document type name `%s'\n", doc_name);
		set_document_name(strsave(doc_name));
	        doc_node = new_node_group();
		node_set_group_type(doc_node, CONN_SEQ);
		node_add(doc_node, new_node_gi(strsave(doc_name)) );
		doc_group  = group_create();
		group_add(doc_group, strsave("document"));
	        define_element(doc_group, TRUE, TRUE, doc_node,
				   (P_Group) 0, (P_Group) 0);
	      }
	  [ extern_ident(&ex_id)
	    {
#ifdef DEBUG
		if (debug) {
		    fprintf(fpdg, "doc_type decl : ");
		    print_extern_id(fpdg, ex_id);
		}
#endif
	    }
          ]?
	  [ TOK_DSO                             { enter_mode(MODE_DS); }
	    doc_type_decl_subset 
	    [%if( ex_id != 0 )
	      TOK_DSC
	        {
		    token_input("extern_doc", dsc_string, 0);
		    switch_to_extern_id(ex_id);
	        }
	      doc_type_decl_subset 
	      TOK_DSC                                    { leave_mode(); }
	    |
	      TOK_DSC                                    { leave_mode(); }
	    ]
	    ps_star
	  ]?
	  TOK_MDC                                      { leave_mode(); }
	      {
		DEB("leave doc type decl\n"); 
	      } 
        ] ;

doc_type_decl_subset : [ set | ds ]* ;

notation_decl
{
    char         not_name[NAMELEN + 1];
    P_Extern_id  not_id;
} :
        [ MDO_NOTATION                             { enter_mode(MODE_MD); }
          ps_plus name(not_name, NAMECASE_GENERAL) /* was : notation_name */
          ps_plus extern_ident(&not_id)            /* was : notation_ident */
          /*STAR*/
              { define_notation(not_name, not_id); }
          TOK_MDC                                      { leave_mode(); }
        ] ;

set :
	[ %default elem_decl
	  | ent_decl
	  | att_def_list_decl
	  | notation_decl
	  | short_ref_mapping_decl
	  | short_ref_use_decl
	] ;

extern_ident(P_Extern_id* ex_id;)
{
    int    type;
    String str;
} :
        [ keyword(&type, &str)			  /* SYSTEM, PUBLIC */
               { 
		 if( not check_int(type, SYSTEM, PUBLIC, 0) ){
		     report(KEY_WRONG, NOTFATAL, 0, 0, str, "extern identifier",
			    "SYSTEM/PUBLIC", "SYSTEM");
		     type = SYSTEM;
		 }
	       }
	  ps_star
	  extern_ident_short(ex_id, type)
	] ;
