/*  $Header: marked.g,v 3.0 88/04/14 08:36:18 jos Locked $ */
/*
 *  This file is part of the Amsterdam SGML Parser.
 *
 *  Copyright: Faculteit Wiskunde en Informatica
 *             Department of Mathematics and Computer Science
 *             Vrije Universiteit Amsterdam
 *             The Netherlands
 *
 *  Authors:   Sylvia van Egmond
 *             Jos Warmer
 */
{
#include "types.h"
#include "keywords.h"
#include "lexical.h"
#include "modes.h"

static int  marked_sections_open = 0;
static Bool inside_ignore = 0;

#ifdef DEBUG
static Bool debug = FALSE;

void debug_marked(b)
Bool b;
{
	debug = b;
}
#endif
}

marked_sect_decl
{
    int   status_key = UNDEFINED;
} :
	[ {
	    DEB("ms-decl\n");
            if (marked_sections_open >= TAGLVL) {
	      report(WAR_TAG_MARK, NOTFATAL, 0, 0, TAGLVL);
	    }
	    marked_sections_open++; 
	  }
	  marked_sect_open(&status_key)
	      {
		DEB1("marked section : %s\n", key_str(status_key) );
	        if( status_key==UNDEFINED ){ status_key = INCLUDE; } 
	      }
	  [%if( (status_key == IGNORE) or (inside_ignore) )
	    [
	      {
		DEB("key==ignore\n");
	        inside_ignore++; 
	      }
	      TOK_DSO                      { enter_mode(MODE_IGNORE); }
	      { 
		DEB("DSO done\n");
	      }
	      marked_sect
	      marked_sect_close
	      { inside_ignore--; }
                                          { leave_mode(); } /*MD */
	    ]
	  |
	    [
	      {
		DEB("key!=ignore\n");
	       }
	      TOK_DSO
	      { 
		  DEB("DSO done\n");
	          switch( status_key ){
		      case CDATA   : enter_mode( MODE_MARKED_CDATA );
				     break;
		      case RCDATA  : enter_mode( MODE_MARKED_RCDATA );
				     break;
		      case TEMP    :
		      case INCLUDE : leave_mode(); /* MD */
				     break;
		      default:
				     break;
		  }
	       }
	    ]
	  ]
	] ;

marked_sect_open(int *status_key;) :
	[ TOK_MDO_DSO                           { enter_mode(MODE_MD); }
	  ps_star
	  stat_key_spec(status_key)
	] ;

marked_sect_close :
	[ TOK_MSC_MDC
            { if( marked_sections_open <= 0 ){
		  report(MS_NOT_OPEN, FATAL, 0, 0);
	      } else {
                  marked_sections_open--;
	      }
	      if( current_mode()==MODE_IGNORE ){
		  leave_mode();
	      } else if( current_mode()==MODE_MARKED_CDATA 
		         or
		         current_mode()==MODE_MARKED_RCDATA )
	      {
		  leave_mode();  /* MARKED_(R)CDATA */
		  leave_mode();  /* MD */
	      }
	    }
	] ;

marked_sect
{
    char ch;
} :
        [   SGML_char(&ch)
	  |
	    marked_sect_decl
        ]*
        ;

stat_key_spec(int *status_key;)
{
    int    key ;
    String str;
} :
        [
	  keyword(&key, &str)
	  {
	      if( not check_int(key, IGNORE, TEMP, INCLUDE, CDATA,
				    RCDATA, 0) )
	      {
		  report(KEY_WRONG, NOTFATAL, 0, 0, str, "status keyword",
			 "IGNORE, TEMP, INCLUDE, C/RCDATA", "TEMP");
		  key = TEMP;
	      }
	      *status_key = priority(*status_key, key);
	  }
	  ps_star
	]*
	;
