/*  $Header: shortnot.g,v 3.0 88/04/14 08:36:30 jos Exp $ */
/*
 *  This file is part of the Amsterdam SGML Parser.
 *
 *  Copyright: Faculteit Wiskunde en Informatica
 *             Department of Mathematics and Computer Science
 *             Vrije Universiteit Amsterdam
 *             The Netherlands
 *
 *  Authors:   Sylvia van Egmond
 *             Jos Warmer
 */
{
#include "types.h"
#include "group.h"
#include "lexical.h"
#include "modes.h"
#include "shortref.h"

#ifdef DEBUG
static Bool debug = FALSE;

void debug_shortnot(b)
Bool b;
{
	debug = b;
}
#endif
}

short_ref_mapping_decl
{
    char   map_name[NAMELEN + 1];
    char   short_ref[LITLEN + 1];
    char   gen_ent_name[NAMELEN + 1];
    P_Map  map;
} :
        [ MDO_SHORTREF                          { enter_mode(MODE_MD); }
          ps_plus name(map_name, NAMECASE_GENERAL)
              { map = new_map(strsave(map_name)); }
          ps_plus
          [ 
	      param_literal(short_ref) ps_plus 
	      name(gen_ent_name, NAMECASE_ENTITY)       ps_star
              { define_mapping(map, short_ref, strsave(gen_ent_name)); }
          ]+
              {
#ifdef DEBUG
		if (debug) print_map(fpdg, map);
#endif
	      }
          TOK_MDC                                      { leave_mode(); }
        ] ;

short_ref_use_decl
{
    char     map_name[NAMELEN + 1];
    P_Group  assoc_g = 0;
#ifdef DOC_PARSER
    P_Map    map;
#endif
} :
	[ MDO_USEMAP                                   { enter_mode(MODE_MD); }
	  ps_plus map_spec(map_name) ps_star
	  [ 
	        { assoc_g = group_create(); }
	    assoc_elem_type(assoc_g) ps_star
	        {
#ifdef DEBUG
		    if (debug) {
		        DEB1("shortref use decl: map `%s'\n", map_name);
		        group_print(fpdg, assoc_g);
		        DEB("\n");
		    }
#endif
		    usemap(assoc_g, map_name);
	        }
	  ] ?
	  {
	      if( not assoc_g ){
#ifdef GENERATOR
		  report(USE_DTD, FATAL, 0, 0, map_name);
#endif
#ifdef DOC_PARSER
		  map = lookup_map(map_name);
		  if( map ){
		      DEB1("use map %s\n", map_name);
		      push_map(map, TOK_NOD);
		  } else {
		      report(SHORT_UNDEF, FATAL, 0, 0, map_name);
		  }
#endif
	      }
	  }
	  TOK_MDC                                      { leave_mode(); }
        ] ;

map_spec(String map_name;)
{
    int    key;
    String str;
} :
        [   name(map_name, NAMECASE_GENERAL)              /* was : map_name */
          | [ TOK_RNI keyword(&key, &str)
	      {
		  if( not check_int(key, EMPTY, 0) ){
		      report(KEY_WRONG, NOTFATAL, 0, 0, str,
			     "map specification", "EMPTY", "EMPTY");
		  }
		  strcpy(map_name, "EMPTY");
	      }
	    ]
        ] ;
