/* $Header: startend.c,v 3.1 88/08/25 11:40:30 jos Locked $ */
/*
 *  This file is part of the Amsterdam SGML Parser.
 *
 *  Copyright: Faculteit Wiskunde en Informatica
 *             Department of Mathematics and Computer Science
 *             Vrije Universiteit Amsterdam
 *             The Netherlands
 *
 *  Authors:   Sylvia van Egmond
 *             Jos Warmer
 */

#include "types.h"
#include "Lpars.h"
#include "att_par.h"
#include "att_chk.h"
#include "charclas.h"
#include "elem_stk.h"
#include "group.h"
#include "in.h"
#include "lexical.h"
#include "out.h"
#include "shortref.h"
#include "startend.h"
#include "tags.h"

static P_Group id_list; 
static P_Group idref_list;
static int     idcap    = 0;
static int     idrefcap = 0;
extern int     totalcap;

#define CONREF_BEEN	1
#define NOTATION_BEEN	2
#define NOT_BEEN	3

Parserinfo last_opened_info()
{
    int endtag = top_elem(elemstack);
    return endtag_info(endtag);
}

int group_add_list(list, val)
P_Group list;
String  val;
{
	char result[NAMELEN + 1], *nm;
	int  i = 0, j;
	int  grpcnt = 0;

	Skip_s(val, &i);
	while (val[i]) {
	    j = 0;
	    if (is_name_start_character(val[i])) {
		result[j++] = val[i++];
	    while (is_name_character(val[i]))
		result[j++] = val[i++];
	    }
	    if ((val[i] != '\0') and not is_s(val[i]))
		while ((val[i] != '\0') and not is_s(val[i])) i++;
	    else {
		result[j] = '\0';
		nm = strsave(result);
		grpcnt++;
		if (!group_add_unique(list, nm, streq))
		    CFREE(nm);
	    }
	    Skip_s(val, &i);
	}
	return(grpcnt);
}

void check_starttag(info)
Parserinfo info;
{
	P_Att_iter it;
	P_Attdef   attdef;
	int        def_type, decl_val;
	String     cur_val, def_val, name, nm = 0;
	int        grpcnt     = 0;
	int        conref_not = NOT_BEEN;
	int        tmp_total = 0;  /* bevat tijdelijke totale cap. */

	if (!id_list) {
	    id_list = group_create();
	    idref_list = group_create();
	}
	it = attdef_iterator(info_attlist(info));
	while (attdef = att_next(it)) {
	    nm = 0;
	    name = att_name(attdef);
	    def_type = att_default_type(attdef);
	    cur_val = att_current_value(attdef);
	    def_val = att_default_value(attdef);
	    decl_val = att_declared_value(attdef);
	    if ((def_type == REQUIRED) and (cur_val == 0))
	       report(ATTR_REQ, FATAL, 0, 0, name);
	    if ((def_type == FIXED) and cur_val and
		(strcmp(cur_val, def_val) != 0)) {
		report(ATTR_FIXED, FATAL, 0, 0, name, def_val, cur_val);
	    }
	    if ((def_type == CURRENT) and !def_val and !cur_val)  {
		report(ATTR_CURRENT, FATAL, 0, 0, name);
	    }
	    if ((def_type == CURRENT) and cur_val)
		att_set_default_value(attdef, strsave(cur_val));
	    if ((decl_val == NOTATION) and (cur_val or def_val)) {
		if (conref_not == CONREF_BEEN) 
		    report(ATTR_CONREF_NOT, FATAL, 0, 0, info_name(info));
		else conref_not = NOTATION_BEEN;
	    }
	    if ((def_type == CONREF) and cur_val) {
		if (conref_not == NOTATION_BEEN) {
		    report(ATTR_CONREF_NOT, FATAL, 0, 0, info_name(info));
		}
		conref_not = CONREF_BEEN;
	    }
	    if ((decl_val == ID) and cur_val) {
		nm = strsave(cur_val);
		idcap += NAMELEN;
		if (!group_add_unique(id_list, nm , streq)) {
		    report(ATTR_ID_UNIQUE, FATAL, 0, 0, nm);
		    CFREE(nm);
		}
	    }
	    if (decl_val == IDREF) {
		if (cur_val) nm = strsave(cur_val);
		else if (def_val) nm = strsave(def_val);
		if (nm) grpcnt++;
		if (nm and !group_add_unique(idref_list, nm, streq))
		    CFREE(nm);
	    }
	    if (decl_val == IDREFS) {
		if (cur_val)
		    grpcnt += group_add_list(idref_list, cur_val);
		else if (def_val)
		    grpcnt += group_add_list(idref_list, def_val);
	    }
	}
	if (grpcnt > GRPCNT) 
	    report(WAR_IDREF_GRP, NOTFATAL, 0, 0, info_name(info), GRPCNT);
	idrefcap += NAMELEN * grpcnt;
	if (idrefcap > CAP_VAL)
	    report(ER_CAPACITY, FATAL, 0, 0, "idrefcap", idrefcap);
	if (idcap > CAP_VAL)
	    report(ER_CAPACITY, FATAL, 0, 0, "idcap", idcap);
	tmp_total = totalcap + idrefcap + idcap;
	if (tmp_total > CAP_VAL)
	    report(ER_CAPACITY, FATAL, 0, 0, "totalcap", tmp_total);

	out_tag(info_starttag(info));

	it = attdef_iterator(info_attlist(info));
	while (attdef = att_next(it)) {
	    if (att_current_value(attdef))
		att_set_current_value(attdef, 0);
	}
}

void pars_empty(starttag)
int starttag;
{
	Parserinfo info;

	info = starttag_info(starttag);
	check_starttag(info);
}

void pars_conref(starttag)
int starttag;
{
	Parserinfo info;
	P_Att_iter it;
	P_Attdef   attdef;
	static int tokens[2] = { 0, 0 };

	info = starttag_info(starttag);
	it = attdef_iterator(info_attlist(info));
	while (attdef = att_next(it)) {
	    if ((att_default_type(attdef) == CONREF) and
		 att_current_value(attdef))
		break;
	}
	if (attdef) {
	    check_starttag(info);
	    tokens[0] = TOK_CONREF;
	    token_input("CONREF", tokens, 0);
	}
}

void pars_start(starttag)
int starttag;
{
	Parserinfo  info;
	int        *excep;
	static Bool before = FALSE;

	if (!before and (Size_elemstack(elemstack) >= TAGLVL)) {
	    report(WAR_OPEN_ELEM, NOTFATAL, 0, 0, TAGLVL);
	    before = TRUE;
	}
	info = starttag_info(starttag);
	check_starttag(info);
	push_elem(elemstack, starttag, info_endtag(info));
	if (On_stackElem(exclstack, info_starttag(info)))
	    report(ELEM_EXCL, FATAL, 0, 0, info_name(info));
	excep = info_excl(info);
	if (excep != 0) {
	    while (*excep != 0) PushElem(exclstack, *excep++);
	}
	excep = info_incl(info);
	if (excep != 0) {
	    while (*excep != 0) PushElem(inclstack, *excep++);
	}

	push_map(info_map(info), starttag);
}

void pars_end(endtag)
int endtag;
{
	Parserinfo info;
	int       *excep;

	info = endtag_info(endtag);
	out_tag(endtag);
	pop_elem(elemstack);
	excep = info_excl(info);
	if (excep != 0)
	    while (*excep++ != 0) PopElem(exclstack);
	excep = info_incl(info);
	if (excep != 0)
	    while (*excep++ != 0) PopElem(inclstack);

	pop_map(info_map(info), info_starttag(info));
}

Bool also_in_idref(name)
String name;
{
	P_Iterator it;
	String     idref;

	it = group_iterator(idref_list);
	while (idref = next_name(it)) {
	    if (streq(name, idref)) {
		group_delete_next(idref_list, it, CFREE);
		return(TRUE);
	    }
	}
	return(FALSE);
}

void pars_document()
{
	P_Iterator it;
	String     name;

	out_char('\n');
	it = group_iterator(id_list);
	while (name = next_name(it)) {
	    if (!also_in_idref(name))
		report(ATTR_ID_UNREF, FATAL, 0, 0, name);
	}
	it = group_iterator(idref_list);
	while (name = next_name(it)) {
	    report(ATTR_IDREF_UNREF, FATAL, 0, 0, name);
	}
}
