/******************************************************************************/
/*    Standard Generalized Markup Language Users' Group (SGMLUG)
                 SGML Parser Materials (ARCSGML 1.0)

(C) 1983-1988 Charles F. Goldfarb (assigned to IBM Corporation)
(C) 1988-1991 IBM Corporation

Licensed to the SGML Users' Group for distribution under the terms of
the following license:                                                        */

char license[297] =
"SGMLUG hereby grants to any user: (1) an irrevocable royalty-free, \
worldwide, non-exclusive license to use, execute, reproduce, display, \
perform and distribute copies of, and to prepare derivative works \
based upon these materials; and (2) the right to authorize others to \
do any of the foregoing.";
/******************************************************************************/
#include "sgmlincl.h"         /* #INCLUDE statements for SGML parser. */
/******************************************************************************/
/* SGMLXTRN: Storage allocation and initialization for all public variables.
             Exceptions: Constants lex????? and del????? are defined in
             LEX?????.C modules; constants pcb????? are defined in PCB?????.c.
*/
/******************************************************************************/
/* Variables to be initialized each pass (except first, which is done by C).
*/
int badresw = 0;              /* 1=REF_ out of context; 0=valid. */
int charmode = 0;             /* >0=in #CHARS; 0=not. */
int conactsw = 0;             /* 1=return saved content action 0=get new one.*/
int conrefsw = 0;             /* 1=content reference att specified; 0=no. */
int contersv = 0;             /* Save contersw while processing pending REF. */
int contersw = 0;             /* 1=element or #CHARS out of context; 0=valid. */
int datarc = 0;               /* Return code for data: DAF_ or REF_. */
int delmscsw = 0;             /* 1=DELMSC must be read on return to es==0. */
int didreq = 0;               /* 1=required implied tag processed; 0=no. */
int dostag = 0;               /* 1=retry newetd instead of parsing; 0=parse. */
int dtdsw = 0;                /* DOCTYPE declaration found: 1=yes; 0=no. */
int entdatsw = 0;             /* 2=CDATA entity; 4=SDATA; 8=NDATA; 0=none. */
int entpisw = 0;              /* 4=PI entity occurred; 0=not. */
int eodsw = 0;                /* 1=eod found in error; 0=not yet. */
int eofsw = 0;                /* 1=eof found in body of document; 0=not yet. */
int es = -1;                  /* Index of current source in stack. */
int etagimct = 0;             /* Implicitly ended elements left on stack. */
int etagimsw = 0;             /* 1=end-tag implied by other end-tag; 0=not. */
int etagmin = MINNONE;        /* Minim: NONE NULL NET DATA; implied by S/ETAG*/
int etictr = 0;               /* Number of "NET enabled" tags on stack. */
int etisw = 0;                /* 1=tag ended with eti; 0=did not. */
int indtdsw = 0;              /* Are we in the DTD? 1=yes; 0=no. */
int mslevel = 0;              /* Nesting level of marked sections. */
int msplevel = 0;             /* Nested MS levels subject to special parse. */
int newdtdsw = 0;             /* 1=DTD just started; 0=DTD returned to TP. */
int prologsw = 1;             /* 1=in prolog; 0=not. */
int pss = 0;                  /* SGMLACT: scbsgml stack level. */
int sgmlsw = 0;               /* SGML declaration found: 1=yes; 0=no. */
int stagmin = MINNONE;        /* Minimization: NONE, NULL tag, implied by STAG*/
int tagctr = 0;               /* Tag source chars read. */
int ts = -1;                  /* Index of current tag in stack. */
struct parse *propcb = &pcbpro;    /* Current PCB for prolog parse. */
/******************************************************************************/
/* Variables that do not require general initialization each pass, because
   they (1) contain values that are set in the first pass and used in all of
   them, or (2) are initialized (if necessary) by the functions that use them.
*/
int aentctr = 0;              /* Number of ENTITY tokens in this att list. */
int conact = 0;               /* Return code from content parse. */
int conrefsv = 0;             /* Save conrefsw when doing implied start-tag.*/
int dtdrefsw = 0;             /* External DTD? 1=yes; 0=no. */
int etiswsv = 0;              /* Save etisw when processing implied start-tag.*/
int grplvl = 0;               /* Current level of nested grps in model. */
int idrctr = 0;               /* Number of IDREF tokens in this att list. */
int mdessv = 0;               /* ES level at start of markup declaration. */
int notadn = 0;               /* Position of NOTATION attribute in list. */
int parmno = 0;               /* Current markup declaration parameter number. */
int pass = 0;                 /* 0=first pass over file; >0=later passes. */
int pexsw = 0;                /* 1=tag valid solely because of plus exception.*/
int rcessv = 0;               /* ES level at start of RCDATA content. */
int tagdelsw = 0;             /* 1=tag ended with delimiter; 0=no delimiter. */
int tokencnt = 0;             /* Number of tokens found in attribute value. */
long idrefl = 0;              /* Existence bits: IDREF atts (in same order). */
struct entity *ecbdeflt = 0;  /* #DEFAULT ecb (NULL if no default entity). */
struct etd *docetd = 0;       /* The etd for the document as a whole. */
struct etd *etagreal = 0;     /* Actual or dummy etd that implied this tag. */
struct etd *newetd = 0;       /* The etd for a start- or end-tag recognized. */
struct etd *nextetd = 0;      /* ETD that must come next (only one choice). */
struct etd *stagreal = 0;     /* Actual or dummy etd that implied this tag. */
struct parse *conpcb = 0;     /* Current PCB for content parse. */
UNCH *antvptr = 0;            /* Name token value returned by antvget. */
UNCH *data = 0;               /* Pointer to returned data in buffer. */
UNCH *mdname = 0;             /* Name of current markup declaration. */
UNCH *ptcon = 0;              /* Current pointer into tbuf. */
UNCH *ptpro = 0;              /* Current pointer into tbuf. */
UNCH *pvalptr = 0;            /* Pointer to parsed attribute value. */
UNCH *rbuf = 0;               /* DOS file read area (including RCC buffer). */
UNCH *rbufs = 0;              /* DOS file read area: start position for read. */
UNCH *subdcl = 0;             /* Subject of markup declaration (e.g., GI). */
UNCH Tstart = 0;              /* Save starting token for AND group testing. */
UNS conradn = 0;              /* 1=CONREF attribute in list (0=no). */
UNS datalen = 0;              /* Length of returned data in buffer. */
UNS entlen = 0;               /* Length of TAG or EXTERNAL entity text. */
UNS idadn = 0;                /* Number of ID attribute (0 if none). */
UNS noteadn = 0;              /* Number of NOTATION attribute (0 if none). */
UNS pifldlen = 0;             /* Length of field in public identifier (EOS). */
UNS reqadn = 0;               /* Num of atts with REQUIRED default (0=none). */
/******************************************************************************/
/* Variable arrays and structures: initialization not required for each pass.
*/
char ntoabuf[4] = {0};        /* Buffer for returned string. */
int *tprc;                    /* Pointer to text processor return code holder.*/
UNIV *tprcbp;                 /* Pointer to text processor rcb pointer. */
struct ad al[ATTCNT+2] = {0};   /* Current attribute list work area. */
struct dcncb *dcntab[1] = {0};  /* List of data content notation names. */
struct entity *aentl[GRPCNT] = {0};  /*ECBs for AENTITY tokens in an att list.*/
struct entity *etab[ENTHASH] = {0};  /* Entity hash table. */
struct etd *etdtab[ETDHASH] = {0};  /* Element type definition hash table. */
struct fpi fpidf = {0};       /* Fpi for #DEFAULT entity. */
struct id *itab[IDHASH] = {0};  /* Unique identifier hash table. */
struct ipberr ie = {0};       /* IPB: From SGML for error handling services.*/
struct ipbfile io = {0};      /* IPB: file I/O services from text processor.*/
struct ipbmem im = {0};       /* IPB: memory services from text processor. */
struct rcbdata rcbdaf = {SGMLDAF};    /* RCB: data, record end, pi, eod. */
struct rcbtag rcbetag = {SGMLETG};    /* RCB: end-tag. */
struct rcbtag rcbstag = {SGMLSTG};    /* RCB: start-tag. */
struct restate scbsgml[TAGLVL+1] = {0};  /* SGMLACT: return action state stack. */
struct source scbs[ENTLVL+1] = {0};  /* Stack of open sources ("SCB stack"). */
struct srh *srhtab[1] = {0};  /* List of SHORTREF table headers. */
struct stat ds = {0};         /* Document statistics. */
struct switches sw = {0};     /* Parser control switches set by text proc. */
struct tag tags[TAGLVL+1] = {0};   /* Stack of open elements ("tag stack"). */
struct thdr gbuf[GRPGTCNT+2] = {0};  /* Buffer for creating group. */
struct thdr prcon[3] = {0};   /* 0-2: Model for *DOC content. */
struct thdr undechdr = {0};   /* 0:Default model hdr for undeclared content.*/
UNCH dtype[NAMELEN+2] = {0};  /* Document type name. */
UNCH entbuf[NAMELEN+2] = {0};   /* Buffer for entity reference name. */
UNCH fce[2] = {0};            /* String form of FCE char (fce[1] must be EOS).*/
UNCH nonchbuf[2] = {0};       /* Buffer for valid nonchar character reference.*/
UNCH tbuf[ATTSPLEN+LITLEN+2];   /* Work area for tokenization. */
 UNCH *lbuf = tbuf+ATTSPLEN;  /* In tbuf: Literal parse area; TAGLEN limit.*/
/******************************************************************************/
/* Constants.
*/
struct map dctab[] = {        /* Keywords for declared content parameter.*/
     syn.k.rcdata,  MRCDATA+MPHRASE,
     syn.k.cdata,   MCDATA+MPHRASE,
     syn.k.any,     MANY+MCHARS+MGI,
     syn.k.empty,   MNONE+MPHRASE,
     NULL,          0
};
struct map deftab[] = {       /* Default value keywords. */
     syn.k.implied,  DNULL ,
     syn.k.required, DREQ  ,
     syn.k.current,  DCURR ,
     syn.k.conref,   DCONR ,
     syn.k.fixed,    DFIXED,
     NULL,           0
};
struct map dvtab[] = {        /* Declared value: keywords and type codes.*/
/*                                TYPE      NUMBER   */
/*   grp             ANMTGRP      Case 1 0  Grp size */
/*   grp member      ANMTGRP      Case   0  Position */
/*   grp             ANOTEGRP     Case 1 1  Grp size */
     syn.k.notation, ANOTEGRP, /* Case   1  Position */
     syn.k.cdata,    ACHARS  , /* Case   2  Always 0 */
     syn.k.entitee,  AENTITY , /* Case   3  Normal 1 */
     syn.k.idiot,    AID     , /* Case   4  Normal 1 */
     syn.k.idref,    AIDREF  , /* Case   5  Normal 1 */
     syn.k.name,     ANAME   , /* Case   6  Normal 1 */
     syn.k.nmtoken,  ANMTOKE , /* Case   7  Normal 1 */
     syn.k.number,   ANUMBER , /* Case   8  Normal 1 */
     syn.k.nutoken,  ANUTOKE , /* Case   9  Normal 1 */
     syn.k.entities, AENTITYS, /* Case   A  Normal 1 */
     syn.k.idrefs,   AIDREFS , /* Case   B  # tokens */
     syn.k.names,    ANAMES  , /* Case   C  # tokens */
     syn.k.nmtokens, ANMTOKES, /* Case   D  # tokens */
     syn.k.numbers,  ANUMBERS, /* Case   E  # tokens */
     syn.k.nutokens, ANUTOKES, /* Case   F  # tokens */
     NULL,           0         /* Case   0  ERROR    */
};
struct map enttab[] = {       /* Entity declaration second parameter. */
     syn.k.cdata,     ESC ,
     syn.k.sdata,     ESX ,
     syn.k.ms,        ESMS,
     syn.k.pi,        ESI ,
     syn.k.starttag,  ESS ,
     syn.k.endtag,    ESE ,
     syn.k.md,        ESMD,
     NULL,            0
};
struct map exttab[] = {       /* Keywords for external identifier. */
     syn.k.system,    EDSYSTEM,
     syn.k.public,    EDPUBLIC,
     NULL,            0
};
struct map extettab[] = {       /* Keywords for external entity type. */
     syn.k.cdata,     ESNCDATA,
     syn.k.ndata,     ESNNDATA,
     syn.k.sdata,     ESNSDATA,
     syn.k.subdoc,    ESNSUB,
     NULL,            0
};
struct map funtab[] = {       /* Function character reference names. */
     syn.k.re,       RECHAR,
     syn.k.rs,       RSCHAR,
     syn.k.tab,      TABCHAR,
     syn.k.space,    SPCCHAR,
     NULL,           0
};
struct map mstab[] = {        /* Marked section keywords. */
     syn.k.temp,    MSTEMP  ,
     syn.k.include, MSTEMP  , /* Treat INCLUDE like TEMP; both are NOPs.*/
     syn.k.rcdata,  MSRCDATA,
     syn.k.cdata,   MSCDATA ,
     syn.k.ignore,  MSIGNORE,
     NULL,          0
};
struct map pubcltab[] = {     /* Keywords for public text class. */
     syn.k.capacity,  FPICAP  ,
     syn.k.charset,   FPICHARS,
     syn.k.document,  FPIDOC  ,
     syn.k.dtd,       FPIDTD  ,
     syn.k.elements,  FPIELEM ,
     syn.k.entities,  FPIENT  ,
     syn.k.lpd,       FPILPD  ,
     syn.k.nonsgml,   FPINON  ,
     syn.k.notation,  FPINOT  ,
     syn.k.shortref,  FPISHORT,
     syn.k.subdoc,    FPISUB  ,
     syn.k.syntax,    FPISYN  ,
     syn.k.text,      FPITEXT ,
     NULL,            0
};
UNCH indefent[10] = "\12#DEFAULT";   /* Internal name: default entity name. */
UNCH indefetd[10] = "\12*DOCTYPE";   /* Internal name: default document type. */
UNCH indocent[10] = "\12*SGMLDOC";   /* Internal name: SGML document entity. */
UNCH indocetd[6]  = "\6*DOC";        /* Internal name: document level etd. */
UNCH indtdent[9]  = "\11*DTDENT";    /* Internal name: external DTD entity. */
