/******************************************************************************/
/* C88 call to environ() replaced with call to (non-ANSI) getenv().           */
/******************************************************************************/
/* Traceend and tracegi: changed HITS to %08x.                                */
/* TO DO: Revise all pointer formats (%04x) to work with far pointers also.   */
/******************************************************************************/
#include "sgmlincl.h"         /* #INCLUDE statements for SGML parser. */
/******************************************************************************/
/*lint -library                  Ignore failure to use library functions. */
#include <stdio.h>            /* Stream I/O functions. */
/*lint -restore                  End of library function declarations. */
/******************************************************************************/
/* Trace variables.
*/
int  trace = 0;               /* Switch: 1=trace state transitions; 0=don't. */
int atrace = 0;               /* Switch: 1=trace attribute activity; 0=don't. */
int ctrace = 0;               /* Switch: 1=trace context checking; 0=don't. */
int dtrace = 0;               /* Switch: 1=trace declaration parsing; 0=don't.*/
int etrace = 0;               /* Switch: 1=trace entity activity; 0=don't.*/
int gtrace = 0;               /* Switch: 1=trace group creations; 0=don't. */
int itrace = 0;               /* Switch: 1=trace ID activity; 0=don't. */
int mtrace = 0;               /* Switch: 1=trace MS activity; 0=don't. */
int ntrace = 0;               /* Switch: 1=trace notation activity; 0=don't. */
UNCH emd[] = "EMD";           /* For "EMD" parameter type in dtrace calls. */
UNCH estype1[] =              /* For estore values in trace messages. */
     " TMMMSEIXCNFPDLK";
UNCH estype2[] =              /* For estore values in trace messages. */
     "  DS            ";
/******************************************************************************/
#define TESTENV(name) (getenv(name)!=0)
/******************************************************************************/
/* TRACESET: Set switches for tracing body of document.
             If any environment value has been
             set for a switch, the switch is set to 1.
*/
void traceset()
{
      trace = TESTENV("T");
     atrace = TESTENV("A");
     ctrace = TESTENV("C");
     dtrace = TESTENV("D");
     etrace = TESTENV("E");
     gtrace = TESTENV("G");
     itrace = TESTENV("I");
     mtrace = TESTENV("M");
     ntrace = TESTENV("N");

     if (trace||atrace||ctrace||dtrace||etrace||gtrace||itrace||mtrace||ntrace)
          printf(
"\nTRACESET: state=%d;att=%d;con=%d;dcl=%d;ent=%d;grp=%d;id=%d;ms=%d;dcn=%d.",
             trace,   atrace,ctrace,dtrace,etrace,gtrace,itrace,mtrace,ntrace);
}
/******************************************************************************/
/* TRACEPRO: Set switches for tracing prolog.  If any environment value has been
             set for a switch, the switch is set to 1.
*/
void tracepro()
{
      trace = TESTENV("PT");
     atrace = TESTENV("PA");
     dtrace = TESTENV("PD");
     etrace = TESTENV("PE");
     gtrace = TESTENV("PG");
     mtrace = TESTENV("PM");
     ntrace = TESTENV("PN");

     if (trace||atrace||dtrace||etrace||gtrace||mtrace||ntrace) printf(
"\nTRACEPRO: state=%d; att=%d; dcl=%d; ent=%d; grp=%d; ms=%d;  dcn=%d.",
             trace,    atrace, dtrace, etrace, gtrace, mtrace, ntrace);
}
/******************************************************************************/
/* TRACEPCB: Trace character just parsed and other pcb data.
*/
void tracepcb(pcb)
struct parse *pcb;
{
     printf ("\n%-8s %2u-%2u-%2u-%2u from %c [%3d] in %s, %d:%d.",
            pcb->pname, pcb->state, pcb->input, pcb->action,
            pcb->newstate, ZAPEOL(*FPOS), *FPOS, ENTITY+1, RCNT,
            RSCC+FPOS+1-FBUF);
}
/******************************************************************************/
/* TRACETKN: Trace character just read during token parse.
*/
void tracetkn(scope, lextoke)
int scope;
UNCH lextoke[];               /* Lexical table for token and name parses. */
{
     printf("\nTOKEN    %2d-%2d       from %c [%3d] in %s, %d:%d.",
            scope, lextoke[*FPOS],
            ZAPEOL(*FPOS), *FPOS, ENTITY+1, RCNT,
            RSCC+FPOS+1-FBUF);
}
/******************************************************************************/
/* TRACEGML: Trace state of main SGML driver routine.
*/
void tracegml(scb, pss, conactsw, conact)
struct restate *scb;
int pss, conactsw, conact;
{
  printf("\nSGML%02d   %2d-%2d-%2d-%2d in main driver; conactsw=%d; conact=%d.",
         pss, scb[pss].sstate, scb[pss].sinput, scb[pss].saction,
         scb[pss].snext, conactsw, conact);
}
/******************************************************************************/
/* TRACEVAL: Trace parse of an attribute value that is a token list.
*/
void traceval(pcb, atype, aval, tokencnt)
struct parse *pcb;
UNS atype;                    /* Type of token list expected. */
UNCH *aval;                   /* Value string to be parsed as token list. */
int tokencnt;                 /* Number of tokens found in attribute value. */
{
     printf("\n%-8s %2d-%2d-%2d-%2d at %04x, atype=%02x, tokencnt=%d: ",
            pcb->pname, pcb->state, pcb->input, pcb->action,
            pcb->newstate, aval, atype, tokencnt);
     printf("%s", aval);
}
/******************************************************************************/
/* TRACESTK: Trace entry just placed on tag stack.
*/
void tracestk(pts, ts2, etictr)
struct tag *pts;              /* Stack entry for this tag. */
int ts2;                      /* Stack depth. */
int etictr;                   /* Number of "netok" tags on stack. */
{
     printf("\nSTACK    %s begun; stack depth %d; tflag=%02x; etictr=%d",
            pts->tetd->etdgi+1, ts2, pts->tflags, etictr);
     printf(" srm=%s.", pts->tsrm!=SRMNULL ? pts->tsrm[0]->ename+1 : "#EMPTY");
}
/******************************************************************************/
/* TRACEDSK: Trace entry just removed from tag stack.
*/
void tracedsk(pts, ptso, ts3, etictr)
struct tag *pts;              /* Stack entry for new open tag. */
struct tag *ptso;             /* Stack entry for tag just ended. */
int ts3;                      /* Stack depth. */
int etictr;                   /* Number of "netok" tags on stack. */
{
     printf(
"\nDESTACK  %s ended; otflag=%02x; %s resumed; depth=%d; tflag=%02x; etictr=%d",
           ptso->tetd->etdgi+1, ptso->tflags,
           pts->tetd->etdgi+1, ts3, pts->tflags, etictr);
     printf(" srm=%s.", pts->tsrm!=SRMNULL ? pts->tsrm[0]->ename+1 : "#EMPTY");
}
/******************************************************************************/
/* TRACECON: Trace interactions between content parse and stag/context
             processing.
*/
void tracecon(etagimct, dostag, datarc, pcb, conrefsw, didreq)
int etagimct;                 /* Implicitly ended elements left on stack. */
int dostag;                   /* 1=retry newetd instead of parsing; 0=parse. */
int datarc;                   /* Return code for data: DAF_ or REF_ or zero. */
struct parse *pcb;            /* Parse control block for this parse. */
int conrefsw;                 /* 1=content reference att specified; 0=no. */
int didreq;                   /* 1=required implied empty tag processed; 0=no.*/
{
     printf("\nCONTENT  etagimct=%d dostag=%d datarc=%d pname=%s action=%d \
conrefsw=%d didreq=%d",
           etagimct, dostag, datarc, pcb->pname, pcb->action, conrefsw, didreq);
}
/******************************************************************************/
/* TRACESTG: Trace start-tag context validation input and results.
*/
void tracestg(curetd, dataret, rc, nextetd, mexts)
struct etd *curetd;           /* The etd for this tag. */
int dataret;                  /* Data pending: DAF_ REF_ 0=not #PCDATA. */
int rc;                       /* Return code from context or other test. */
struct etd *nextetd;          /* The etd for a forced start-tag (if rc==2). */
int mexts;                    /* >0=stack level of minus grp; -1=plus; 0=none.*/
{
    printf("\nSTARTTAG newetd=%04x; dataret=%d; rc=%d; nextetd=%04x; mexts=%d.",
           curetd, dataret, rc, nextetd, mexts);
}
/******************************************************************************/
/* TRACEETG: Trace end-tag matching test on stack.
*/
void traceetg(pts, curetd, tsl, etagimct)
struct tag *pts;              /* Stack entry for this tag. */
struct etd *curetd;           /* The etd for this tag. */
int tsl;                      /* Temporary stack level for looping. */
int etagimct;                 /* Num of implicitly ended tags left on stack. */
{
     printf(
"\nENDTAG   tsl=%d; newetd=%04x; stacketd=%04x; tflags=%02x; etagimct=%d.",
            tsl, curetd, pts->tetd, pts->tflags, etagimct);
}
/******************************************************************************/
/* TRACEECB: Trace entity control block activity.
*/
void traceecb(action, p)
UNCH *action;
struct entity *p;
{
     printf("\n%-8s (es=%d) type %c%c entity %s at %04x containing ",
           action, es, estype1[p->estore], estype2[p->estore], p->ename+1, p);
     if (p->estore==ESS || p->estore==ESE) printf("%s tag.",
          p->etx.e==ETDNULL ? "null" : p->etx.e->etdgi+1);
     else if (p->estore==ESN && strcmp(action, "ENTDEF")) traceesn(p->etx.n);
     else if (p->etx.x==0) printf("[NOTHING]");
     else printf("%s", *(p->etx.c+1)  ? p->etx.c+1 : "[EMPTY]");
}
/******************************************************************************/
/* TRACEDCN: Trace data content notation activity.
*/
void tracedcn(p)
struct dcncb *p;
{
     printf(
"\nDCN      dcn=%04x; adl=%04x; notation is %s=>%s",
            p, p->adl, p->ename+1,
            (p->dcnid!=0) ? ((char *)p->dcnid)+1 : "[UNDEFINED]"
     );
     if (p->adl) traceadl(p->adl);
}
/******************************************************************************/
/* TRACEESN: Print a data entity control block.
*/
void traceesn(p)
PNE p;
{
     printf("\nESN      Entity name is %s; entity type is %s.",
            (NEENAME(p)!=0) ? ((STRING)NEENAME(p))+1 : "[UNDEFINED]",
         /* NEXTYPE(p)); */
            (NEXTYPE(p)==1 ? "CDATA" : (NEXTYPE(p)==2 ? "NDATA" : "SDATA")));
     printf("\n         System ID is %s",
            (NEID(p)!=0) ? ((STRING)NEID(p))+1 : "[UNDEFINED]");
     if (p->nedcn!=0) tracedcn(p->nedcn);
}
/******************************************************************************/
/* TRACESRM: Print the members of a short reference map.
*/
void tracesrm(action, pg, gi)
UNCH *action;
TECB pg;
UNCH *gi;
{
     int i = 0;               /* Loop counter. */

     if (pg==SRMNULL) printf("\n%-8s SHORTREF table empty for %s.", action, gi);
     else {
          printf("\n%-8s %s at %04x mapped for %s.",
                 action, pg[0]->ename+1, pg, gi ? gi : "definition");
          while (++i<=lex.s.dtb[0].mapdata) if (pg[i])
               printf("\n%14s%02u %04x %s", "SR", i, pg[i], pg[i]->ename+1);
     }
}
/******************************************************************************/
/* TRACEADL: Print an attribute definition list.
*/
void traceadl(al)
struct ad al[];
{
     int i=0;

     printf("\nADLIST   %04x %d membe%s; %d attribut%s",
           al, ADN, ADN==1 ? "r" : "rs", AN, AN==1 ? "e" : "es");
     while (++i<=ADN) {
          printf(
               (BITOFF(ADFLAGS(i), AGROUP) && ADTYPE(i)<=ANOTEGRP)
              ? "\n          %04x %-8s %02x %02x %2d %2d %04x %04x"
              :       "\n    %04x %-8s %02x %02x %2d %2d %04x %04x ",
               &al[i], ADNAME(i), ADFLAGS(i), ADTYPE(i), ADNUM(i),
               ADLEN(i), ADVAL(i), ADDATA(i).x
          );
          if (ADVAL(i)) {
          /*   write(stdout, ADVAL(i)+1, *ADVAL(i)-2); */
               printf("%.*s", *ADVAL(i)-2, ADVAL(i)+1);
               if (ADTYPE(i)==AENTITY && ADDATA(i).n!=0) {
                    printf("=>");
                    traceesn(ADDATA(i).n);
               }
               else if (ADTYPE(i)==ANOTEGRP)
                    printf("=>%s", (ADDATA(i).x!=0) ?
                          ((STRING)ADDATA(i).x)+1 : "[UNDEFINED]");
          }
          else printf("[%s]", GET(ADFLAGS(i), AREQ)     ? "REQUIRED" :
                             (GET(ADFLAGS(i), ACURRENT) ? "CURRENT"  :
                                                       "NULL"));
     }
    printf("\n");
}
/******************************************************************************/
/* TRACEMOD: Print the members of a model.
*/
void tracemod(pg)
struct thdr pg[];
{
     int i=0;

     printf("\nMODEL    %04x %02x %d", &pg[0], pg[0].ttype, pg[0].tu.tnum);
     while (++i <= pg[0].tu.tnum) {
          if (GET(pg[i].ttype, TTMASK)==TTETD)
               printf("\n                      %04x %02x %s",
                      &pg[i], pg[i].ttype, pg[i].tu.thetd->etdgi+1);
          else if (GET(pg[i].ttype, TTMASK)==TTCHARS)
               printf("\n                      %04x %02x %s",
                      &pg[i], pg[i].ttype, "#PCDATA");
          else printf("\n         %04x %02x %d",
               &pg[i], pg[i].ttype, pg[i].tu.tnum);
     }
     printf("\n");
}
/******************************************************************************/
/* TRACEGRP: Print the members of a name (i.e., etd) group.
*/
void tracegrp(pg)
struct etd *pg[];
{
     int i = -1;              /* Loop counter. */

     printf("\nETDGRP   %04x", pg);
     while (pg[++i]!=0) printf("\n         %04x %s", pg[i], pg[i]->etdgi+1);
}
/******************************************************************************/
/* TRACENGR: Print the members of a notation (i.e., dcncb) group.
*/
void tracengr(pg)
struct dcncb *pg[];
{
     int i = -1;              /* Loop counter. */

     printf("\nDCNGRP   %04x", pg);
     while (pg[++i]!=0) printf("\n         %04x %s", pg[i], pg[i]->ename+1);
}
/******************************************************************************/
/* TRACEETD: Print an element type definition.
*/
void traceetd(p)
struct etd *p;                /* Pointer to an etd. */
{
     printf(
"\nETD      etd=%04x %s min=%02x cmod=%04x ttype=%02x mex=%04x, pex=%04x, ",
            p, p->etdgi+1, p->etdmin, p->etdmod,
            p->etdmod->ttype, p->etdmex, p->etdpex
     );
     printf("adl=%04x, srm=%s.", p->adl,
            (p->etdsrm==SRMNULL) ? "#EMPTY" : (p->etdsrm)
                                 ? p->etdsrm[0]->ename+1 : "#CURRENT"
     );
}
/******************************************************************************/
/* TRACEID: Print an ID control block.
*/
void traceid(action, p)
UNCH *action;
struct id *p;                 /* Pointer to an ID. */
{
     printf("\n%-8s %s at %04x is ", action, p->idname+1, p);
     if (p->idl) printf("ID of %s in %s, %d:%d; ", p->idl->letdgi+1,
                        p->idl->lename+1, p->idl->lrcnt, p->idl->lccnt);
     else printf("an undefined ID; ");
     printf("hits=%08lx last ref=%04x", idrefl, p->idrl);
}
/******************************************************************************/
/* TRACEMD: Trace a markup declaration parameter.
*/
void tracemd(parmid)
UNCH *parmid;                 /* Parameter identifier. */
{
     printf("\nMDPARM   %-8s for %-8s, token %02d, type %02u, %s.",
           mdname, subdcl ? subdcl : "[NONE]", parmno, pcbmd.action, parmid);
}
/******************************************************************************/
/* TRACEMAP: Trace a map search.
*/
void tracemap(mapnm, key, data)
UNCH *mapnm;                  /* Name in map being searched. */
UNCH *key;                    /* Search key. */
int data;                     /* Data associated with key in map. */
{
     printf("\nMAPSRCH  %s == %-8s=>%d", key, mapnm, data);
}
/******************************************************************************/
/* TRACEMS: Trace marked section activity.
*/
void tracems(action, code, mslevel, msplevel)
int action;                   /* 1=began new level; 0=resumed previous. */
int code;
int mslevel;                  /* Nesting level of marked sections. */
int msplevel;                 /* Nested MS levels subject to special parse. */
{
     printf("\nMS%c      %2d                 %s nesting level %d (msp %d).",
          (action ? ' ' : 'E'), code, (action ? "began" : "resumed"),
          mslevel, msplevel);
}
/******************************************************************************/
#define STATUX tags[ts].status/* Token status: RCHIT RCMISS RCEND RCREQ RCNREQ*/
#define M      pos[0].g       /* Index of current token in model. */
#define P      pos[0].t       /* Index of current group in pos. */
#define G      pos[P].g       /* Index of current group in model. */
#define T      pos[P].t       /* Index of current token in its group. */
#define H      pos[P].h       /* Hit bits for current group's tokens (1=hit). */
#define GHDR   mod[G]         /* Current group header. */
#define TOKEN  mod[M]         /* Current token. */
#define TTYPE (GET(TOKEN.ttype, TTMASK))  /* Token type of current token. */
#define TOCC  (GET(TOKEN.ttype, TOREP))   /* Occurrence for current token. */
#define GTYPE (GET(GHDR.ttype, TTMASK))   /* Token type of current group. */
#define GOCC  (GET(GHDR.ttype, TOREP))    /* Occurrence for current group. */
#define GNUM  GHDR.tu.tnum                /* Number of tokens in current grp. */
/******************************************************************************/
/* TRACEGI: Trace GI testing stages in CONTEXT.C processing.
*/
void tracegi(stagenm, gi, mod, pos, Tstart)
UNCH *stagenm;
struct etd *gi;               /* ETD of new GI. */
struct thdr mod[];            /* Model of current open element. */
struct mpos pos[];            /* Position in open element's model. */
int Tstart;                   /* Initial T for this group. */
{
     int i = 0;               /* Loop counter. */

     printf("\n%-10s %d:", stagenm, P);
     while (++i<=P) printf(" %d-%d", pos[i].g, pos[i].t);
     printf(" (%u) gocc=%02x gtype=%02x gnum=%d H=%08lx status=%d Tstart=%d",
            M, GOCC, GTYPE, GNUM, H, STATUX, Tstart);
     printf("\n=>%-8s tocc=%02x ttype=%02x thetd=%04x (%s) gietd=%04x (%s)",
          tags[ts].tetd->etdgi+1, TOCC, TTYPE, TOKEN.tu.thetd,
          (TTYPE ? (TTYPE==TTETD ? TOKEN.tu.thetd->etdgi+1 : "#GROUP")
          : "#PCDATA"), gi, (gi==ETDCDATA ?  "#PCDATA" : gi->etdgi+1));
}
/******************************************************************************/
/* TRACEEND: Trace testing for end of group in CONTEXT.C processing.
*/
void traceend(stagenm, mod, pos, rc, opt, Tstart)
UNCH *stagenm;
struct thdr mod[];            /* Model of current open element. */
struct mpos pos[];            /* Position in open element's model. */
int rc;                       /* Return code: RCNREQ RCHIT RCMISS RCEND */
int opt;                      /* ALLHIT parm: 1=test optionals; 0=ignore. */
int Tstart;                   /* Initial T for this group. */
{
     int i = 0;               /* Loop counter. */

     printf("\n%-10s %d:", stagenm, P);
     while (++i<=P) printf(" %d-%d", pos[i].g, pos[i].t);
     printf(" (%u) gocc=%02x gtype=%02x gnum=%d H=%08lx status=%d Tstart=%d",
            M, GOCC, GTYPE, GNUM, H, STATUX, Tstart);
     printf("\n=>%-8s tocc=%02x ttype=%02x thetd=%04x (%s)",
           tags[ts].tetd->etdgi+1, TOCC, TTYPE, TOKEN.tu.thetd, (TTYPE ?
           (TTYPE==TTETD ? TOKEN.tu.thetd->etdgi+1 : "#GROUP") : "#PCDATA"));
     printf(" rc=%d offbitT=%d allhit=%d",
           rc, offbit(H, (int)T, GNUM), allhit(&GHDR, H, 0, opt));
}
/******************************************************************************/
