/* $Header: doc_pars.c,v 3.4 90/04/12 10:19:58 jos Exp $ */
/*
 *  This file is part of the Amsterdam SGML Parser.
 *
 *  Copyright: Faculteit Wiskunde en Informatica
 *             Department of Mathematics and Computer Science
 *             Vrije Universiteit Amsterdam
 *             The Netherlands
 *
 *  Authors:   Sylvia van Egmond
 *             Jos Warmer
 */
#include "types.h"
#include "Lpars.h"
#include "att_chk.h"
#include "charclas.h"
#include "conc_syn.h"
#include "elem_stk.h"
#include "entity.h"
#include "in.h"
#include "out.h"
#include "lexical.h"
#include "myerror.h"
#include "rep_pars.h"
#include "shortref.h"

extern void LLparse();

#ifdef DEBUG
FILE *fpdg = 0; /* file pointer debug global */
#endif

main(argc, argv)
int    argc;
char  *argv[];
{
    String file    = 0;
    String replace = 0;
    String loc     = 0;
    Bool   error   = FALSE;
#ifdef DEBUG
    Bool   flags   = FALSE;
    extern void debug_doc      (PAR  Bool  RAP),
		debug_extern   (PAR  Bool  RAP),
		debug_marked   (PAR  Bool  RAP),
		debug_rules    (PAR  Bool  RAP),
		debug_shortnot (PAR  Bool  RAP);
#endif

#ifdef VMS
    fclose(stdout);
    stdout = fopen("doc_vol", "w");
#endif

#ifdef DEBUG
    switch (argc) {
	case 2 : file = argv[1]; break;
	case 3 : if ((argv[1][0] == '-') and (argv[1][1] != 'r') and
		     (argv[1][1] != 'z')) {
		     file  = argv[2];
		     flags = TRUE;
		 } else error = TRUE;
		 break;
	case 4 : if (argv[1][0] == '-') {
		     if (argv[1][1] == 'r') {
		         file    = argv[3];
		         replace = argv[2];
		     } else if (argv[1][1] == 'z') {
		         file   = argv[3];
		         loc    = argv[2];
		     }
		     else error = TRUE;
		 } else error = TRUE;
		 break;
	case 5 : if ((argv[1][0] == '-') and (argv[1][1] != 'r') and
	             (argv[1][1] != 'z') and (argv[2][0] == '-')) {
		     if (argv[2][1] == 'r') {
		         file    = argv[4];
		         replace = argv[3];
		         flags   = TRUE;
		     } else if (argv[2][1] == 'z') {
		         file   = argv[4];
		         loc    = argv[3];
		         flags  = TRUE;
		     } else error = TRUE;
		 } 
		 else error = TRUE;
		 break;
	case 7 : if ((argv[1][0] == '-') and (argv[1][1] != 'r') and
		     (argv[1][1] != 'z') and (argv[2][0] == '-') and
		     (argv[4][0] == '-')) {
		     if ((argv[2][1] == 'r') and (argv[4][1] == 'z')) {
			 file    = argv[6];
			 replace = argv[3];
			 loc     = argv[5];
			 flags   = TRUE;
		     }
		     else if ((argv[2][1] == 'z') and (argv[4][1] == 'r')) {
			 file    = argv[6];
			 loc     = argv[3];
			 replace = argv[5];
			 flags   = TRUE;
		     }
		     else error = TRUE;
		 } else error = TRUE;
		 break;
	default: error = TRUE;   break;
    }

    if (error) {
	fprintf(stderr,"usage: %s [-cdeiklmst] { [-r <replacement file_name>] [-z string for error report] } file_name\n", argv[0]);
	exit(1);
    }

    if (flags) {          /* process flags */
	int i = 1;
	while( argv[1][i] != '\0' ){
	    switch( argv[1][i] ){
		case 'c' : debug_rep_parser(TRUE); break;
		case 'd' : fpdg = stderr;          break;
		case 'e' : debug_entity(TRUE);
			   debug_doc(TRUE);
			   debug_extern(TRUE);
			   break;
		case 'i' : debug_in(TRUE);         break;
		case 'k' : debug_marked(TRUE);     break;
		case 'l' : debug_lexical(TRUE);    break;
		case 'm' : debug_myerror(TRUE);    break;
		case 's' : debug_shortref(TRUE);
			   debug_shortnot(TRUE);
			   break;
		case 't' : debug_attchk(TRUE);
			   debug_rules(TRUE);
			   break;
		default  : fprintf(stderr, "%s: illegal flag %c\n",
					   argv[0], argv[1][i]);
			   break;
	    }
	    i++;
	}
    }
    if ((not fpdg) and flags and ((fpdg = fopen("debug_info2", "w")) == 0)) {
	report(FILE_OPEN, FATAL, 0, 0, "debug_info2");
    }
#else
    switch (argc) {
	case 2 : file = argv[1]; break;
	case 4 : if ((argv[1][0] == '-') and  (argv[1][1] == 'r')) {
		     file    = argv[3];
		     replace = argv[2];
		 }
	         else if ((argv[1][0] == '-') and  (argv[1][1] == 'z')) {
		     file   = argv[3];
		     loc    = argv[2];
		 } else error = TRUE;
		 break;
	case 6 : if ((argv[1][0] == '-') and (argv[3][0] == '-')) {
		     if ((argv[1][1] == 'r') and (argv[3][1] == 'z')) {
			 file    = argv[5];
			 replace = argv[2];
			 loc     = argv[4];
		     }
		     else if ((argv[1][1] == 'z') and (argv[3][1] == 'r')) {
			 file    = argv[5];
			 loc     = argv[2];
			 replace = argv[4];
		     } else error = TRUE;
		 }
		 else error = TRUE;
		 break;
	default: error = TRUE;   break;
    }
    if (error) {
	fprintf(stderr,"usage: %s { [-r <replacement file_name>] [-z string for error report] } file_name\n", argv[0]);
	exit(1);
    }
#endif

    init_conc();
    init_input(file, loc);
    init_lexical();
    init_entity();
    init_open_el();
    init_shortref();
    init_out(replace);
    init_charclas();

    document();

    fatal_report();

#ifdef VMS
    fclose(stdout);
#endif

#ifdef DEBUG
    if( fpdg != stderr ){
	if( fpdg != NULL ){
	    fclose(fpdg);
	}
    }
#endif
return(0);
}
