{
#include "types.h"
#include "lexical.h"
#include "modes.h"
#include "startend.h"

static Bool error = FALSE;
static char string[DATALEN + 1];
}
QP :
	{ pars_start(ST_QP); }
	sep1 [%while(1) [%prefer [xpcdata(string, DATALEN, TRUE, &error)]|
	[[ST_CITE ] CITE ]|
	[[ST_EQ ] EQ ]|
	[[ST_B ] B ]|
	[[ST_C ] C ]|
	[[ST_I ] I ]|
	[[ST_R ] R ]|
	[[ST_EMQ ] EMQ ]|
	[[ST_Q ] Q ] ] sep1 ]* sep1
	END_QP
	{ pars_end(END_QP); }
	;
TP :
	{ pars_start(ST_TP); }
	sep1 [%while(1) [%prefer [xpcdata(string, DATALEN, TRUE, &error)]|
	[[ST_CITE ] CITE ]|
	[[ST_EQ ] EQ ]|
	[[ST_B ] B ]|
	[[ST_C ] C ]|
	[[ST_I ] I ]|
	[[ST_R ] R ]|
	[[ST_EMQ ] EMQ ]|
	[[ST_Q ] Q ] ] sep1 ]* sep1
	END_TP
	{ pars_end(END_TP); }
	;
LIST :
	{ pars_start(ST_LIST); }
	sep2 [[[ST_ITEM ] ITEM ]sep2 
	[%while(1) [[ST_ITEM ] ITEM  ] sep2 ]*] sep2
	END_LIST
	{ pars_end(END_LIST); }
	;
ITEM :
	{ pars_start(ST_ITEM); }
	sep1 [%while(1) [%prefer [xpcdata(string, DATALEN, TRUE, &error)]|
	[[ST_CITE ] CITE ]|
	[[ST_EQ ] EQ ]|
	[[ST_B ] B ]|
	[[ST_C ] C ]|
	[[ST_I ] I ]|
	[[ST_R ] R ]|
	[[ST_EMQ ] EMQ ]|
	[[ST_Q ] Q ] ] sep1 ]* sep1
	END_ITEM
	{ pars_end(END_ITEM); }
	;
H0 :
	{ pars_start(ST_H0); }
	sep1 [pcdata(string, DATALEN, TRUE, &error)] sep1
	END_H0
	{ pars_end(END_H0); }
	;
H1 :
	{ pars_start(ST_H1); }
	sep1 [pcdata(string, DATALEN, TRUE, &error)] sep1
	END_H1
	{ pars_end(END_H1); }
	;
H2 :
	{ pars_start(ST_H2); }
	sep1 [pcdata(string, DATALEN, TRUE, &error)] sep1
	END_H2
	{ pars_end(END_H2); }
	;
H3 :
	{ pars_start(ST_H3); }
	sep1 [pcdata(string, DATALEN, TRUE, &error)] sep1
	END_H3
	{ pars_end(END_H3); }
	;
H4 :
	{ pars_start(ST_H4); }
	sep1 [pcdata(string, DATALEN, TRUE, &error)] sep1
	END_H4
	{ pars_end(END_H4); }
	;
H5 :
	{ pars_start(ST_H5); }
	sep1 [pcdata(string, DATALEN, TRUE, &error)] sep1
	END_H5
	{ pars_end(END_H5); }
	;
H6 :
	{ pars_start(ST_H6); }
	sep1 [pcdata(string, DATALEN, TRUE, &error)] sep1
	END_H6
	{ pars_end(END_H6); }
	;
H7 :
	{ pars_start(ST_H7); }
	sep1 [pcdata(string, DATALEN, TRUE, &error)] sep1
	END_H7
	{ pars_end(END_H7); }
	;
H8 :
	{ pars_start(ST_H8); }
	sep1 [pcdata(string, DATALEN, TRUE, &error)] sep1
	END_H8
	{ pars_end(END_H8); }
	;
H9 :
	{ pars_start(ST_H9); }
	sep1 [pcdata(string, DATALEN, TRUE, &error)] sep1
	END_H9
	{ pars_end(END_H9); }
	;
ADDRESS :
	{ pars_start(ST_ADDRESS); }
	sep2 [[[ST_NAME ] NAME ]sep2 
	[%while(1) [[ST_ORG ] ORG  ] sep2 ]*sep2 
	[[[ST_STREET ] STREET ]sep2 
	[%while(1) [[ST_STREET ] STREET  ] sep2 ]*]sep2 
	[[ST_CITY ] CITY ]sep2 
	[[ST_CSUB ] CSUB ]sep2 
	[[ST_PCODE ] PCODE ]sep2 
	[[ST_COUNTRY ] COUNTRY ]?sep2 
	[[ST_PHONE ] PHONE ]sep2 
	[[ST_FAX ] FAX ]?sep2 
	[[ST_EMAIL ] EMAIL ]] sep2
	END_ADDRESS
	{ pars_end(END_ADDRESS); }
	;
CITY :
	{ pars_start(ST_CITY); }
	sep1 [pcdata(string, DATALEN, TRUE, &error)] sep1
	END_CITY
	{ pars_end(END_CITY); }
	;
COUNTRY :
	{ pars_start(ST_COUNTRY); }
	sep1 [pcdata(string, DATALEN, TRUE, &error)] sep1
	END_COUNTRY
	{ pars_end(END_COUNTRY); }
	;
CSUB :
	{ pars_start(ST_CSUB); }
	sep1 [pcdata(string, DATALEN, TRUE, &error)] sep1
	END_CSUB
	{ pars_end(END_CSUB); }
	;
EMAIL :
	{ pars_start(ST_EMAIL); }
	sep1 [pcdata(string, DATALEN, TRUE, &error)] sep1
	END_EMAIL
	{ pars_end(END_EMAIL); }
	;
FAX :
	{ pars_start(ST_FAX); }
	sep1 [pcdata(string, DATALEN, TRUE, &error)] sep1
	END_FAX
	{ pars_end(END_FAX); }
	;
