{
#include "types.h"
#include "lexical.h"
#include "modes.h"
#include "startend.h"

static Bool error = FALSE;
static char string[DATALEN + 1];
}
PTITLE :
	{ pars_start(ST_PTITLE); }
	sep1 [pcdata(string, DATALEN, TRUE, &error)] sep1
	END_PTITLE
	{ pars_end(END_PTITLE); }
	;
VOL :
	{ pars_start(ST_VOL); }
	sep1 [pcdata(string, DATALEN, TRUE, &error)] sep1
	END_VOL
	{ pars_end(END_VOL); }
	;
PDATE :
	{ pars_start(ST_PDATE); }
	sep1 [pcdata(string, DATALEN, TRUE, &error)] sep1
	END_PDATE
	{ pars_end(END_PDATE); }
	;
PAGES :
	{ pars_start(ST_PAGES); }
	sep1 [pcdata(string, DATALEN, TRUE, &error)] sep1
	END_PAGES
	{ pars_end(END_PAGES); }
	;
FIG :
	{ pars_start(ST_FIG); }
	sep2 [[[ST_FTITLE ] FTITLE ]?sep2 
	[[ST_FDATA ] FDATA ]] sep2
	END_FIG
	{ pars_end(END_FIG); }
	;
FTITLE :
	{ pars_start(ST_FTITLE); }
	sep1 [pcdata(string, DATALEN, TRUE, &error)] sep1
	END_FTITLE
	{ pars_end(END_FTITLE); }
	;
FDATA :
	{ pars_start(ST_FDATA); }
	sep1 [%while(1) [%prefer [xpcdata(string, DATALEN, TRUE, &error)]|
	[[ST_B ] B ]|
	[[ST_C ] C ]|
	[[ST_I ] I ]|
	[[ST_R ] R ]|
	[[ST_EMQ ] EMQ ]|
	[[ST_Q ] Q ] ] sep1 ]* sep1
	END_FDATA
	{ pars_end(END_FDATA); }
	;
TBL :
	{ pars_start(ST_TBL); }
	sep2 [[[ST_TTITLE ] TTITLE ]sep2 
	[[ST_THEAD ] THEAD ]sep2 
	[[[[ST_ROW ] ROW ]|
	[[ST_DLINE ] DLINE ]|
	[[ST_SLINE ] SLINE ]]sep2 
	[%while(1) [[[ST_ROW ] ROW ]|
	[[ST_DLINE ] DLINE ]|
	[[ST_SLINE ] SLINE ] ] sep2 ]*]] sep2
	END_TBL
	{ pars_end(END_TBL); }
	;
TTITLE :
	{ pars_start(ST_TTITLE); }
	sep1 [pcdata(string, DATALEN, TRUE, &error)] sep1
	END_TTITLE
	{ pars_end(END_TTITLE); }
	;
THEAD :
	{ pars_start(ST_THEAD); }
	sep2 [[[ST_COL ] COL ]sep2 
	[%while(1) [[ST_COL ] COL  ] sep2 ]*] sep2
	END_THEAD
	{ pars_end(END_THEAD); }
	;
ROW :
	{ pars_start(ST_ROW); }
	sep2 [[[ST_COL ] COL ]sep2 
	[%while(1) [[ST_COL ] COL  ] sep2 ]*] sep2
	END_ROW
	{ pars_end(END_ROW); }
	;
COL :
	{ pars_start(ST_COL); }
	sep1 [%while(1) [%prefer [xpcdata(string, DATALEN, TRUE, &error)]|
	[[ST_B ] B ]|
	[[ST_C ] C ]|
	[[ST_I ] I ]|
	[[ST_R ] R ]|
	[[ST_EMQ ] EMQ ]|
	[[ST_Q ] Q ] ] sep1 ]* sep1
	END_COL
	{ pars_end(END_COL); }
	;
DLINE :
	{ pars_start(ST_DLINE); }
	sep1 [pcdata(string, DATALEN, TRUE, &error)] sep1
	END_DLINE
	{ pars_end(END_DLINE); }
	;
SLINE :
	{ pars_start(ST_SLINE); }
	sep1 [pcdata(string, DATALEN, TRUE, &error)] sep1
	END_SLINE
	{ pars_end(END_SLINE); }
	;
DEQ :
	{ pars_start(ST_DEQ); }
	sep1 [pcdata(string, DATALEN, TRUE, &error)] sep1
	END_DEQ
	{ pars_end(END_DEQ); }
	;
EQ :
	{ pars_start(ST_EQ); }
	sep1 [pcdata(string, DATALEN, TRUE, &error)] sep1
	END_EQ
	{ pars_end(END_EQ); }
	;
AUTHINST :
	{ pars_start(ST_AUTHINST); }
	sep1 [pcdata(string, DATALEN, TRUE, &error)] sep1
	END_AUTHINST
	{ pars_end(END_AUTHINST); }
	;
AUTHNAME :
	{ pars_start(ST_AUTHNAME); }
	sep1 [pcdata(string, DATALEN, TRUE, &error)] sep1
	END_AUTHNAME
	{ pars_end(END_AUTHNAME); }
	;
OBS :
	{ pars_start(ST_OBS); }
	sep1 [pcdata(string, DATALEN, TRUE, &error)] sep1
	END_OBS
	{ pars_end(END_OBS); }
	;
UPD :
	{ pars_start(ST_UPD); }
	sep1 [pcdata(string, DATALEN, TRUE, &error)] sep1
	END_UPD
	{ pars_end(END_UPD); }
	;
