/* $Header: generate.c,v 3.1 88/05/19 15:34:38 jos Locked $ */
/*
 *  This file is part of the Amsterdam SGML Parser.
 *
 *  Copyright: Faculteit Wiskunde en Informatica
 *             Department of Mathematics and Computer Science
 *             Vrije Universiteit Amsterdam
 *             The Netherlands
 *
 *  Authors:   Sylvia van Egmond
 *             Jos Warmer
 */
#include "types.h"
#include "Lpars.h"
#include "ambigu.h"
#include "att_chk.h"
#include "att_gen.h"
#include "capacity.h"
#include "charclas.h"
#include "conc_syn.h"
#include "element.h"
#include "empty.h"
#include "entity.h"
#include "gen_code.h"
#include "gen_tagl.h"
#include "gen_tags.h"
#include "in.h"
#include "lexical.h"
#include "node.h"
#include "notation.h"
#include "omitstrt.h"
#include "shortref.h"

extern void LLparse();

#ifdef DEBUG
extern int mem_used;
extern int tot_nr_iters;
extern int tot_nr_groups;
extern int tot_nr_links;
extern int nr_groups;
extern int nr_links;

static int    print_elem = FALSE;
       FILE  *fpdg = 0;

void write_grammar(file_name)
String file_name;
{
    FILE* file;
    P_Iterator iter;
    P_Element  elem;

    file = fopen(file_name, "w");
    if (file == 0) {
	report(FILE_OPEN, FATAL, 0, 0, file_name);
    }
    iter = element_iterator();
    while( elem = next_element(iter) ){
	group_print(file, name_group(elem));
	fprintf(file, ": ");
	node_write(file, content(elem));
	fprintf(file, "\n");
    }
    fclose(file);
}

void print_grammar(file_name)
String file_name;
{
    P_Iterator   name_iter;
    String       name;
    P_Element    elem;
    P_Iterator   it;  
    FILE        *file;

    file = fopen(file_name, "w");
    if (file == 0) {
	report(FILE_OPEN, FATAL, 0, 0, file_name);
    }
    attrs_print(file);
    fprintf(file, "======================================\n");
    it = element_iterator();
    while( elem = (P_Element)iterator_next(it) ){
	group_print(file, name_group(elem));
        fprintf(file,": %d %d\n", omit_start(elem), omit_end(elem) );

	fprintf(file,"firstsym: ");
	sym_set_print(file, node_firstsym(content(elem)));
	fprintf(file,"\n");

	name_iter = group_iterator( name_group(elem) );
	while( name = next_name(name_iter) ){
	    fprintf(file, "short reference map for %s: `%s'\n",
			   name, element_map(name) );
	}
        fprintf(file,"Model: \n");
        node_print(file, content(elem));
        fprintf(file,"\nexclusions : ");
	group_print(file, exclusions(elem));
	fprintf(file,"\ninclusions : ");
	group_print(file, inclusions(elem));
        fprintf(file, "======================================\n");
    }
    fclose(file);
}
#endif

main(argc, argv)
int    argc;
char  *argv[];
{
    FILE        *map_src;
    FILE        *map_ext;
    FILE        *entity_file;
    FILE        *charclas_file;
    String       output_file = 0;
    String       input_file  = 0;
    Bool         error       = FALSE;
#ifdef DEBUG
    Bool         flags       = FALSE;
    extern void debug_doc      (PAR  Bool  RAP),
		debug_dtd      (PAR  Bool  RAP),
		debug_extern   (PAR  Bool  RAP),
		debug_marked   (PAR  Bool  RAP),
		debug_shortnot (PAR  Bool  RAP);
#endif

    
#ifdef DEBUG
    switch (argc) {
        case 3 : input_file  = argv[1];
                 output_file = argv[2];
                 break;
        case 4 : if (argv[1][0] == '-') {
                     output_file = argv[3];
                     input_file  = argv[2];
		     flags       = TRUE;
                 } else error = TRUE;
                 break;
        default: error = TRUE;   break;
    }
       
    if (error) {
	fprintf(stderr,"Usage: generator [-adegiklpst] invoer_file uitvoer_file\n");
        exit(1);
    }
    if (flags){   /* process flags */
	int i = 1;
	while( argv[1][i] != '\0' ){
	    switch( argv[1][i] ){
                case 'a' : debug_ambigu(TRUE);
			   debug_empty(TRUE);
			   debug_omitstrt(TRUE);
			   break;
		case 'd' : fpdg = stderr;       break;
                case 'e' : debug_entity(TRUE);
			   debug_doc(TRUE);
			   debug_extern(TRUE);
			   break;
                case 'g' : debug_dtd(TRUE);     break;
                case 'i' : debug_in(TRUE);      break;
                case 'k' : debug_marked(TRUE);  break;
                case 'l' : debug_lexical(TRUE); break;
		case 'p' : print_elem = TRUE;   break;
                case 's' : debug_shortref(TRUE);
			   debug_shortnot(TRUE);
			   break;
		case 't' : debug_attchk(TRUE);   break;
		default  : fprintf(stderr, "%s: illegal flag %c\n",
					    argv[0], argv[1][i]);
			   break;
	    }
	    i++;
	}
    }
    if (!fpdg and ((fpdg = fopen("debug_info1", "w")) == 0))
	report(FILE_OPEN, FATAL, 0, 0, "debug_info1");
#else
    switch (argc) {
        case 3 : input_file  = argv[1];
                 output_file = argv[2];
                 break;
        default: fprintf(stderr,"Usage: %s invoer_file uitvoer_file\n",
                                 argv[0]);
		 exit(1);
		 break;
    }
#endif

    init_conc();
    init_input(input_file, (String)0 );
    init_lexical();
    init_entity();
    init_notation();
    init_element();
    init_shortref();
    init_charclas();

    LLparse();

    capacity_points();
    clean_grammar();
    calc_empty();
    check_ambigu();
    solve_empty();
    maps_ok();
    calc_status();
    check_attributes();
    check_entity_notations();

#ifdef DEBUG
    if( print_elem ){
	print_grammar("Elements1");
	write_grammar("Elements2");
    }
#endif
    fatal_report();
    generate_tags(DOC_tags);

    fatal_report();
    map_src = fopen(DOC_mapi, "w");
    map_ext = fopen(DOC_mapext, "w");
    if( (map_src==0) or (map_ext==0) ){
	report(FILE_OPEN, FATAL, 0, 0, "DOC/map*");
    }
    generate_maps(map_src, map_ext);
    fclose(map_src);
    fclose(map_ext);

    fatal_report();
    entity_file = fopen(DOC_entity, "w");
    if( entity_file == 0 ){
	report(FILE_OPEN, FATAL, 0, 0, DOC_entity);
    }
    generate_entities(entity_file);
    fclose(entity_file);

    charclas_file = fopen(DOC_charclas, "w");
    if( charclas_file == 0 ){
	report(FILE_OPEN, FATAL, 0, 0, DOC_charclas);
    }
    generate_unused(charclas_file);
    fclose(charclas_file);


    fatal_report();
    generate_endlist(DOC_taglist);
    attrs_generate(DOC_att_pari, DOC_att_parext);

    fatal_report();
    generate(output_file);

#ifdef DEBUG
    fprintf(fpdg, "memory used %d\n", mem_used);
    fprintf(fpdg, "tot_nr_iters %6d   nr_groups %6d %6d  nr_links %6d %6d\n",
      tot_nr_iters, nr_groups, tot_nr_groups, nr_links,tot_nr_links);
    if (fpdg != stderr) fclose(fpdg);
#endif

    return(0);
  }

