/*  $Header: modes.c,v 3.0 88/04/13 16:02:46 jos Locked $ */
/*
 *  This file is part of the Amsterdam SGML Parser.
 *
 *  Copyright: Faculteit Wiskunde en Informatica
 *             Department of Mathematics and Computer Science
 *             Vrije Universiteit Amsterdam
 *             The Netherlands
 *
 *  Authors:   Sylvia van Egmond
 *             Jos Warmer
 */
#include "Lpars.h"
/*
 *  In MD mode OPT and REP are recognized.
 *  This is not correct according to the Standard (See figure 3, page 31).
 *  But it is neccesary to be able have an OPT or REP modelgroup.
 *
 *  In LIT mode PERO is recognized.
 *  This is not correct according to the Standard (See figure 3, page 31).
 *  But it is neccesary to be able have replacaeble parameter data.
 */
#include "types.h"
#include "modes.h"

static int ILL_delims[] = {TOK_NOD};
static int COM_delims[] = {TOK_COM, TOK_NOD};
static int CON_delims[] = {TOK_CRO, TOK_ETAGO, TOK_MDO_DSO, TOK_MDO,
			   TOK_MSC, TOK_PIO, TOK_NET, TOK_ERO,
			   TOK_STAGO,
			   SH_REF   , SH_REF+ 1, SH_REF+ 2,
			   SH_REF+ 3, SH_REF+ 4, SH_REF+ 5,
			   SH_REF+ 6, SH_REF+ 7, SH_REF+ 8,
			   SH_REF+ 9, SH_REF+10, SH_REF+11,
			   SH_REF+12, SH_REF+13, SH_REF+14,
			   SH_REF+15, SH_REF+16, SH_REF+17,
			   SH_REF+18, SH_REF+19, SH_REF+20,
			   SH_REF+21, SH_REF+22, SH_REF+23,
			   SH_REF+24, SH_REF+25, SH_REF+26,
			   SH_REF+27, SH_REF+28, SH_REF+29,
			   SH_REF+30, SH_REF+31,
			   TOK_NOD};
static int CXT_delims[] = {TOK_COM, TOK_DSO, TOK_MDC, TOK_TAGC,TOK_NOD};
static int DS_delims[]  = {TOK_PIO, TOK_MDO_DSO, TOK_MDO, TOK_MSC,
			   TOK_PERO, TOK_DSC, TOK_NOD};
static int GRP_delims[] = {TOK_AND, TOK_DTGC, TOK_DTGO, TOK_GRPC,
			   TOK_GRPO, TOK_LIT, TOK_LITA, TOK_OPT, 
			   TOK_OR, TOK_PERO, TOK_PLUS, TOK_REP,
			   TOK_RNI, TOK_SEQ, TOK_NOD};
static int LIT_ERO_delims[] = {TOK_CRO , TOK_ERO, TOK_LIT, TOK_NOD};
static int MD_delims[]  = {TOK_COM, TOK_DSC, TOK_DSO, TOK_GRPO,
			   TOK_LIT, TOK_LITA, TOK_MDC, TOK_MINUS,
			   TOK_PERO, TOK_PLUS, TOK_RNI, TOK_REP,
			   TOK_OPT, TOK_NOD};
static int PI_delims[]  = {TOK_PIC, TOK_NOD};
static int REF_delims[] = {TOK_REFC, TOK_NOD};
static int TAG_delims[] = {TOK_LIT, TOK_LITA, TOK_NET, TOK_ETAGO,
			   TOK_STAGO, TOK_TAGC, TOK_VI, TOK_NOD};
static int IGNORE_delims[] = {TOK_MDO_DSO, TOK_MSC, TOK_NOD};
static int RCDATA_delims[] = {TOK_ERO, TOK_CRO, TOK_ETAGO,
			      TOK_NET, TOK_NOD};
static int LITA_ERO_delims[] = {TOK_CRO , TOK_ERO, TOK_LITA, TOK_NOD};
static int CDATA_delims[] = {TOK_ETAGO, TOK_NET, TOK_NOD};
static int MARKED_CDATA_delims[] = {TOK_MSC, TOK_NOD};
static int MARKED_RCDATA_delims[] = {TOK_MSC,TOK_CRO, TOK_ERO, TOK_NOD};
static int LIT_PERO_delims[] = {TOK_CRO , TOK_LIT, TOK_PERO, TOK_NOD};
static int LITA_PERO_delims[] = {TOK_CRO , TOK_LITA, TOK_PERO, TOK_NOD};

static Delimiter *Dels[] = {ILL_delims, COM_delims, CON_delims, CXT_delims,
			    DS_delims, GRP_delims, LIT_ERO_delims, MD_delims,
			    PI_delims, REF_delims, TAG_delims, IGNORE_delims,
			    RCDATA_delims, LITA_ERO_delims, MD_delims,
			    CDATA_delims, MARKED_CDATA_delims,
			    MARKED_RCDATA_delims, LIT_PERO_delims,
			    LITA_PERO_delims, 0};

Delimiter* delimiter_mode(recognition_mode)
RecognitionMode   recognition_mode;
{
    return( Dels[ (int)recognition_mode ] );
}

Bool mode_recognizes(mode, delim)
RecognitionMode mode;
Delimiter       delim;
{
    int  i;
    int  del;
    int *delims = delimiter_mode(mode);

    for(i=0; (del = delims[i]) != TOK_NOD ; i++){
	if( del == delim ){ return TRUE; }
    }
    return FALSE;
}

/*
 *  The following procedures are for debugging purposes.
 */
String recognition_to_string(mode)
RecognitionMode mode;
{
    static String strings[] = { "ILL_MODE", "MODE_COM", "MODE_CON", "MODE_CXT",
			       "MODE_DS", "MODE_GRP", "MODE_LIT_ERO", "MODE_MD",
			       "MODE_PI" , "MODE_REF", "MODE_TAG",
			       "MODE_IGNORE", "MODE_RCDATA", "MODE_LITA_ERO",
			       "MODE_SGML", "MODE_CDATA",
			       "MODE_MARKED_CDATA", "MODE_MARKED_RCDATA",
			       "MODE_LIT_PERO", "MODE_LITA_PERO", 
			       0};
    
    return( strings[(int) mode] );
}
