/* $Header: myerror.c,v 3.1 89/03/07 08:53:33 sylvia Exp $ */
/*
 *  This file is part of the Amsterdam SGML Parser.
 *
 *  Copyright: Faculteit Wiskunde en Informatica
 *             Department of Mathematics and Computer Science
 *             Vrije Universiteit Amsterdam
 *             The Netherlands
 *
 *  Authors:   Sylvia van Egmond
 *             Jos Warmer
 */

#include "types.h"
#include "Lpars.h"
#include "elem_stk.h"
#include "in.h"
#include "incl.h"
#include "lexical.h"
#include "myerror.h"
#include "taglist.h"
#include "tags.h"

static int   tokens[3] = {0, 0, 0};
static Bool  debug     = FALSE;

#ifdef DEBUG
static void print_tokenlist(token, tokenlist)
int token, *tokenlist;
{
	fprintf(fpdg, "myerror: token = %d\ntokenlist = ", token);
	while (*tokenlist != 0) {
	    fprintf(fpdg, "%d, ", *tokenlist);
	    tokenlist++;
	}
	fprintf(fpdg, "0\n");
}
#endif

Bool poss_token(elem, token, tokenlist)
int elem, token, *tokenlist;
{
	DEB1("poss_token: elem = %d\n", elem);
	DEB1("poss_token: token = %d\n", token);
	if (token != 0) return(token == elem?TRUE:FALSE);
	while (*tokenlist != 0) {
	    if (elem == *tokenlist) return(TRUE);
	    tokenlist++;
	}
	DEB("Elem is not part of tokenlist, poss-token == false\n");
	return(FALSE);
}

void myerror(token, tokenlist)
int token, *tokenlist;
{
	extern int LLsymb;
	extern int in_starttag;

	int        top_el      = top_elem(elemstack);
	int        prev_llsymb = LLsymb;

	push_back_token();
	if (LLsymb == TOK_NONSGML ){
	    DEB("myerror: NONSGML\n");
	    return;
	}
	if (top_el == 0 ){
	    DEB("myerror: top_el == 0\n");
	    return;
	}
	if( in_starttag ){
	    DEB("myerror: in starttag\n");
	    return;
	}
	DEB1("myerror LLsymb = %d\n", LLsymb);
	DEB2("        top_el = %s (%d)\n", endtag_to_string(top_el), top_el);
#ifdef DEBUG
	if (debug) print_tokenlist(token, tokenlist);
#endif

	if (token == EOFILE) {
	    tokens[0] = EOFILE;
	    token_input("EOFILE", tokens, 0);
	    DEB("myerror push EOFILE on the input\n");
	    return;
	}
	if (poss_token(TOK_XXX, token, tokenlist)) {
	    tokens[0] = TOK_XXX;
	    tokens[1] = EOFILE;
	    token_input("EOFILE", tokens, 0);
	    DEB("myerror push TOK_XXX on the input\n");
	    tokens[1] = 0;
	    return;
	}
	if (On_stackElem(inclstack, LLsymb))
	    if (!On_stackElem(exclstack, LLsymb)) {
		while (prev_llsymb == next_token()) {
		    push_back_token();
		    DEB1("myerror element %s is an inclusion\n", starttag_to_string(LLsymb));
		    execute_func(LLsymb);
		    DEB("myerror: inclusion is ended\n");
		    if (contain_elem(top_el, PCDATA)) f_sep1();
		    else f_sep2();
		    DEB("myerror: f_sep[12] is ended\n");
		}
		push_back_token();
		return;
	    }
	    else {
		report(INCL_EXCL, NOTFATAL, 0, 0,
		       starttag_to_string(LLsymb));
		while (prev_llsymb == next_token()) {
		    push_back_token();
		    DEB1("myerror element %s is an inclusion and excl.\n", starttag_to_string(LLsymb));
		    execute_func(LLsymb);
		    if (contain_elem(top_el, PCDATA)) f_sep1();
		    else f_sep2();
		}
		push_back_token();
		return;
	    }
	if (top_el == LLsymb) return;
	if (!poss_token(top_el, token, tokenlist)) return;
	if (On_stackElem(elemstack, LLsymb)) {
	    if (!omit_endtag(top_el)) {
	        report(NOT_OMIT_END, FATAL, 0, 0, 
		       endtag_to_string(top_el));
	    }
	    DEB1("LLsymb is on stack, top_el %s is inserted\n", endtag_to_string(top_el));
	    tokens[0] = top_el;
	    token_input("ENDTAG OMIT", tokens, 0);
	}
	else
	    if (contain_elem(top_el, LLsymb) or 
		contain_data(top_el, LLsymb) or
	        !omit_endtag(top_el)) ;
	    else {
	        DEB1("LLsymb is starttag/char not in content_model, top_el %s is inserted\n", endtag_to_string(top_el));
		tokens[0] = top_el;
		token_input("ENDTAG OMIT", tokens, 0);
	    }
	DEB("myerror einde\n\n");
}

#ifdef DEBUG
void debug_myerror(b)
Bool b;
{
    debug = b;
}
#endif
