/*  $Header: node.h,v 3.0 88/04/14 09:21:01 jos Locked $ */
/*
 *  This file is part of the Amsterdam SGML Parser.
 *
 *  Copyright: Faculteit Wiskunde en Informatica
 *             Department of Mathematics and Computer Science
 *             Vrije Universiteit Amsterdam
 *             The Netherlands
 *
 *  Authors:   Sylvia van Egmond
 *             Jos Warmer
 */
/*
 *  node is the syntax tree of a grammar production.
 *
 *  node_group is a group of node-pointers.
 *  It is used when a node is of type "SEP", "AND" or "OR".
 *  Then the node_group contains all alternatives.
 *
 */

#ifndef NODE_H
#define NODE_H

#include "group.h"
#include "set.h"
#define TYPE int

extern P_Node new_node_key       (PAR  int key  RAP); /*PCDATA, ANY, CDATA */
extern P_Node new_node_gi        (PAR  String  RAP);
extern P_Node new_node_group     ();
extern void   delete_node        (PAR  P_Node  RAP);
extern void   node_add           (PAR  P_Node, P_Node  RAP);
extern void   node_set_key       (PAR  P_Node, int key  RAP);
extern void   node_set_occ       (PAR  P_Node, int occ  RAP);
extern void   node_set_group_type(PAR  P_Node, int type  RAP);
extern void   node_set_status    (PAR  P_Node, int status  RAP);
extern void   node_set_flagin    (PAR  P_Node, int  RAP);
extern void   node_set_flagout   (PAR  P_Node, int  RAP);
extern void   node_set_nullable  (PAR  P_Node, int  RAP);
extern void   node_set_firstsym  (PAR  P_Node, P_Set  RAP);
extern void   node_set_followsym (PAR  P_Node, P_Set  RAP);
extern void   node_set_busy      (PAR  P_Node, Bool   RAP);
extern void   node_set_done      (PAR  P_Node, Bool   RAP);

extern P_Group      node_group   (PAR  P_Node  RAP);
extern P_Node       node_parent  (PAR  P_Node  RAP);
extern TYPE         node_type    (PAR  P_Node  RAP);
extern String       node_gi      (PAR  P_Node  RAP);
extern int          node_key     (PAR  P_Node  RAP);
extern int          node_occ     (PAR  P_Node  RAP);
extern int          node_status  (PAR  P_Node  RAP);
extern int          node_flagin  (PAR  P_Node  RAP);
extern int          node_flagout (PAR  P_Node  RAP);
extern int          node_nullable(PAR  P_Node  RAP);
extern P_Set        node_firstsym(PAR  P_Node  RAP);
extern P_Set        node_followsym(PAR  P_Node  RAP);
extern Bool         node_busy    (PAR  P_Node  RAP);
extern Bool         node_done    (PAR  P_Node  RAP);
#ifdef DEBUG
extern void         node_print   (PAR  FILE*, P_Node  RAP);
extern void	    node_write   (PAR  FILE*, P_Node  RAP);
extern void         node_put     (PAR  FILE*, P_Node  RAP);
#endif

extern void	    node_convert_plus (PAR  P_Node  RAP);
extern void         node_traverse_post(PAR  P_Node, P_Node_func, P_Element RAP);
extern void         node_traverse_pre (PAR  P_Node, P_Node_func, P_Element RAP);

extern int          combine_occ(PAR  int occ1, int occ2  RAP);
#endif
