/*  $Header: notation.c,v 3.0 88/04/13 16:05:19 jos Exp $ */
/*
 *  This file is part of the Amsterdam SGML Parser.
 *
 *  Copyright: Faculteit Wiskunde en Informatica
 *             Department of Mathematics and Computer Science
 *             Vrije Universiteit Amsterdam
 *             The Netherlands
 *
 *  Authors:   Sylvia van Egmond
 *             Jos Warmer
 */
#include "types.h"
#include "entity.h"
#include "notation.h"

#define  HASH_TABLE      table
#define  HASH_FUNCTION   hash_string
#define  HASH_STRUCT     not_struct
#define  ELEM_KEY        String
#define  COPY_KEY(key)   strsave(key)
#define  EQUAL_KEY(k,l)  (strcmp(k,l)==0)
#define  INFO            P_Extern_id
#define  NEW_HASH_TABLE  new_not_table
#define  INSERT          not_insert
#define  LOOKUP          not_lookup

#include "hash.gen"

static table not_table;

void  init_notation()
{
    not_table = new_not_table(11);
}

int     get_notation( notation_name )
String  notation_name;
{
    P_Extern_id id;

    id = not_lookup(not_table, notation_name);
    return (id != 0);
}

void define_notation(name, identifier)
String       name;
P_Extern_id  identifier;
{
    extern int notcap, notchcap;

    notcap++;
    notchcap += strlen(extern_id_public(identifier));
#ifdef DEBUG
    fprintf(fpdg, "define notation name :`%s'\n",name);
    print_extern_id(fpdg, identifier);
#endif
    if( not get_notation(name) ){
	not_insert(not_table, name, identifier);
    } else {
	delete_extern_id(identifier);
	report(NOT_DEF_TWICE, FATAL, 0, 0, name);
    }
}
