/* $Header: sgml.g,v 3.0 88/04/13 16:40:09 jos Exp $ */
/*
 *  This file is part of the Amsterdam SGML Parser.
 *
 *  Copyright: Faculteit Wiskunde en Informatica
 *             Department of Mathematics and Computer Science
 *             Vrije Universiteit Amsterdam
 *             The Netherlands
 *
 *  Authors:   Sylvia van Egmond
 *             Jos Warmer
 */

{
#include "types.h"
#include "charclas.h"
#include "keywords.h"
#include "lexical.h"
#include "modes.h"
#include "sgmlproc.h"
}

%start LLparse, SGML_document;

SGML_document
{ Bool sgml_decl = FALSE; } :
	[ [ SGML_declaration   { sgml_decl = TRUE; } ]?
		{ fatal_report();
		  if (!sgml_decl) unused_standard();
		}
	  prolog
	] ;

SGML_declaration
{ char str[LITLEN + 1]; } :
	[ MDO_SGML		 { enter_mode(MODE_SGML); }
	  ps_plus
	    min_literal(str)	ps_plus
		{ if (strcmp(str, "ISO 8879-1986") != 0) {
		     report(BASIC_SGML, FATAL, 0, 0);
                  }
                }
	    doc_ch_set
	    capacity_set
	    concr_syntax_scope	ps_plus
	    concr_syntax
	    feature_use		ps_plus
	   appl_spec_inf	ps_star
	  TOK_MDC 	{ leave_mode(); }
	] ;

doc_ch_set :
	[ SGML_CHARSET  ps_plus  ch_set_descr ] ;

ch_set_descr :
	[ base_ch_set  ps_plus  descr_ch_set ]+ ;

base_ch_set 
{ char str[LITLEN + 1]; } :
	[ SGML_BASESET  ps_plus  min_literal(str) ] 
	;

descr_ch_set :
	[ SGML_DESCSET  ps_plus  [ch_descr  ps_plus ]+ ] ;

ch_descr
{
    char nr1[NAMELEN + 1], nr2[NAMELEN + 1], nr3[NAMELEN + 1];
    char str[LITLEN + 1];
} :
	[ number(nr1)		ps_plus
	  number(nr2)		ps_plus
	  [   number(nr3)
	    | min_literal(str)
	    | [ SGML_UNUSED
		  {  int ch;

		     for (ch=atoi(nr1); ch<(atoi(nr1)+atoi(nr2)); ch++){
			 unused_char(ch);
		     }
		  }
	      ]
	  ]
	] ;

capacity_set
{ char str[LITLEN + 1]; char nr[NAMELEN + 1]; } :
	[ SGML_CAPACITY		ps_plus
	  [ [ SGML_PUBLIC  ps_plus  min_literal(str)  ps_plus
	      { if (strcmp(str, "ISO 8879-1986//CAPACITY Reference//EN") != 0) {
		   report(BASIC_CAP_REF, FATAL, 0, 0);
		}
	      }
	    ] 
	    |
	    [ SGML_SGMLREF ps_plus
		[ name(str, NAMECASE_GENERAL)  ps_plus  number(nr)  ps_plus
		  { capacity_ok(str, nr); }
		]+
	    ]
	  ]
	] ;

concr_syntax_scope :
	[ SGML_SCOPE		ps_plus  
	  [   SGML_DOCUMENT
	    |
	    [ SGML_INSTANCE 	{ report(BASIC_SCOPE, FATAL, 0, 0); } ]
	  ]
	] ;

concr_syntax :
	[ SGML_SYNTAX		ps_plus
	  [ [ publ_concr_syntax ]
	    |
	    [ shun_ch_ident
	      ch_set_descr
	      func_ch_ident
	      naming_rules	ps_plus
	      delim_set
	      reserved_name_use
	      quantity_set
	    ]
	  ]
	] ;

publ_concr_syntax
{
    char str[LITLEN + 1];
    char nr1[NAMELEN + 1], nr2[NAMELEN + 1];
} :
	[ SGML_PUBLIC  ps_plus  min_literal(str) ps_plus
	  { if (strcmp(str, "ISO 8879-1986//SYNTAX Reference//EN") != 0) {
		 report(BASIC_SYN_SCOPE, FATAL, 0, 0);
	    }
	  }
	  [ SGML_SWITCHES  ps_plus 
				{ report(BASIC_SWITCHES, FATAL, 0, 0); }
	      [ number(nr1)  ps_plus  number(nr2)  ps_plus ]+
	  ]?
	] ;

shun_ch_ident
{ char nr[NAMELEN + 1]; } :
	[ SGML_SHUNCHAR		ps_plus
	  [  [ SGML_NONE	ps_plus
		{ report(BASIC_SHUN_DEF, FATAL, 0, 0); }  
	     ]
	     |
	     [
	       [   SGML_CONTROLS 
		 | [ number(nr)	  { report(BASIC_SHUN_CTR, FATAL, 0, 0); }
	           ]
	       ]
	       ps_plus 
	       { shun_char_empty(); }
	       [ number(nr)  ps_plus { shun_char_ok(nr); } ]*
	       { shun_char_been(); }
	     ]
	  ]
	] ;

func_ch_ident
{
    char   nr[NAMELEN + 1], nm[NAMELEN + 1];
    int    key;
    String str;
} :
	[ SGML_FUNCTION		ps_plus
	  [ SGML_RE        ps_plus  number(nr)    ps_plus
	    { if (strcmp(nr, "13") != 0) {
	       report(BASIC_FUNC, FATAL, 0, 0, "record end", "13");
	      }
	    }
	  ]
	  [ SGML_RS        ps_plus  number(nr)    ps_plus
	    { if (strcmp(nr, "10") != 0) {
		report(BASIC_FUNC, FATAL, 0, 0, "record start", "10");
	      }
	    }
	  ]
	  [ SGML_SPACE     ps_plus  number(nr)    ps_plus
	    { if (strcmp(nr, "32") != 0) {
		report(BASIC_FUNC, FATAL, 0, 0, "space", "32");
	      }
	    }
	  ]
	  [ name(nm, NAMECASE_GENERAL)  ps_plus
	    keyword(&key, &str)         ps_plus 
	    number(nr)                  ps_plus
	    { if (!check_int(key, FUNCHAR, MSICHAR, MSOCHAR, MSSCHAR,
                                  SEPCHAR, 0)) {
		 report(KEY_WRONG, FATAL, 0, 0, str,
			"SGML declaration, function ident",
			"FUNC/MSI/MSO/MSS/SEPCHAR", "SEPCHAR");
		  key = SEPCHAR;
	      }
              if ((strcmp(nm, "TAB") != 0) and (strcmp(nr, "9") != 0)) {
		report(BASIC_TAB_FUNC, FATAL, 0, 0);
	      }
	      else if (key != SEPCHAR ) {
		report(BASIC_TAB_FUNC, FATAL, 0, 0);
	      }
            }
	  ]*
	] ;

naming_rules
{ char str[LITLEN + 1], str2[LITLEN + 1]; } :
	[ SGML_NAMING		ps_plus
	  [ SGML_LCNMSTRT  ps_plus  param_literal(str)  ps_plus
	    { if (str[0] != '\0') {
		 report(BASIC_RULE, FATAL, 0, 0, "LCNMSTRT", "empty");
	      }
	    }
	  ]
	  [ SGML_UCNMSTRT  ps_plus  param_literal(str)  ps_plus
	    { if (str[0] != '\0') {
		 report(BASIC_RULE, FATAL, 0, 0, "UCNMSTRT", "empty");
	      }
	    }
	  ]
	  [ SGML_LCNMCHAR  ps_plus  param_literal(str)  ps_plus
	    { if ((strcmp(str, "-.") != 0) and (strcmp(str, ".-") != 0)) {
		 report(BASIC_RULE, FATAL, 0, 0, "LCNMCHAR", ".-");
	      }
	    }
	  ]
	  [ SGML_UCNMCHAR  ps_plus  param_literal(str2)  ps_plus
	    { if (((strcmp(str2, "-.") != 0) and (strcmp(str2, ".-") != 0)) or
		  (strcmp(str, str2) != 0)) {
		 report(BASIC_RULE, FATAL, 0, 0, "UCNMCHAR", ".-");
	      }
	    }
	  ]
	  [ SGML_NAMECASE		ps_plus
	    [ SGML_GENERAL		ps_plus
		[   SGML_YES
		  |
		  [ SGML_NO   { report(BASIC_NAME_GEN, FATAL, 0, 0); } ]
		]
		ps_plus
	    ]
	    [ SGML_ENTITY		ps_plus
		[ [ SGML_YES  { report(BASIC_NAME_ENT, FATAL, 0, 0); } ]
		  | SGML_NO
		]
	    ]
	  ]
	] ;

delim_set :
	[ SGML_DELIM  ps_plus  gen_delim_set  short_ref_delim  ] ;

gen_delim_set
{ char str[LITLEN + 1], nm[NAMELEN + 1]; } :
	[ SGML_GENERAL		ps_plus
	  [ SGML_SGMLREF		ps_plus
	    [ name(nm, NAMECASE_GENERAL)  ps_plus  param_literal(str)  ps_plus
	      { gen_delim_ok(nm, str); }
	    ]*
	  ]
	];

short_ref_delim
{ char str[LITLEN + 1]; } :
	[ SGML_SHORTREF		ps_plus
	  [ [ SGML_SGMLREF		ps_plus 
	      [ { report(BASIC_SHORT, FATAL, 0, 0); }
	        param_literal(str)  ps_plus
	      ]*
	    ]
	    |
	    [ SGML_NONE		ps_plus
	      [ param_literal(str)  ps_plus { short_delim_ok(str); } ]*
	      { short_delim_been(); }
	    ]
	  ]
	];

reserved_name_use
{ char nm1[NAMELEN + 1], nm2[NAMELEN + 1]; } :
	[ SGML_NAMES		ps_plus
	  [ SGML_SGMLREF	ps_plus
	    [ name(nm1, NAMECASE_GENERAL)  ps_plus  
	      name(nm2, NAMECASE_GENERAL)  ps_plus
	      { report(BASIC_NO, FATAL, 0, 0, "reserved names"); }
	    ]*
	  ]
	];

quantity_set
{ char nm[NAMELEN + 1]; char nr[NAMELEN + 1]; } :
	[ SGML_QUANTITY		ps_plus
	  [ SGML_SGMLREF	ps_plus
	    [ name(nm, NAMECASE_GENERAL)  ps_plus  number(nr)  ps_plus
	      { quantity_ok(nm, nr); }
	    ]*
	  ]
	] ;

feature_use :
	[ SGML_FEATURES		ps_plus
	  mark_up_feature	ps_plus
	  link_type_feature	ps_plus
	  other_feature
	] ;

mark_up_feature :
	[ SGML_MINIMIZE		ps_plus
	  [ SGML_DATATAG  ps_plus
	      [ [ SGML_YES
	          { report(BASIC_NO, FATAL, 0, 0, "datatag feature"); }
		]
	        | SGML_NO
	      ]
	      ps_plus
	  ]
	  [ SGML_OMITTAG  ps_plus
	      [   SGML_YES
	        | 
		[ SGML_NO
		  { report(BASIC_YES, FATAL, 0,0, "omittag feature"); } 
		]
	      ]
	      ps_plus
	  ]
	  [ SGML_RANK     ps_plus
	      [ [ SGML_YES
	          { report(BASIC_NO, FATAL, 0, 0, "rank feature"); }
		]
	        | SGML_NO
	      ]
	      ps_plus
	  ]
	  [ SGML_SHORTTAG ps_plus
	      [   SGML_YES
	        | 
	        [ SGML_NO
		  { report(BASIC_YES, FATAL, 0, 0, "shorttag feature"); } 
		]
	      ]
	  ]
	] ;

link_type_feature
{ char nr[NAMELEN + 1]; } :
	[ SGML_LINK			ps_plus
	  [ SGML_SIMPLE    ps_plus
	      [ [ SGML_YES
	          { report(BASIC_NO, FATAL, 0, 0, "simple link feature"); }
		]
		| SGML_NO
	      ]
	      ps_plus
	  ]
	  [ SGML_IMPLICIT  ps_plus
	      [ [ SGML_YES
	          { report(BASIC_NO, FATAL, 0, 0, "implicit link feature"); }
		]
		| SGML_NO
	      ]
	      ps_plus 
	  ]
	  [ SGML_EXPLICIT  ps_plus
	      [   SGML_NO
	        |
	        [ SGML_YES  ps_plus  number(nr)
	          { report(BASIC_NO, FATAL, 0, 0, "explicit link feature"); }
		]
	      ] 
	  ]
	] ;

other_feature
{ char nr[NAMELEN + 1]; } :
	[ SGML_OTHER			ps_plus
	  [ SGML_CONCUR  ps_plus  
	    [ SGML_NO 
	      |
	      [ SGML_YES  ps_plus  number(nr) 
	          { report(BASIC_NO, FATAL, 0, 0, "concur feature"); }
	      ]
	    ]
	    ps_plus
	  ]
	  [ SGML_SUBDOC  ps_plus  
	    [ SGML_NO
	      |
	      [ SGML_YES  ps_plus  number(nr) 
	          { report(BASIC_NO, FATAL, 0, 0, "subdoc feature"); }
	      ]
	    ]
	    ps_plus
	  ]
	  [ SGML_FORMAL  ps_plus
	    [ [ SGML_YES
	          { report(BASIC_NO, FATAL, 0, 0, "formal feature"); }
	      ]
	      | SGML_NO
	    ]
	  ]
	] ;

appl_spec_inf
{ char str[LITLEN + 1]; } :
	[ SGML_APPINFO		ps_plus
	  [   SGML_NONE 
	    | [ min_literal(str)
		 { report(BASIC_APPL_INFO, FATAL, 0, 0); }
	      ]
	  ]
	] ;
