/* $Header: taglist.c,v 3.0 88/04/13 16:32:32 jos Locked $ */
/*
 *  This file is part of the Amsterdam SGML Parser.
 *
 *  Copyright: Faculteit Wiskunde en Informatica
 *             Department of Mathematics and Computer Science
 *             Vrije Universiteit Amsterdam
 *             The Netherlands
 *
 *  Authors:   Sylvia van Egmond
 *             Jos Warmer
 */

#include "types.h"
#include "Lpars.h"
#include "taglist.h"

struct t_taglist {
	int  name;
	Bool endtag;
	int  st_cont[GRPGTCNT + 1];
};

typedef struct t_taglist ttaglist;

#include "first.c"
#include "taglist.i"

int index(name)
int name;
{
	int i = 0;

	while ((taglist[i].name != 0) and (taglist[i].name != name))
		i++;
	return(i);
}

Bool omit_endtag(name)
int name;
{
	return(taglist[index(name)].endtag);
}

Bool contain_elem(name, elem)
int name, elem;
{
	int ind = index(name), i = 0;

	if (taglist[ind].name == 0) return(FALSE);
	while ((taglist[ind].st_cont[i] != 0) and
	       (taglist[ind].st_cont[i] != elem)) i++;
	if (taglist[ind].st_cont[i] != 0) return(TRUE);
	return(FALSE);
}

Bool contain_data(name, ch)
int name, ch;
{
	if (contain_elem(name, RCDATA) and f_rcdata(ch)) return(TRUE);
	if (contain_elem(name, CDATA) and f_cdata(ch)) return(TRUE);
	if (contain_elem(name, PCDATA) and f_pcdata(ch)) return(TRUE);
	return(FALSE);
}
