#include <stdio.h>
#include <math.h>

/* #ifdef CRAY */
/* #include <sys/signal.h> */
/* #else */
/* #include <signal.h> */
/* #endif */

#include "if2.h"


void                If1Check();                           /* if1check.c       */

double                TSECND();                           /* if2timer.c       */
void            StopProfiler();
void           StartProfiler();

void               If2PPrint();                           /* if2pprint.c      */

void                If2Clean();                           /* if2clean.c       */
int            AreEdgesEqual();
PEDGE             FindSource();

void                 If1Read();                           /* if1read.c        */

void      WriteIf2memPicture(),   CountNodesAndEdges();   /* if2pic.c         */
void     WriteIf2memWarnings();

void              EnterScope(),            MakeGraph();   /* if1build.c       */
void                MakeInfo(),             MakeEdge();
void               MakeConst(),             MakeNode();
void            MakeCompound(),            ExitScope();
void                AddStamp(),          RemoveStamp();
int                  IsStamp();
void    AssignSourceFileName();
PINFO               FindInfo();

void              LinkImport(),           LinkExport();   /* if2util.c        */
void            UnlinkImport(),         UnlinkExport();
void       ChangeImportPorts(),    ChangeExportPorts();
void         LinkImportLists(),      LinkExportLists();
void           LinkNodeLists(),        ChangeToConst();
void       ChangeEdgeToConst();
PNODE           FindLastNode();
PNODE              LinkGraph();
PNODE               LinkNode();
PNODE             UnlinkNode();
PNODE            UnlinkGraph();
char             *CopyString(),             *MyAlloc();
void                Warning1(),               Error1();
void                  Error2(), ChangeExportsToConst();
PALIST        LinkAssocLists();
PEDGE              EdgeAlloc();
PNODE              NodeAlloc();
PINFO              InfoAlloc();
PALIST        AssocListAlloc();
PEDGE             FindImport();
PEDGE             FindExport();
int            AreConstEqual(),           UsageCount();
PEDGE               CopyEdge();
void              AttachEdge();
void  CopyEdgeAndThreadToUse(),          ThreadToUse();
char             *IntToAscii();

void                If2Write();                           /* if2write.c       */

void                  If2Mem(),           PushAtNode();   /* if2mem.c         */
PNODE              PopAtNode(),       ReferencePoint();
PNODE         MaxSourceInDFO(),         MaxNodeInDFO();

void      AssignLevelNumbers();                           /* if2level.c       */

void             AssignSizes();                           /* If2size.c        */

void           AllocIf2Nodes();                           /* if2alloc.c       */

void                    Stop(),                 main();   /* DRIVER FILE      */

int                   strlen();                           /* C LIBRARY STUFF  */
char                 *malloc();
char                 *strcpy();
int                     free();


#define OK       0                               /* PROGRAM EXIT STATUS CODES */
#define ERROR    1

#define FALSE    0
#define TRUE     1

extern FILE  *input;                             /* IF1 INPUT  STREAM         */
extern FILE  *output;                            /* IF1 OUTPUT STREAM         */

extern char  *program;                           /* PROGRAM NAME              */

extern char *sfile;                              /* SISAL FILE BEING READ     */
extern PNODE cfunct;                      /* FUNCTION BEING BUILT OR EXAMINED */

extern int    info;               /* DUMP OPTIMIZATION INFO TO stderr?        */
extern int    sgnok;              /* ARE SIGNED ARITHMETIC CONSTANTS ALLOWED? */
extern int    noopt;              /* ARE CSE AND CONSTANT FOLDING DESIRED?    */

extern int    maxint;                   /* MAXIMUM INTEGER READ FROM IF1 FILE */
extern PINFO  integer;                  /* INTEGER SYMBOL TABLE ENTRY         */
extern int    line;        /* LINE NUMBER OF PREVIOUSLY READ LINE OF IF1 FILE */
extern PINFO  ihead;                    /* SYMBOL TABLE HEAD POINTER          */
extern PINFO  itail;                    /* SYMBOL TABLE TAIL POINTER          */
extern PNODE  glstop;                   /* HEADER OF FUNCTION GRAPH LIST      */
extern char  *stamps[];                 /* ARRAY OF IF1 STAMPS 0 to 127       */
extern char  *cnames[];                 /* COMPOUND NODE NAMES                */
extern char  *snames[];                 /* SIMPLE NODE NAMES                  */
extern char  *atnames[];                /* IF2 AT-NODE NAMES                  */
extern char  *gnames[];                 /* GRAPH NODE NAMES                   */
extern PRAGS  pragmas;        /* PRAGMAS FORM CURRENTLY READ LINE OF IF1 FILE */

extern int   invar;                            /* GRAPH CLEANUP DISABLE FLAGS */
extern int   cse;
extern int   gcse;
extern int   fold;

extern int   minopt;                    /* ONLY PERFORM MINIMAL OPTIMIZATION? */
extern int   fover;                     /* OVERRIDE AGather FILTERS?          */
extern int   Oinvar;

extern int   paddh;                            /* COUNT OF AAddH PREFERENCES */

extern int   glue;                             /* REMOVE DEAD FUNCTION CALLS? */
extern int   prof;                             /* PROFILE THE OPTIMIZER?      */
