#include "world.h"


char *cnames[] = {                                     /* COMPOUND NODE NAMES */
    "For", "If", "TagC", "LoopA", "LoopB", "IfTE", "Iter" 
    };

char *snames[] = {                                       /* SIMPLE NODE NAMES */
    "AAddH", "AAddL", "AAdj",  "ABld",  "ACat",  "AElm",  "AFill",
    "AGath", "AEpty", "ALimH", "ALimL", "ARemH", "ARemL", "ARepl",
    "AScat", "ASetL", "ASize", "Abs",   "BindA", "Bool",  "Call",
    "Char",  "Div",   "Dbl",   "Equal", "Exp",   "FstV",  "FnlV",
    "Floor", "Int",   "IsErr", "Less",  "LessE", "Max",   "Min",
    "Minus", "Mod",   "Neg",   "NoOp",  "Not",   "NotE",  "Plus",
    "RgGen", "RBld",  "RElm",  "RRepl", "RedL",  "RedR",  "RedT",
    "Red",   "RestV", "Sngle", "Times", "Trunc", "ReplM"
    };

char *atnames[] = {                                       /* IF2 ATNODE NAMES */
    "AddLAT", "AddHAT",  "BPart",  "BldAT",  "BScat",  "CatAT",  "ElmAT",
    "AdjAT",  "FillAT",  "GathAT", "RemHAT", "RemLAT", "ReplAT", "AToB",
    "SetAT",  "DefAB",   "DefRB",  "FnlVAT", "MAlloc", "BElm",   "RBldAT",
    "RToB",   "RElmAT",  "RedAT",  "ShiftB", "SBpart", "RedLAT", "RedRAT",
    "RedTAT"
    };

char *gnames[] = {                                        /* GRAPH NODE NAMES */
    "SGrph", "LGrph", "IGrph", "XGrph"
    };


/**************************************************************************/
/* GLOBAL **************       WriteNodeName       ************************/
/**************************************************************************/
/* PURPOSE: WRITE NODE n'S SYMBOLIC NAME TO stderr.                       */
/**************************************************************************/

void WriteNodeName( n )
PNODE n;
{
    if ( IsSimple( n ) )
	fprintf( stderr, "%s", snames[ n->type -  IFAAddH   ] );
    else if ( IsGraph( n ) )
	fprintf( stderr, "%s", gnames[ n->type -  IFSGraph  ] );
    else if ( IsCompound( n ) )
	fprintf( stderr, "%s", cnames[ n->type -  IFForall  ] );
    else
	fprintf( stderr, "%s", atnames[ n->type - IFAAddLAT ] );
}
