c conduc favors vectorization  over parallelization

c Here's the vanilla version of simple in Fortran.
ccccc
c
c      This is a slightly modified version of a simple code I found
c      on crg. The most important modification is that the dtmax
c      value has been changed from the original of 0.01 to 0.1.
c      This was done so the code would not run as long.
c
c      The timing code has been reinstated using etime to get timings.
c
c      The code is sloppy Fortran and may generate warnings (or worse)
c      on some compilers. At some point we will have a cleaned up
c      version, but it may have other code changes from the original.
c
c      The only reason we are keeping this version around is to
c      check results it gives with our future versions.
c
c      Joe Garbarini, Oct-24-1989
c
ccccc


c      program simp.f(output,tape3=output)
 
      implicit real*8 (a-h,o-z)
      common /main/
     1 r(100,100),z(100,100),u(100,100),v(100,100),aj(100,100)
     2,energy(100,100),p(100,100),q(100,100),temp(100,100)
     3,rho(100,100),dtau(100,100),mass(100,100),nbc(100,100)
      real*8  mass
 
      common /worksp/
     1 w1(100,100),w2(100,100),w3(100,100),w4(100,100),w5(100,100)
     2,w6(100,100),w7(100,100)
 
      common /times/ ncycle,tnup,dtn,dtnph,dtnmh
 
      common /contrl/ tmax,dtmax,dtmin,ncp
 
      common /klspac/ kmn,lmn,kmx,lmx
 
      common /ident/ verson

      common /media/ ntty
 
 
c      verson - current version number of simple.
 
c      r      - radial coordinate (cylindrical coordinates)
c      z      - azimuthal coordinate (cylindrical coordinates)
c      u      - radial velocity
c      v      - azimuthal velocity
c      aj     - area jacobian for the zone.(zonal area)
c      energy - internal energy/gram
c      p      - pressure
c      q      - artifical viscosity (von neuman "q")
c      temp   - temperature
c      rho    - density(gm/cc)
c      dtau   - change in specific volume. (tau = 1/rho)
c      mass   - mass (per radian)
c      nbc    - boundary condition array(valid only on the boundary).
 
c      w1 thru w7 are working arrays set up for scratch storage.
c      they are never used to pass values between subroutines, or to
c      hold values between subroutine calls.
 
c      dtc - hydrodynamics delta_t contrl
c      kc  - k value at which courant condition is worst.
c      lc  - l value at which courant condition is worst.
c      wn  - integrated work done on the boundaries of the problem.
c      ske - kineti energy for the problem.
 
c      dte - heat conducion delta_t contrl
c      ken - k value at which delta_e/e is largest.
c      len - l value at which delta_e/e is largest.
c      hn  - integrated heat gained across all boundaries.
 
 
c      ncycle - cycle counter
c      tnup   - problem time(n+1)
c      dtn    - deltat (n)
c      dtnph  - deltat (n+1/2)
c      dtnmh  - deltat (n-1/2)
 
c      tmax   - maximum time
c      dtmax  - maximum allowed dt
c      dtmin  - minimum allowed dt
c      ncp    - interval in cycles between short edits
 
c      kmn  - minimum value for k
c      lmn  - minimum value for l
c      kmx  - maximum value for k
c      lmx  - maximum value for l
 
      data verson /2.0e0/
      data ntty   /1/
      data ske     /0.0e0/
      data hn      /0.0e0/
      data wn      /0.0e0/
      data tflr    /0.0001e0/
 
c CANN
c     call mttimes
c     t1 = tsecnd()

c      initialize all /main/ arrays
 
        do 10 l = 1,100
      do 10 k = 1,100
          r(k,l) = 0.0e0
          z(k,l) = 0.0e0
          u(k,l) = 0.0e0
          v(k,l) = 0.0e0
          p(k,l) = 0.0e0
          q(k,l) = 0.0e0
          aj(k,l) = 0.0e0
          rho(k,l) = 0.0e0
          nbc(k,l) = 0.0e0
          temp(k,l) = 0.0e0
          mass(k,l) = 0.0e0
          energy(k,l) = 0.0e0
   10 continue
 

c      set up eos tables
 
      call setup
 
c      get input parameters
 
      tmax=4.999e0
      kmn=2
      kmx=99
      lmn=2
      lmx=99
 
      kmnp = kmn+1
      lmnp = lmn+1
 
c***********************************************************************
c                           generate problem                           *
c***********************************************************************
 
      call gen
 
c***********************************************************************
c***********************************************************************
c                                                                      *
c                start cycle here                                      *
c                                                                      *
c***********************************************************************
c***********************************************************************
 
c CANN
c     print *, '------------'
c     print *, ncycle
c     print *, tnup
c     print *, dtnph
c     print *, 1.0e+10
c     print *, 1.0e+10
c     print *, 0
c     print *, 0
c     print *, '------------'

c     write(ntty,1410)
c     write(ntty,1411) ncycle
c     write(ntty,1412) tnup
c     write(ntty,1412) dtnph
c     write(ntty,1412) 1.0e+10
c     write(ntty,1412) 1.0e+10
c     write(ntty,1411) 0
c     write(ntty,1411) 0
c     write(ntty,1410)

  200 continue
 
      dte = 1.0e+10
      dtc = 1.0e+10
 
c***********************************************************************
c                      hydrodynamics                                   *
c***********************************************************************
 
c      calculate new pressure for this cycle
 
C cvd$ cncall
        do 212 l=lmnp,lmx
C cvd$ cncall
      do 212 k=kmnp,kmx
          p(k,l) = eos(temp(k,l) , rho(k,l) , 1)
  212 continue
 
 
      call hbdry
 
      call newrz(dtn,dtnph)
 
  230 wn = wn + hwork(dtnph)
      call newque(dtc,kc,lc)
      call pdvwor
      ske = esubk(dummy)
 
c      get temperature as function of energy and density
c      insure temperature returned is .ge. floor temperature.
 

C cvd$ cncall
        do 240 l=lmnp,lmx
C cvd$ cncall
      do 240 k=kmnp,kmx
          temp(k,l)=amax1(tempca(energy(k,l),rho(k,l),temp(k,l)), tflr)
  240 continue
 
c***********************************************************************
c                      heat conducion                                 *
c***********************************************************************
 
  310  continue
 
      call conduc(dtnph,dte,ken,len,dhn)
 
      hn = hn + dhn
 
c      calculate new internal energy
 
      eint = 0.0e0
      do 312 l=lmnp,lmx
        do 312 k=kmnp,kmx
          eint = eint + energy(k,l)*mass(k,l)
  312 continue
 
c***********************************************************************
c                      house keeping                                   *
c***********************************************************************
 
  500 continue
 
c      advance cycle counter
 
      ncycle = ncycle+1
 
c      compute new delta_t
 
      dtnmh = dtnph
      dtnph = amin1(dtc , dte , dtmax)
      dtn   = 0.5e0*(dtnph + dtnmh)
      tnup  = tnup + dtnph
      if(dtnph .ge. dtmin) go to 510
 
c         dt is below allowed minimum
 

      write(ntty,1510) ncycle,tnup,dtnph,dtmin
 1510 format(13h dtstop cycle,i6,3h t ,e12.4,4h dt ,e12.4)
      go to 900
 
c      update energies and energy balance quantities
 
  510 te = ske + eint
      cn = te  - (hn + wn)
      if(ncycle .eq. 1) cnold = cn
      dcn = cn - cnold
      cnold = cn
 
c     if(mod(ncycle,ncp) .ne. 0) go to 550
 
c      short edit every -ncp- cycles
 
c     write(ntty,1520)
c1520 format(6h cycle,4x,5htime ,7x,2hdt,10x,3hdtc,5x,8h  kc  lc,
c    x       4x,3hdte,5x,8h ken len)
c     write(ntty,1522) ncycle,tnup,dtnph,dtc,kc,lc,dte,ken,len
c1522 format(i6,3e12.4,2i4,e12.4,2i4)
c
c     write(ntty,1524)
c1524 format(4x,4hetot,8x,4hie  ,8x,4hke  ,8x,4hhn  ,8x,4hwn  ,
c    x       8x,5hcn(n),7x,3hdcn)
c     write(ntty,1526)te,eint,ske,hn,wn,cn,dcn
c1526 format(8e12.4)
 
c THIS IS NEW
c550  continue
c CANN
c     print *, '------------'
c     print *, ncycle
c     print *, tnup
c     print *, dtnph
c     print *, dtc
c     print *, dte
c     print *, ken
c     print *, len
c     print *, '------------'

c     write(ntty,1411) ncycle
c     write(ntty,1412) tnup
c     write(ntty,1412) dtnph
c     write(ntty,1412) dtc
c     write(ntty,1412) dte
c     write(ntty,1411) ken
c     write(ntty,1411) len
c     write(ntty,1410)

c CANN
c1410 format(2h xx)
c1411 format(i6)
c1412 format(e12.4)

      if(tnup .lt. tmax) go to 200
 
c      stop time reached. take final edit and quit.
 
c     write(ntty,1560) ncycle,tnup,tmax
c1560 format(12h stop tmax  ,i6,2e12.4)
 
c***********************************************************************
c                      problem complete. clean up                      *
c***********************************************************************
 
 900  continue
c CANN
c     call mttimes
c     t2 = tsecnd()-t1
c     print *, t2
 
      stop
      end
 
      subroutine conduc(dtnph,dte,ken,len,eloss)
C...TRANSLATED BY FPP 3.00Z61 03/22/91  10:06:53    
      implicit real*8 (a-h,o-z)
 
c         this routine performs the heat conducion sweep using
c      the lu decomposition algorithm with operator splitting.
c      the heat conducion delta_t (-dte-) is also computed here,
c      as well as the calculation for the heat flow across the
c      boundary (-hn-).
 
      common /main/
     1 r(100,100),z(100,100),u(100,100),v(100,100),aj(100,100)
     2,energy(100,100),p(100,100),q(100,100),temp(100,100)
     3,rho(100,100),dtau(100,100),mass(100,100),nbc(100,100)
      real*8 mass
 
      common /works/
     1 a(100,100),b(100,100),cbb(100,100),dbb(100,100)
     2,oldtem(100,100),sig(100,100),cc(100,100)
 
      common /klspac/ kmn,lmn,kmx,lmx
 
      real*8 kappa
      data tflr /0.0001E0/
 
c      electron conducion -lu decomposition-
 
      kmnp = kmn + 1
      lmnp = lmn + 1
 
c      set up material properties for all internal zones
 
      do 10 l=lmnp,lmx
        do 10 k=kmnp,kmx
          cc(k,l) = (0.0001E0*sqrt(temp(k,l))*temp(k,l)**2)/aj(k,l)
          kappa = eos(dummy,dummy,3)
          sig(k,l) = mass(k,l)*kappa/dtnph
          oldtem(k,l) = temp(k,l)
   10 continue
 
c      set up left-hand boundary to have same properties as neighbor
c      zone to the right.
 
      DO 12 L = 1, LMX - LMNP + 1
         CC(KMN,LMNP+L-1) = CC(KMN+1,LMNP+L-1)
         CC(KMX+1,LMNP+L-1) = CC(KMX,LMNP+L-1)
   12 CONTINUE
 
c      set up bottom boundary to have same properties as neighbor
c      zone above it.
 
      DO 16 K = 1, KMX - KMNP + 1
         CC(KMNP+K-1,LMN) = CC(KMNP+K-1,LMN+1)
         CC(KMNP+K-1,LMX+1) = CC(KMNP+K-1,LMX)
   16 CONTINUE

      do 20 l=lmnp,lmx
        do 20 k=kmn,kmx
          dbb(k,l) = (2.0E0*cc(k+1,l)*cc(k,l))/(cc(k+1,l)+cc(k,l))
     1     * ( 0.5E0*(r(k,l-1)+r(k,l))*((r(k,l)-r(k,l-1))**2
     2        +(z(k,l)-z(k,l-1))**2) )
   20 continue
 
c      coupling constants in the l-direction
 
      do 30 k=kmnp,kmx
        do 30 l=lmn,lmx
          cbb(k,l) = (2.0E0*cc(k,l)*cc(k,l+1))/(cc(k,l)+cc(k,l+1))
     1     * ( 0.5E0*(r(k-1,l)+r(k,l))*((r(k,l)-r(k-1,l))**2
     2        +(z(k,l)-z(k-1,l))**2) )
   30 continue
 
c      boundary conditions at kmin = source ( left-hand boundary).
c      boundary conditions at kmax = source (right-hand boundary).
 
      do 40 l=lmn,lmx
        a(kmn,l) = 0.0E0
        b(kmn,l) = temp(kmn,l)
   40 continue
 
c      boundary conditions at lmin = mirror (lower boundary).
c      boundary conditions at lmax = mirror (upper boundary).
 
      do 50 k=kmn,kmx
        a(k,lmn) = 0.0E0
        b(k,lmn) = temp(k,lmn)
        cbb(k,lmn) = 0.0E0
        cbb(k,lmx) = 0.0E0
   50 continue
 
c           alpha,beta forward sweep (l direction)
 
      DO 100 L = 1, LMX - LMNP + 1
         DO 101 K = 1, KMX - KMNP + 1
            DENOM = SIG(KMNP+K-1,LMNP+L-1) + CBB(KMNP+K-1,LMNP+L-1) + 
     1         CBB(KMNP+K-1,LMNP-2+L)*(1.0E0-A(KMNP+K-1,LMNP-2+L))
            A(KMNP+K-1,LMNP+L-1) = CBB(KMNP+K-1,LMNP+L-1)/DENOM
            B(KMNP+K-1,LMNP+L-1) = (SIG(KMNP+K-1,LMNP+L-1)*TEMP(KMNP+K-1
     1         ,LMNP+L-1)+CBB(KMNP+K-1,LMNP-2+L)*B(KMNP+K-1,LMNP-2+L))/
     2         DENOM
  101 CONTINUE
  100 CONTINUE
 
c          back substitution sweep
 
         ML = LMX + 1
      DO 103 L = 1, LMX - LMNP + 1
         DO 104 K = 1, KMX - KMNP + 1
            TEMP(KMNP+K-1,ML-L) = A(KMNP+K-1,ML-L)*TEMP(KMNP+K-1,ML+1-L)
     1          + B(KMNP+K-1,ML-L)
  104    CONTINUE
  103 CONTINUE
 
c           alpha,beta forward sweep (k direction)
 
      DO 200 K = 1, KMX - KMNP + 1
         DO 201 L = 1, LMX - LMNP + 1
            DENOM = SIG(KMNP+K-1,LMNP+L-1) + DBB(KMNP+K-1,LMNP+L-1) + 
     1         DBB(KMNP-2+K,LMNP+L-1)*(1.0E0-A(KMNP-2+K,LMNP+L-1))
            A(KMNP+K-1,LMNP+L-1) = DBB(KMNP+K-1,LMNP+L-1)/DENOM
            B(KMNP+K-1,LMNP+L-1) = (SIG(KMNP+K-1,LMNP+L-1)*TEMP(KMNP+K-1
     1         ,LMNP+L-1)+DBB(KMNP-2+K,LMNP+L-1)*B(KMNP-2+K,LMNP+L-1))/
     2         DENOM
  201    CONTINUE
  200 CONTINUE
 
c          back substitution sweep
 
         ML = KMX + 1
      DO 203 K = 1, KMX - KMNP + 1
         DO 204 L = 1, LMX - LMNP + 1
            TEMP(ML-K,LMNP+L-1) = A(ML-K,LMNP+L-1)*TEMP(ML+1-K,LMNP+L-1)
     1          + B(ML-K,LMNP+L-1)
  204    CONTINUE
  203 CONTINUE
 
c      compute dt contrl for heat conducion
c      compute new zonal energies after heat conducion
 
      ye  = -1.0E0
cvd$ cncall
      do 300 l=lmnp,lmx
cvd$ cncall
        do 300 k=kmnp,kmx
          energy(k,l) = eos(temp(k,l) , rho(k,l) , 2)
          temp(k,l) = amax1(temp(k,l) , tflr)
          tempr = abs((temp(k,l)-oldtem(k,l))/oldtem(k,l))
          if(tempr .le. ye) go to 300
            ye = tempr
c           ke = k
c           le = l
  300 continue
      if(ye .ne. 0.0E0) dte = (0.1E0*dtnph)/ye
c     ken = ke
c     len = le
 
c      calculate energy flow across boundaries this time step.
 
      sum = 0.0E0
      DO 500 K = 1, KMX - KMN + 1
         SUM = SUM + (CBB(KMN+K-1,LMN)*(TEMP(KMN+K-1,LMN)-TEMP(KMN+K-1,
     1      LMN+1))+CBB(KMN+K-1,LMX)*(TEMP(KMN+K-1,LMX+1)-TEMP(KMN+K-1,
     2      LMX)))
  500 CONTINUE
 
      DO 510 L = 1, LMX - LMN + 1
         SUM = SUM + (DBB(KMN,LMN+L-1)*(TEMP(KMN,LMN+L-1)-TEMP(KMN+1,LMN
     1      +L-1))+DBB(KMX,LMN+L-1)*(TEMP(KMX+1,LMN+L-1)-TEMP(KMX,LMN+L-
     2      1)))
  510 CONTINUE
      eloss = sum*dtnph
 
      return
      end

      function esubk(dummy)
      implicit real*8 (a-h,o-z)
 
c        this procedure sums the kineti energy of all the zones
c      in the problem.
 
 
      common /main/
     1 r(100,100),z(100,100),u(100,100),v(100,100),aj(100,100)
     2,energy(100,100),p(100,100),q(100,100),temp(100,100)
     3,rho(100,100),dtau(100,100),mass(100,100),nbc(100,100)
      real*8  mass
 
      common /worksp/
     1 w1(100,100),w2(100,100),w3(100,100),w4(100,100),w5(100,100)
     2,w6(100,100),w7(100,100)
 
      common /klspac/ kmn,lmn,kmx,lmx
 
      real*8  kineti
 
c          kineti energy for the whole problem
 
      do 200 l=lmn,lmx
        do 200 k=kmn,kmx
          w1(k,l) = u(k,l)**2+v(k,l)**2
  200 continue
 
      kineti = 0.0e0
      kmnp = kmn + 1
      lmnp = lmn + 1
      do 210 l=lmnp,lmx
        do 210 k=kmnp,kmx
          kineti = kineti+mass(k,l)*(w1(k,l)+w1(k-1,l)+
     1                         w1(k,l-1)+w1(k-1,l-1))
  210 continue
      esubk = kineti/8.0e0
 
      return
      end
 
 
      subroutine gen
      implicit real*8 (a-h,o-z)
 
c       this routine generates the initial problem to be run
 
      common /main/
     x       r(100,100),z(100,100),u(100,100),v(100,100),aj(100,100)
     x       ,energy(100,100),p(100,100),q(100,100),temp(100,100)
     x       ,rho(100,100),dtau(100,100),mass(100,100),nbc(100,100)
      real*8  mass
 
      common /klspac/ kmn,lmn,kmx,lmx
 
      common /contrl/ tmax,dtmax,dtmin,ncp
 
      common /times/ ncycle,tnup,dtn,dtnph,dtnmh
 
      common /bdryco/ pb(3),pbb(3),qb(3)
 
      data p1d6 /0.166666666666667e0/
      data pi   /3.1415926535898e0/
 
c      set parameters for test problem
 
c                               hydro boundary condition sentinels
c                               a pressure profile of 6.0 is placed
c                               at the right hand boundary (k=kmx).
      nbcu = 1
      nbcr = 2
      nbcl = 1
      nbcd = 1
      pb(1) = 1.0e0
      pb(2) = 0.0e0
      pb(3) = 0.0e0
      qb(1) = 1.0e0
      qb(2) = 0.0e0
      qb(3) = 0.0e0
      pbb(1) = 0.0e0
      pbb(2) = 6.0e0
      pbb(3) = 0.0e0
c                               initial temperature and density
      rhozer = 1.4e0
      tzero   = 0.0001e0
c                               initial delta_t's and start time.
c     0.01 takes too long on a Sun 3/60. -jpg
corg      dtmax = 0.01e0          
      dtmax = 0.1e0
      dtmin = 0.0001e0
      dtnph = 0.01e0
      dtnmh = dtnph
      dtn   = dtnph
      tnup  = 0.0e0
      ncp   = 10
 
c      generate the coordinates r and z
c      this algorithm generates a spherical shell between -pi/2
c      and pi/2 with inner radius of 10 cm.
 
      rp = lmx-lmn
      do 100 k = kmn,kmx
        z1 = 10 + (k-kmn)
        do 102 l = lmn,lmx
          zz = (-.5e0+dble(l-lmn)/rp)*pi
          r(k,l) = z1*cos(zz)
          z(k,l) = z1*sin(zz)
  102   continue
  100 continue
 
c      generate nbc arrays of hydro boundary condition sentinels
c      counter-clockwise around the problem.
 
c      set bottom boundary conditions
 
      kmxz = kmx - 1
      do 110 k=kmn,kmxz
        nbc(k,lmn) = nbcd
  110 continue
 
c      set top boundary conditions
 
      kmnp = kmn + 1
      do 112 k=kmnp,kmx
        nbc(k,lmx) = nbcu
  112 continue
 
c      set left boundary conditions
 
      lmnp = lmn + 1
      do 114 l=lmnp,lmx
        nbc(kmn,l) = nbcl
  114 continue
 
c      set right boundary conditions
 
      lmxz = lmx - 1
      do 116 l=lmn,lmxz
        nbc(kmx,l) = nbcr
  116 continue
 
c      generate zone quantities rho, p, energy.
c      compute area, volume and mass of zone.
c       volume = volume/2pi (cm**3/radian)
c         mass =   mass/2pi (gm/radian)
 
c      calculate ezero and pzero from tzero,rhozer (eos look-up)
 
      pzero = eos(tzero,rhozer,1)
      ezero = eos(tzero,rhozer,2)
 
      do 200 l=lmnp,lmx
        do 202 k=kmnp,kmx
          p(k,l) = pzero
          rho(k,l) = rhozer
          temp(k,l) = tzero
          energy(k,l) = ezero
c                                                   compute jacobian
          aj1 = r(k,l)*(z(k-1,l)-z(k,l-1))
     1        + r(k-1,l)*(z(k,l-1)-z(k,l))
     2        + r(k,l-1)*(z(k,l)-z(k-1,l))
          aj3 = r(k-1,l)*(z(k-1,l-1)-z(k,l-1))
     1        + r(k-1,l-1)*(z(k,l-1)-z(k-1,l))
     2        + r(k,l-1)*(z(k-1,l)-z(k-1,l-1))
          aj(k,l) = 0.5e0*(aj1+aj3)
          vol = p1d6*((r(k,l)+r(k-1,l)+r(k,l-1))*aj1 +
     1                    (r(k,l-1)+r(k-1,l)+r(k-1,l-1))*aj3)
          mass(k,l) = vol*rho(k,l)
  202   continue
  200 continue
 
      return
      end
 
 
      subroutine hbdry
      implicit real*8 (a-h,o-z)
 
c      this routine does the geometry calculation for boundary zones
c      for the hydrodynamics pass, as well as inserting the profile
c      values in the appropriate boundary zones.
 
 
      common /main/
     x       r(100,100),z(100,100),u(100,100),v(100,100),aj(100,100)
     x       ,energy(100,100),p(100,100),q(100,100),temp(100,100)
     x       ,rho(100,100),dtau(100,100),mass(100,100),nbc(100,100)
      real*8  mass
 
      common /bdryco/ pb(3),pbb(3),qb(3)
 
      common /klspac/ kmn,lmn,kmx,lmx
 
 
c      set up bottom side boundary zones
 
c       p(k,l+1)
c       0(k,l)    1(k+1,l)
c       r(k,l-1)
 
      kmxz = kmx - 1
      do 200 k=kmn,kmxz
        call projct( r(k,lmn),z(k,lmn),
     1               r(k+1,lmn),z(k+1,lmn),
     2               r(k,lmn+1),z(k,lmn+1),
     3               r(k,lmn-1),z(k,lmn-1) )
  200 continue
 
c      set up bottom right corner
 
c                p(k,l+1)
c      1(k-1,l)  0(k,l)
c                r(k,l-1)
 
      call projct( r(kmx,lmn),z(kmx,lmn),
     1             r(kmx-1,lmn),z(kmx-1,lmn),
     2             r(kmx,lmn+1),z(kmx,lmn+1),
     3             r(kmx,lmn-1),z(kmx,lmn-1) )
 
c      set up top side boundary zones
 
c      r(k,l+1)
c      0(k,l)    1(k+1,l)
c      p(k,l-1)
 
      do 210 k=kmn,kmxz
        call projct( r(k,lmx),z(k,lmx),
     1               r(k+1,lmx),z(k+1,lmx),
     2               r(k,lmx-1),z(k,lmx-1),
     3               r(k,lmx+1),z(k,lmx+1) )
  210 continue
 
c      set up top right corner
 
c                r(k,l+1)
c      1(k-1,l)  0(k,l)
c                p(k,l-1)
 
      call projct( r(kmx,lmx),z(kmx,lmx),
     1             r(kmx-1,lmx),z(kmx-1,lmx),
     2             r(kmx,lmx-1),z(kmx,lmx-1),
     3             r(kmx,lmx+1),z(kmx,lmx+1) )
 
c      set up left side boundary zones
 
c                1(k,l+1)
c      r(k-1,l)  0(k,l)    p(k+1,l)
 
      lmxz = lmx - 1
      do 220 l=lmn,lmxz
        call projct( r(kmn,l),z(kmn,l),
     1               r(kmn,l+1),z(kmn,l+1),
     2               r(kmn+1,l),z(kmn+1,l),
     3               r(kmn-1,l),z(kmn-1,l) )
  220 continue
 
c      set up top left corner
 
c      r(k-1,l)  0(k,l)    p(k+1,l)
c                1(k,l-1)
 
      call projct( r(kmn,lmx),z(kmn,lmx),
     1             r(kmn,lmx-1),z(kmn,lmx-1),
     2             r(kmn+1,lmx),z(kmn+1,lmx),
     3             r(kmn-1,lmx),z(kmn-1,lmx) )
 
c      set up right side boundary zones
 
c                1(k,l+1)
c      p(k-1,l)  0(k,l)    r(k+1,l)
 
      do 230 l=lmn,lmxz
        call projct( r(kmx,l),z(kmx,l),
     1               r(kmx,l+1),z(kmx,l+1),
     2               r(kmx-1,l),z(kmx-1,l),
     3               r(kmx+1,l),z(kmx+1,l) )
  230 continue
 
c      set up top right corner
 
c      p(k-1,l)  0(k,l)    r(k+1,l)
c                1(k,l-1)
 
      call projct( r(kmx,lmx),z(kmx,lmx),
     1             r(kmx,lmx-1),z(kmx,lmx-1),
     2             r(kmx-1,lmx),z(kmx-1,lmx),
     3             r(kmx+1,lmx),z(kmx+1,lmx) )
 
c      the corner boundaries must be carefully set up to maintain
c      symmetry. for the spherical shell, the bottom and top right
c      corners are special.
 
c      set up top right corner (kmx+1,lmn-1)
 
c              r(k+1,l+1)
c      0(k,l)  1(k+1,l)
c              p(k+1,l-1)
 
      call projct( r(kmx,lmx),z(kmx,lmx),
     1             r(kmx+1,lmx),z(kmx+1,lmx),
     2             r(kmx+1,lmx-1),z(kmx+1,lmx-1),
     3             r(kmx+1,lmx+1),z(kmx+1,lmx+1) )
 
c      set up bottom right corner (kmx+1,lmn-1)
 
c              p(k+1,l+1)
c      0(k,l)  1(k+1,l)
c              r(k+1,l-1)
 
      call projct( r(kmx,lmn),z(kmx,lmn),
     1             r(kmx+1,lmn),z(kmx+1,lmn),
     2             r(kmx+1,lmn+1),z(kmx+1,lmn+1),
     3             r(kmx+1,lmn-1),z(kmx+1,lmn-1) )
 
c      set up bottom left corner (kmn-1,lmn-1)
 
c                  0(k,l)
c      r(k-1,l-1)  1(k,l-1)  p(k+1,l-1)
 
      call projct( r(kmn,lmn),z(kmn,lmn),
     1             r(kmn,lmn-1),z(kmn,lmn-1),
     2             r(kmn+1,lmn-1),z(kmn+1,lmn-1),
     3             r(kmn-1,lmn-1),z(kmn-1,lmn-1) )
 
c      set up top left corner (kmn-1,lmx+1)
 
c      r(k-1,l+1)
c      1(k-1,l)    0(k,l)
c      p(k-1,l-1)
 
      call projct( r(kmn,lmx),z(kmn,lmx),
     1             r(kmn-1,lmx),z(kmn-1,lmx),
     2             r(kmn-1,lmx-1),z(kmn-1,lmx-1),
     3             r(kmn-1,lmx+1),z(kmn-1,lmx+1) )
 
c      set up boundary zone attributes
 
c         the nbc array refers to the interface which is in a
c      counter-clockwise direction from the (k,l), point around the
c      problem. e.g. nbc(kmx,lmx) refers to the interface from
c      (kmx-1,lmx) to (kmx,lmx).
 
c      set up bottom side boundary zones
 
c      (k,l) = (k,l+1)
c      nbc(k-1,lmn) refers to the (k-1,lmn) to (k,lmn) interface.
 
      kmnp = kmn + 1
      do 300 k=kmnp,kmx
        rho(k,lmn) = rho(k,lmn+1)
        aj(k,lmn)  = aj(k,lmn+1)
        ip = nbc(k-1,lmn)
        q(k,lmn) = qb(ip)*q(k,lmn+1)
        p(k,lmn) = pbb(ip)+pb(ip)*p(k,lmn+1)
  300 continue
 
c      set up right side boundary zones
 
c      (k+1,l) = (k,l)
c      nbc(kmx,l-1) refers to the (kmx,l-1) to (kmx,l) interface.
 
      lmnp = lmn + 1
      do 310 l=lmnp,lmx
        rho(kmx+1,l) = rho(kmx,l)
        aj(kmx+1,l)  = aj(kmx,l)
        ip = nbc(kmx,l-1)
        q(kmx+1,l) = qb(ip)*q(kmx,l)
        p(kmx+1,l) = pbb(ip)+pb(ip)*p(kmx,l)
  310 continue
 
c      set up top side boundary zones
 
c      (k,l+1) = (k,l)
c      nbc(k,lmx) refers to the (k-1,lmx) to (k,lmx) interface.
 
      do 320 k=kmnp,kmx
        rho(k,lmx+1) = rho(k,lmx)
        aj(k,lmx+1)  = aj(k,lmx)
        ip = nbc(k,lmx)
        q(k,lmx+1) = qb(ip)*q(k,lmx)
        p(k,lmx+1) = pbb(ip)+pb(ip)*p(k,lmx)
  320 continue
 
c      set up left side boundary zones
 
c      (k,l) = (k+1,l)
c      nbc(kmn,l) refers to the (kmn,l-1) to (kmn,l) interface.
 
      do 330 l=lmnp,lmx
        rho(kmn,l) = rho(kmn+1,l)
        aj(kmn,l)  = aj(kmn+1,l)
        ip = nbc(kmn,l)
        q(kmn,l) = qb(ip)*q(kmn+1,l)
        p(kmn,l) = pbb(ip)+pb(ip)*p(kmn+1,l)
  330 continue
 
c      the corner boundaries must be carefully set up to maintain
c      symmetry. for the spherical shell, the bottom and top right
c      corners are special.
 
c      set up bottom left corner
 
      p(kmn,lmn)   = p(kmn+1,lmn)
      q(kmn,lmn)   = q(kmn+1,lmn)
      aj(kmn,lmn)  = aj(kmn+1,lmn)
      rho(kmn,lmn) = rho(kmn+1,lmn)
 
c      set up bottom right corner
 
      p(kmx+1,lmn)   = p(kmx+1,lmn+1)
      q(kmx+1,lmn)   = q(kmx+1,lmn+1)
      aj(kmx+1,lmn)  = aj(kmx+1,lmn+1)
      rho(kmx+1,lmn) = rho(kmx+1,lmn+1)
 
c      set up top right corner
 
      p(kmx+1,lmx+1)   = p(kmx+1,lmx)
      q(kmx+1,lmx+1)   = q(kmx+1,lmx)
      aj(kmx+1,lmx+1)  = aj(kmx+1,lmx)
      rho(kmx+1,lmx+1) = rho(kmx+1,lmx)
 
c      set up top left corner
 
      p(kmn,lmx+1)   = p(kmn+1,lmx+1)
      q(kmn,lmx+1)   = q(kmn+1,lmx+1)
      aj(kmn,lmx+1)  = aj(kmn+1,lmx+1)
      rho(kmn,lmx+1) = rho(kmn+1,lmx+1)
 
      return
      end
 
 
      function hwork(dtnph)
      implicit real*8 (a-h,o-z)
 
c         this routine calculates the work done on the boundary
c      by the hydrodynamics.
 
      common /main/
     1 r(100,100),z(100,100),u(100,100),v(100,100),aj(100,100)
     2,energy(100,100),p(100,100),q(100,100),temp(100,100)
     3,rho(100,100),dtau(100,100),mass(100,100),nbc(100,100)
      real*8  mass
 
      common /klspac/ kmn,lmn,kmx,lmx
 
c      sum the hydro work done on the boundary this time step
 
      sum = 0.0e0
 
      kmnp = kmn + 1
      do 100 k=kmnp,kmx
        sum = sum + (p(k,lmn+1)+p(k,lmn)+q(k,lmn+1)+q(k,lmn))
     x             *( (u(k,lmn)+u(k-1,lmn))*(z(k,lmn)-z(k-1,lmn))
     x               -(v(k,lmn)+v(k-1,lmn))*(r(k,lmn)-r(k-1,lmn))
     x              )*(r(k,lmn)+r(k-1,lmn))
        sum = sum - (p(k,lmx+1)+p(k,lmx)+q(k,lmx+1)+q(k,lmx))
     x             *( (u(k,lmx)+u(k-1,lmx))*(z(k,lmx)-z(k-1,lmx))
     x               -(v(k,lmx)+v(k-1,lmx))*(r(k,lmx)-r(k-1,lmx))
     x              )*(r(k,lmx)+r(k-1,lmx))
  100 continue
 
      lmnp = lmn + 1
      do 110 l=lmnp,lmx
        sum=sum + (p(kmn+1,l)+p(kmn,l)+q(kmn+1,l)+q(kmn,l))
     x           *( (u(kmn,l)+u(kmn,l-1))*(z(kmn,l)-z(kmn,l-1))
     x             -(v(kmn,l)+v(kmn,l-1))*(r(kmn,l)-r(kmn,l-1))
     x            )*(r(kmn,l)+r(kmn,l-1))
        sum=sum - (p(kmx+1,l)+p(kmx,l)+q(kmx+1,l)+q(kmx,l))
     x           *( (u(kmx,l)+u(kmx,l-1))*(z(kmx,l)-z(kmx,l-1))
     x             -(v(kmx,l)+v(kmx,l-1))*(r(kmx,l)-r(kmx,l-1))
     x            )*(r(kmx,l)+r(kmx,l-1))
  110 continue
 
      hwork = sum*dtnph/8.0e0
 
      return
      end
 
 
      function eos(theta,rho,which)
      implicit real*8 (a-h,o-z)
      common /eoscom/ ntsv(2),nrsv(2),msv(2),ntm1sv(2),tes(7),res(9)
     x ,aes(12),bes(12),ces(12),des(12),ees(12),fes(12),ges(12)
     x ,hes(12),pes(12),ites(3),ires(3),izes(3)
      integer which
      if(which.eq.3) go to 300
      nt=ntsv(which)
      nr=nrsv(which)
      m=msv(which)
      ntm1=ntm1sv(which)
      if(theta.ge.tes(nt+1)) go to 50000
      if(theta.lt.tes(nt)) go to 50001
      if(rho.ge.res(nr+1)) go to 50002
      if(rho.lt.res(nr)) go to 50003
60000 go to (100,200,300 ) , which
  100 continue
      eos = aes(m)+rho*(bes(m)+rho*des(m))+theta*(ces(m)+rho*
     1(fes(m)+rho*ges(m))+theta*(ees(m)+rho*(hes(m)+rho*pes(m))))
      return
  200 continue
      eos = aes(m)+rho*(bes(m)+rho*des(m))+theta*(ces(m)+rho*
     1(fes(m)+rho*ges(m))+theta*(ees(m)+rho*(hes(m)+rho*pes(m))))
      return
  300 eos = 0.1e0
      return
50000 nt=nt+1
      m=m+1
      if(theta.ge.tes(nt)) go to 50000
      nt=nt-1
      m=m-1
50012 if(rho.ge.res(nr+1)) go to 50002
      if(rho.lt.res(nr)) go to 50003
      go to 50004
50001 nt=nt-1
      m=m-1
      if(theta.lt.tes(nt)) go to 50001
      go to 50012
50002 nr=nr+1
      m=m+ntm1
      if(rho.ge.res(nr)) go to 50002
      nr=nr-1
      m=m-ntm1
      go to 50004
50003 nr=nr-1
      m=m-ntm1
      if(rho.lt.res(nr)) go to 50003
50004 continue
      go to 60000
      end
 
 
      subroutine newque(dtc,kc,lc)
      implicit real*8 (a-h,o-z)
 
c        this routine calculates the von neuman "q" and the courant
c      delta_t for each zone.
 
      common /main/
     1 r(100,100),z(100,100),u(100,100),v(100,100),aj(100,100)
     2,energy(100,100),p(100,100),q(100,100),temp(100,100)
     3,rho(100,100),dtau(100,100),mass(100,100),nbc(100,100)
      real*8  mass
 
      common /klspac/ kmn,lmn,kmx,lmx
 
      data c0f /0.375e0/
      data c1f /0.25e0 /
 
      dtc2 = 1.0e12
      kmnp = kmn + 1
      lmnp = lmn + 1
      do 100 k=kmnp,kmx
        do 110 l=lmnp,lmx
          q(k,l) = 0.0e0
          if(p(k,l) .eq. 0.0e0) go to 110
 
c           drk = 2dr/dk
c           drl = 2dr/dl
 
            drk = r(k,l)-r(k-1,l-1)+r(k,l-1)-r(k-1,l)
            drl = r(k,l)-r(k-1,l-1)+r(k-1,l)-r(k,l-1)
            dzk = z(k,l)-z(k-1,l-1)+z(k,l-1)-z(k-1,l)
            dzl = z(k,l)-z(k-1,l-1)+z(k-1,l)-z(k,l-1)
            duk = u(k,l)-u(k-1,l-1)+u(k,l-1)-u(k-1,l)
            dul = u(k,l)-u(k-1,l-1)+u(k-1,l)-u(k,l-1)
            dwk = v(k,l)-v(k-1,l-1)+v(k,l-1)-v(k-1,l)
            dwl = v(k,l)-v(k-1,l-1)+v(k-1,l)-v(k,l-1)
            w1 =  drk*dwl-dzk*dul
            w2 =  duk*dzl-dwk*drl
            w3 = 0.0e0
            w4 = 0.0e0
            if(w1 .lt. 0.0e0) w3 = w1**2/(drk**2+dzk**2)
            if(w2 .lt. 0.0e0) w4 = w2**2/(drl**2+dzl**2)
            if((w3+w4) .eq. 0.0e0) go to 110
 
c         compute sound speed of a gamma-law gas
c      sound speed = sroot(gamma*pressure/density)
c      gamma(ideal gas) = 1.0e0 + pressure/(energy*density)
c      ergo : sound speed = sroot((p/rho)*(1+(p/rho)/e))
 
              cs2 = (p(k,l)/rho(k,l)) *
     1              (1.0e0 + (p(k,l)/rho(k,l))/energy(k,l))
              cs  = sqrt(cs2)
 
c              von neuman "q" + scalar "q"
 
              q(k,l) = c0f*rho(k,l)*(w3+w4)
     1               + c1f*cs*rho(k,l)*sqrt(w3+w4)
 
c              courant condition
 
              ts0 = (aj(k,l)**2)/(cs2*(drk**2+drl**2+dzk**2+dzl**2))
              if(dtc2 .le. ts0) go to 110
                dtc2 = ts0
c               kc2 = k
c               lc2 = l
  110   continue
  100 continue
 
c          courant delta_t
 
      dtc=sqrt(dtc2)
c     kc = kc2
c     lc = lc2
 
      return
      end
 
 
      subroutine newrz(dtn,dtnph)
      implicit real*8 (a-h,o-z)
 
c        this routine calculates the new velocities, coordinates,
c      and the density and change in specific volume for each zone.
 
      common /main/
     1 r(100,100),z(100,100),u(100,100),v(100,100),aj(100,100)
     2,energy(100,100),p(100,100),q(100,100),temp(100,100)
     3,rho(100,100),dtau(100,100),mass(100,100),nbc(100,100)
      real*8  mass
 
      common /klspac/ kmn,lmn,kmx,lmx
 
      data p1d6 /0.166666666666667e0/
      data vcut /1.0e-10/
 
c      compute acceleration and new velocities
 
      do 100 l=lmn,lmx
        do 110 k=kmn,kmx
          au = (p(k,l)+q(k,l)) * (z(k,l-1)-z(k-1,l)) +
     1       (p(k+1,l)+q(k+1,l))*(z(k+1,l)-z(k,l-1)) +
     2       (p(k,l+1)+q(k,l+1))*(z(k-1,l)-z(k,l+1)) +
     3       (p(k+1,l+1)+q(k+1,l+1))*(z(k,l+1)-z(k+1,l))
          aw = (p(k,l)+q(k,l)) * (r(k,l-1)-r(k-1,l)) +
     1       (p(k+1,l)+q(k+1,l)) * (r(k+1,l)-r(k,l-1)) +
     2       (p(k,l+1)+q(k,l+1)) * (r(k-1,l)-r(k,l+1)) +
     3       (p(k+1,l+1)+q(k+1,l+1)) * (r(k,l+1)-r(k+1,l))
          auw = rho(k,l)*aj(k,l)+rho(k+1,l)*aj(k+1,l)
     1       +rho(k,l+1)*aj(k,l+1)+rho(k+1,l+1)*aj(k+1,l+1)
          auw = 2.0e0/auw
          au  = -au*auw
          aw  =  aw*auw
          u(k,l) = u(k,l)+dtn*au
          v(k,l) = v(k,l)+dtn*aw
          if(abs(u(k,l)) .le. vcut) u(k,l) = 0.0e0
          if(abs(v(k,l)) .le. vcut) v(k,l) = 0.0e0
  110   continue
  100 continue
 
c      advance coordinates to time (n+1)
 
      do 200 l=lmn,lmx
        do 210 k=kmn,kmx
          r(k,l) = r(k,l)+dtnph*u(k,l)
          z(k,l) = z(k,l)+dtnph*v(k,l)
  210   continue
  200 continue
 
c     jacobian area in (r,z) plane
c     volume = volume/2pi (cm**3/radian)
c       mass =   mass/2pi (gm/radian)
 
      kmnp = kmn + 1
      lmnp = lmn + 1
      do 300 l=lmnp,lmx
        do 310 k=kmnp,kmx
          aj1 = r(k,l)* (z(k-1,l)-z(k,l-1))
     x        + r(k-1,l)* (z(k,l-1)-z(k,l))
     x        + r(k,l-1)*(z(k,l)-z(k-1,l))
          aj3 = r(k-1,l)*(z(k-1,l-1)-z(k,l-1))
     x        + r(k-1,l-1)*(z(k,l-1)-z(k-1,l))
     x        + r(k,l-1)*(z(k-1,l)-z(k-1,l-1))
          aj(k,l) = 0.5e0*(aj1+aj3)
          vol = p1d6*((r(k,l)+r(k-1,l)+r(k,l-1))*aj1 +
     1                (r(k-1,l)+r(k-1,l-1)+r(k,l-1))*aj3 )
          vn = 1.0e0/rho(k,l)
          rho(k,l) = mass(k,l)/vol
          vnp = 1.0e0/rho(k,l)
          dtau(k,l) = vnp-vn
  310   continue
  300 continue
 
      return
      end
 
 
      subroutine pdvwor
      implicit real*8 (a-h,o-z)
 
c        this routine calculates the hydrodynamic work done in a zone
c      and updates the energy to reflect this work.
 
      common /main/
     1 r(100,100),z(100,100),u(100,100),v(100,100),aj(100,100)
     2,energy(100,100),p(100,100),q(100,100),temp(100,100)
     3,rho(100,100),dtau(100,100),mass(100,100),nbc(100,100)
      real*8  mass
 
      common /klspac/ kmn,lmn,kmx,lmx
 
 
c         get new energy accurate to second order
 
      kmnp = kmn + 1
      lmnp = lmn + 1
c d$ cncall
        do 110 l=lmnp,lmx
C cvd$ cncall
      do 100 k=kmnp,kmx
          eps = energy(k,l)-(p(k,l)+q(k,l))*dtau(k,l)
          phat = eos(tempca(eps,rho(k,l),temp(k,l)) , rho(k,l) , 1)
          energy(k,l) = energy(k,l)-
     +        		(0.5e0*(phat+p(k,l))+q(k,l))*dtau(k,l)
          if (energy(k,l) .lt. 0.0e0) energy(k,l) = 0.0e0
  100 continue
  110   continue
 
      return
      end
 
 
      subroutine projct(r0,z0,r1,z1,rp,zp,rr,zr)
      implicit real*8 (a-h,o-z)
 
c      this subroutine reflects an interior point across the boundary
 
c      reflect (rp,zp) to (rr,zr)
c      where (r0,z0) and (r1,z1) are boundary points
 
      ww = (2.0e0*(z1-z0))/((r1-r0)**2+(z1-z0)**2)
      alpha = 1.0e0-(z1-z0)*ww
      beta = (r1-r0)*ww
      rr = r0 + (rp-r0)*alpha + (zp-z0)*beta
      zr = z0 + (rp-r0)*beta  - (zp-z0)*alpha
 
      return
      end
 
 
c
c Count of number of calls commented out so this may be called in
c a concurrent loop. -jpg
c
c     function sroot(arg)
c     implicit real*8 (a-h,o-z)
c      data isroot/0/
c     sroot=sqrt(arg)
c      isroot=isroot+1
c     return
c     end


      subroutine setup
      implicit real*8 (a-h,o-z)
 
      common /eoscom/ ntsv(2),nrsv(2),msv(2),ntm1sv(2),tes(7),res(9)
     x ,aes(12),bes(12),ces(12),des(12),ees(12),fes(12),ges(12)
     x ,hes(12),pes(12),ites(3),ires(3),izes(3)
 
c      define a gamma-law gas equation of state for the
c      bi-quadratic table look-up routine -jes- .
c          pressure = sp.heat * (gamma-1) * theta * rho
c          energy   = sp.heat * theta
 
c      gamma - thermodynamic coefficient for an ideal(gamma-law) gas.
c      csubv - specific heat at constant volume of the ideal gas.
 
      data csubv   /0.1e0/
      data gamma   /1.6667e0/
 
c           define initial starting value for eos lookup
 
      data ntsv /1 , 4/
      data nrsv /1 , 5/
      data msv  /1 , 7/
 
c           define pressure, energy and function box boundaries
 
      data ites /1 , 4 , 7/
      data ires /1 , 5 , 9/
      data izes /1 , 7 , 13/
 
c            define temperatures for pressure and energy table
 
      data tes /
     1  0.0e0 , 1.0e0 , 100.0e0
     2, 0.0e0 , 1.0e0 , 100.0e0
     3, 0.0e0 /
 
c            define densities for pressure and energy table
 
      data res /
     1  0.0e0 , 3.0e0 , 300.0e0 , 3.0e10
     2, 0.0e0 , 3.0e0 , 300.0e0 , 3.0e10
     3, 0.0e0 /
 
      data ntm1sv/3,3/
 
c            coefficients for pressure table are all zero except for
c            fes(1) through fes(6) which are (gamma-1). fes is the
c            coefficient which multiplies rho*theta in the bi-quadratic
c            form.
 
c            coefficients for energy table are all zero except for
c            ces(7) through ces(12) which are (gamma-1). ces is the
c            coefficient which multiplies theta in the bi-quadratic
c            form.
 
      data aes / 6*0.0e0 , 6*0.0e0 /
      data bes / 6*0.0e0 , 6*0.0e0 /
      data des / 6*0.0e0 , 6*0.0e0 /
      data ees / 6*0.0e0 , 6*0.0e0 /
      data ges / 6*0.0e0 , 6*0.0e0 /
      data hes / 6*0.0e0 , 6*0.0e0 /
      data pes / 6*0.0e0 , 6*0.0e0 /
 
      low = izes(1)
      lup = izes(2) - 1
      cons = csubv*(gamma-1.0e0)
      do 100 i=low,lup
        ces(i) = 0.0e0
        fes(i) = cons
  100 continue
 
      low = izes(2)
      lup = izes(3) - 1
      do 110 i=low,lup
        fes(i) = 0.0e0
        ces(i) = csubv
  110 continue
 
      return
      end
 
 
      function tempca(evalue,rho,theta)
      implicit real*8 (a-h,o-z)
      common /eoscom/ ntsv(2),nrsv(2),msv(2),ntm1sv(2),tes(7),res(9)
     x ,aes(12),bes(12),ces(12),des(12),ees(12),fes(12),ges(12)
     x ,hes(12),pes(12),ites(3),ires(3),izes(3)
      nt=ntsv(2)
      nr=nrsv(2)
      m=msv(2)
      ntm1=ntm1sv(2)
      if(theta.ge.tes(nt+1)) go to 50000
      if(theta.lt.tes(nt)) go to 50001
      if(rho.ge.res(nr+1)) go to 50002
      if(rho.lt.res(nr)) go to 50003
60000 continue
      alp=ees(m)+rho*(hes(m)+rho*pes(m))
      bet=ces(m)+rho*(fes(m)+rho*ges(m))
      gam=aes(m)+rho*(bes(m)+rho*des(m))-evalue
      theta=-2.0e0*gam/(bet+sqrt(bet*bet-4.0e0*alp*gam) )
      if(theta.gt.tes(nt+1)) go to 50000
      if(theta.lt.tes(nt)) go to 50001
       tempca=theta
      return
50000 nt=nt+1
      m=m+1
      if(theta.ge.tes(nt)) go to 50000
      nt=nt-1
      m=m-1
50012 if(rho.ge.res(nr+1)) go to 50002
      if(rho.lt.res(nr)) go to 50003
      go to 50004
50001 nt=nt-1
      m=m-1
      if(theta.lt.tes(nt)) go to 50001
      go to 50012
50002 nr=nr+1
      m=m+ntm1
      if(rho.ge.res(nr)) go to 50002
      nr=nr-1
      m=m-ntm1
      go to 50004
50003 nr=nr-1
      m=m-ntm1
      if(rho.lt.res(nr)) go to 50003
50004 continue
      go to 60000
      end




