#include "world.h"


#ifdef BBN
#include <ctype.h>			/* for isdigit */
#include "/usr/local/include/gang.h"

gsPrioClass_t GsClass;
int           BenchTime;
char         *Proc_string = NULL;
#endif


#define FIBREIN           1
#define FIBREOUT          2

#define GET_Tmp(y)        (Tmp = atoi( &(argv[ ArgIndex ][(y)]) ))

#define GET_Tmp_String(y)    (strcpy(Tmp_string,&(argv[ ArgIndex ][(y)])))

#define CASE_OPTION(f,s)  if ( argv[ArgIndex][s] == (f) )


void ParseCommandLine( argc, argv )
int   argc;
char *argv[];
{
  register int   ArgIndex;
           int   Tmp;
           int   Fd;
           int   FibreFileMode;
	   char  Tmp_string[255];

  FibreFileMode = FIBREIN;

#ifdef BBN
  GsClass = pc_none;
#endif

  for ( ArgIndex = 1; ArgIndex < argc; ArgIndex++ ) {
      if ( argv[ArgIndex][0] != '-' ) {
        switch ( FibreFileMode ) {
	  case FIBREIN:
            OPEN( FibreInFd, argv[ArgIndex], "r" );
            break;

	  case FIBREOUT:
            OPEN( FibreOutFd, argv[ArgIndex], "w" );
            break;

          default:
            goto Argument_Error;
            break;
          }

        FibreFileMode++;
        continue;
        }

       CASE_OPTION( 'P', 1 ) {
          UsePrivateMemory = TRUE;
        continue;
        }

      CASE_OPTION( 'g', 1 ) {
	CASE_OPTION( 's', 2 ) {
	  CASE_OPTION( 's', 3 ) {
            UseGss = TRUE;
	    continue;
            }
	  }

	goto Argument_Error;
        }

      CASE_OPTION( 'z', 1 ) {
        NoFibreOutput = TRUE;
        continue;
        }

      CASE_OPTION( 'a', 1 ) {
	CASE_OPTION( 'x', 2 ) {
	  if ( GET_Tmp( 3 ) < 0 )
	    goto Argument_Error;

          ArrayExpansion = Tmp;
	  continue;
          }

        goto Argument_Error;
	}

      CASE_OPTION( 'l', 1 ) {
        CASE_OPTION( 's', 2 ) {
          if ( GET_Tmp( 3 ) <= 0 )
            goto Argument_Error;

          LoopSlices = Tmp;
          continue;
          }

	goto Argument_Error;
        }

      CASE_OPTION( 'w', 1 ) {
        if ( GET_Tmp( 2 ) <= 0 )
          goto Argument_Error;

        if ( Tmp > MAX_PROCS )
          goto Argument_Error;

#if ALLIANT || CRAY || SGI
        if ( Tmp > 1 )
          goto Argument_Error;
#endif

        NumWorkers = Tmp;
        continue;
        }

      CASE_OPTION( 'r', 1 ) {
        GatherPerfInfo = TRUE;
        OPEN( PerfFd, "s.info", "a" );
        continue;
        }

      CASE_OPTION( 'd', 1 ) {
        CASE_OPTION( 's', 2 ) {
          if ( GET_Tmp( 3 ) <= 0 )
            goto Argument_Error;

          SharedDsaSize = Tmp;
          continue;
          }

        CASE_OPTION( 'x', 2 ) {
          if ( GET_Tmp( 3 ) < 0 )
            goto Argument_Error;

          XftThreshold = Tmp;
          continue;
          }
	}

      CASE_OPTION( '\0', 1 ) {
        FibreFileMode++;
        continue;
        }

      CASE_OPTION( 'b', 1 ) {
        CASE_OPTION( 'm', 2 ) {
          if ( GET_Tmp( 3 ) <= 0 )
            goto Argument_Error;

          Benchmarking = TRUE;
#ifdef BBN
          BenchTime = Tmp;
          GsClass = pc_benchmark;
#endif
          continue;
          }

       CASE_OPTION( 'c', 2 ) {
	 if ( GET_Tmp( 3 ) <= 0 )
	   goto Argument_Error;

	 BenchmarkCycles = Tmp;
	 continue;
	 }

       goto Argument_Error;
       }

     CASE_OPTION( 'p', 1 ) {
       CASE_OPTION( 'd', 2 ) {
         CASE_OPTION( 's', 3 ) {
           if ( GET_Tmp( 4 ) <= 0 )
             goto Argument_Error;

           PrivateDsaSize = Tmp;
           continue;
           }
         }
       }

#ifdef BBN
     CASE_OPTION( 'p', 1) {
       CASE_OPTION( 'r', 2) {
         GsClass = pc_production;
         continue;
         }

       CASE_OPTION('"', 2) {
         Proc_string = (char *)malloc(255);
         GET_Tmp_String( 3 );
         strcpy(Proc_string,Tmp_string);
         /*
          * wipe out trailing " character
          */
         Proc_string[strlen(Tmp_string) - 1] = NULL;
         continue;
         }
       /*
        * if the shell has eaten the leading "
        */
       if(isdigit(argv[ArgIndex][2])) {
         Proc_string = (char *)malloc(255);
         GET_Tmp_String( 2 );
         strcpy(Proc_string,Tmp_string);
         continue;
         }
       }

     CASE_OPTION( 'i', 1) {
       CASE_OPTION( 'n', 2) {
         GsClass = pc_interactive;
         continue;
         }
       }
#endif

    goto Argument_Error;
    }

  if ( LoopSlices == -1 )
    LoopSlices = NumWorkers;
  else if ( UseGss )
    SisalError( "COMMAND LINE CONFLICT", "-gss AND -ls" );

  if ( UsePrivateMemory && (NumWorkers != 1) )
    SisalError( "ILLEGAL COMBINATION OF -P and -w#", "" );

  return;

Argument_Error:
  SisalError( "ILLEGAL COMMAND LINE ARGUMENT", argv[ArgIndex] );
} 


static void PrintExecutionTimes()
{
  struct WorkerInfo *InfoPtr;
  int    Worker;
  double CpuUse;
  int    NumIterations;

  fprintf( PerfFd, "  CpuTime  WallTime    CpuUse\n" );

#if ALLIANT || BBN
  NumIterations = 1;
#else
  NumIterations = NumWorkers;
#endif

  for ( Worker = 0; Worker < NumIterations; Worker++ ) {
    InfoPtr = &(AllWorkerInfo[ Worker ]);

    if ( InfoPtr->WallTime != 0.0 ) {
      CpuUse  = InfoPtr->CpuTime;
      CpuUse /= InfoPtr->WallTime;
      }
    else
      CpuUse = 0.0;

    fprintf( PerfFd, " %8.4f %9.4f %8.1f%%\n",
             InfoPtr->CpuTime, InfoPtr->WallTime, CpuUse * 100.0 );
    }
}


void DumpRunTimeInfo()
{
  register struct WorkerInfo *InfoPtr;
  register int    Worker;
  register double CopyInfo, ATAttempts, ATCopies, ANoOpAttempts;
  register double ANoOpCopies, RNoOpAttempts, RNoOpCopies, ADataCopies;
  register int    StorageUsed, StorageWanted, DsaHelp;
  register int    pr_StorageUsed, pr_StorageWanted, pr_DsaHelp;
  register double FlopInfo, FlopCountA, FlopCountL, FlopCountI;
  register double SharedReads, PrivateReads;

  SharedReads = PrivateReads = 0.0;

  FlopInfo = FlopCountA = FlopCountL = FlopCountI = 0.0;

  CopyInfo = ATAttempts = ATCopies = ANoOpAttempts        = 0.0;
  ANoOpCopies = RNoOpAttempts = RNoOpCopies = ADataCopies = 0.0;
  StorageUsed =  StorageWanted = DsaHelp = 0;
  pr_StorageUsed =  pr_StorageWanted = pr_DsaHelp = 0;

  for ( Worker = 0; Worker < NumWorkers; Worker++ ) {
    InfoPtr = &(AllWorkerInfo[ Worker ]);

    CopyInfo      += InfoPtr->CopyInfo;
    FlopInfo      += InfoPtr->FlopInfo;

    FlopCountA    += InfoPtr->FlopCountA;
    FlopCountL    += InfoPtr->FlopCountL;
    FlopCountI    += InfoPtr->FlopCountI;

    ATAttempts    += InfoPtr->ATAttempts;
    ATCopies      += InfoPtr->ATCopies;
    ANoOpAttempts += InfoPtr->ANoOpAttempts;
    ANoOpCopies   += InfoPtr->ANoOpCopies;
    RNoOpAttempts += InfoPtr->RNoOpAttempts;
    RNoOpCopies   += InfoPtr->RNoOpCopies;
    ADataCopies   += InfoPtr->ADataCopies;

    DsaHelp        += InfoPtr->DsaHelp;
    StorageUsed    += InfoPtr->StorageUsed;
    StorageWanted  += InfoPtr->StorageWanted;

    pr_DsaHelp        += InfoPtr->pr_DsaHelp;
    pr_StorageUsed    += InfoPtr->pr_StorageUsed;
    pr_StorageWanted  += InfoPtr->pr_StorageWanted;

    SharedReads   += InfoPtr->SharedReads;
    PrivateReads  += InfoPtr->PrivateReads;
    }

  fprintf( PerfFd, "\n\n\n" );

  fprintf( PerfFd, "  Workers  %cDsaSize  ExactFit %cDsaHelps\n", 
	   (UsePrivateMemory)? 'p' : 's',
	   (UsePrivateMemory)? 'p' : 's' );

  fprintf( PerfFd, "%9d %8db %8db %9d\n\n", 
	           NumWorkers, SharedDsaSize, XftThreshold, DsaHelp );

  fprintf( PerfFd, " PDsaSize     PMemW     PMemU PDsaHelps\n" );
  fprintf( PerfFd, "%8db %8db %8db %9d\n\n", PrivateDsaSize, pr_StorageWanted,
                   pr_StorageUsed, pr_DsaHelp ); 

#ifdef BBN
  fprintf( PerfFd, "  GsClass\n" );

  if ( GsClass == pc_interactive ) 
    fprintf( PerfFd, "%9s\n\n", "    inter" ); 
  else if ( GsClass ==  pc_production )
    fprintf( PerfFd, "%9s\n\n", "     prod" ); 
  else if ( GsClass == pc_benchmark )
    fprintf( PerfFd, "%9s\n\n", "    bench" ); 
  else
    fprintf( PerfFd, "%9s\n\n", "     none" ); 
#endif

  if ( !UseGss ) {
    fprintf( PerfFd, "    %cMemW     %cMemU  LpSliceV   ArrayEx\n",
	     (UsePrivateMemory)? 'p' : 's', (UsePrivateMemory)? 'p' : 's' );
    fprintf( PerfFd, "%8db %8db %9d %9d\n\n", 
		     StorageWanted, StorageUsed, LoopSlices, ArrayExpansion );
  } else {
    fprintf( PerfFd, "    %cMemW     %cMemU   GssFact   ArrayEx\n",
	     (UsePrivateMemory)? 'p' : 's', (UsePrivateMemory)? 'p' : 's' );
	     
    fprintf( PerfFd, "%8db %8db %9d %9d\n\n", 
		     StorageWanted, StorageUsed, 1, ArrayExpansion );
    }

  PrintExecutionTimes();

  if ( CopyInfo > 0.0 ) {
    fprintf( PerfFd, "\n              AtOps            AtCopies"  );
    fprintf( PerfFd, "               AcOps            AcCopies\n" );
    fprintf( PerfFd, " %18.0f  %18.0f  %18.0f  %18.0f\n\n", ATAttempts, 
		       ATCopies, ANoOpAttempts, ANoOpCopies          );

    fprintf( PerfFd, "              RcOps            RcCopies" );
    fprintf( PerfFd, "           CharMoves\n" );
    fprintf( PerfFd, " %18.0f  %18.0f  %18.0f\n\n", RNoOpAttempts, 
		       RNoOpCopies, ADataCopies               );

    fprintf( PerfFd, "     SharedRowReads     PrivateRowReads\n" );
    fprintf( PerfFd, " %18.0f  %18.0f\n", SharedReads, PrivateReads );
    }

  if ( FlopInfo > 0.0 ) {
    fprintf( PerfFd, "\n FlopCounts (ARITHMETIC): %18.0f\n", FlopCountA );
    fprintf( PerfFd, "               (LOGICAL): %18.0f\n", FlopCountL );
    fprintf( PerfFd, "             (INTRINSIC): %18.0f\n", FlopCountI );
    }

  fprintf( PerfFd, "\n" );
}


void InitSisalRunTime()
{
  AcquireSharedMemory( SharedDsaSize );

  InitDsa( SharedDsaSize, XftThreshold );
  pr_InitDsa( PrivateDsaSize );

  InitErrorSystem();
  InitWorkers();
  InitReadyList();
  InitSignalSystem();
  InitSpawn();
}
