#include "world.h"


#ifdef ALLIANT
int InParallel = FALSE;

static int Transfer( ProcId, ARs )
int ProcId;
struct ActRec *ARs;
{
  register struct ActRec *MyAR;

  MyAR = &ARs[ProcId];

  (*(MyAR->ChildCode))( MyAR->ArgPointer, 
			MyAR->SliceBounds[1], MyAR->SliceBounds[2] );
}
#endif


LOCK_TYPE *UtilityLock;
LOCK_TYPE *SUtilityLock;

void InitSpawn()
{
  UtilityLock = (LOCK_TYPE*) SharedMalloc( sizeof(LOCK_TYPE) );
  MY_INIT_LOCK( UtilityLock );

  SUtilityLock = (LOCK_TYPE*) SharedMalloc( sizeof(LOCK_TYPE) );
  MY_SINIT_LOCK( SUtilityLock );
}


void BuildGssSlices( Head, Count, ChildCode, ArgPointer, Low, High )
struct ActRec **Head;
int     *Count;
void    (*ChildCode)();
POINTER ArgPointer;
int     Low;
int     High;
{
  register struct ActRec *NewAR;
  register int            ThisHi;
  register int           *SliceBounds;
  register int            LowTemp;

  *Count = 0;
  LowTemp = Low;

  while ( LowTemp <= High ) {
    LowTemp += ((High-LowTemp)/NumWorkers) + 1;
    *Count += 1;
    }

  *Head = NewAR = (struct ActRec *) Alloc( sizeof(struct ActRec)*(*Count) );

  while ( Low <= High ) {
    SliceBounds    = NewAR->SliceBounds;
    SliceBounds[1] = Low;
    SliceBounds[2] = ThisHi = Low + ((High-Low)/NumWorkers);

    NewAR->ArgPointer  = ArgPointer;
    NewAR->ChildCode   = ChildCode;
    NewAR->Done        = FALSE;

    Low = ThisHi + 1;

    NewAR->NextAR = NewAR + 1;
    NewAR++;
    }
}


void BuildSlices( LoopType, Head, Count, ChildCode, ArgPointer, Low, High )
int             LoopType;
struct ActRec **Head;
int            *Count;
void            (*ChildCode)();
POINTER         ArgPointer;
int             Low;
int             High;
{
  register struct ActRec *NewAR;
  register int            Thickness;
  register int            Remainder;
  register int            ThisHi;
  register int           *SliceBounds;

  if ( UseGss && LoopType == SPAWN_COMPLEX ) {
    BuildGssSlices( Head, Count, ChildCode, ArgPointer, Low, High );
    return;
    }

  *Count = 0;

  Thickness     = High - Low + 1;
  Remainder     = Thickness % LoopSlices;
  Thickness    /= LoopSlices;

  *Head = NewAR = (struct ActRec *) Alloc( sizeof(struct ActRec)*LoopSlices );

  while ( Low <= High ) {
    SliceBounds    = NewAR->SliceBounds;
    SliceBounds[1] = Low;
    SliceBounds[2] = ThisHi = Low + Thickness + 
			      (((Remainder--) > 0)? 0 : -1);

    NewAR->ArgPointer  = ArgPointer;
    NewAR->ChildCode   = ChildCode;
    NewAR->Done        = FALSE;

    Low = ThisHi + 1;

    *Count += 1;

    NewAR->NextAR = NewAR + 1;
    NewAR++;
    }
}


void OptSpawnSlices( FirstAR, Count )
struct  ActRec *FirstAR;
int     Count;
{
  register struct ActRec *LastAR;

  DoDistDeAllocs();

  if ( Count > 0 ) {

    if ( Count == 1 ) {
      (*(FirstAR->ChildCode))( FirstAR->ArgPointer, 
			       FirstAR->SliceBounds[1], 
			       FirstAR->SliceBounds[2] );
      return;
      }

#ifdef ALLIANT
    if ( InParallel ) {
      register int Id;
      for ( Id = 0; Id < Count; Id++ )
	Transfer( Id, FirstAR );
    } else {
      InParallel = TRUE;
      concurrent_call( 0, Transfer, Count, FirstAR );
      InParallel = FALSE;
      }
    goto TheExit;
#endif

    LastAR = FirstAR +(Count-1);

    RListEnQ( FirstAR, LastAR );
    Sync( FirstAR, LastAR+1 );
    }

TheExit:
  return;
}


void SpawnSlices( LoopType, ChildCode, ArgPointer, Low, High )
int     LoopType;         /* CONCUR_VECTOR or CONCUR */
void    (*ChildCode)();
POINTER ArgPointer;
int     Low;
int     High;
{
  struct ActRec *FirstAR;
  int            Count;

  BuildSlices( LoopType, &FirstAR, &Count, ChildCode, ArgPointer, Low, High );

  OptSpawnSlices( FirstAR, Count );

  DeAlloc( FirstAR );
}
