#include "world.h"


#ifdef BBN
#include "/usr/local/include/gang.h" 
extern gsPrioClass_t GsClass;
#endif

volatile int      *SisalShutDown;
struct WorkerInfo *AllWorkerInfo;

BARRIER_TYPE      *FinishBarrier;
BARRIER_TYPE      *StartBarrier;


void InitWorkers()
{
  int    WorkerCount;
  struct WorkerInfo *InfoPtr;
  int    BytesNeeded;
  int    Index;

  SisalShutDown = (int *) SharedMalloc( sizeof(int) * NumWorkers );

  for ( Index = 0; Index < NumWorkers; Index++ )
    SisalShutDown[Index] = FALSE;

#ifdef BBN
  if ( UsePrivateMemory )
    StartBarrier  = (BARRIER_TYPE*) shmalloc( sizeof(BARRIER_TYPE) );
  else
    StartBarrier  = (BARRIER_TYPE*) SharedMalloc( sizeof(BARRIER_TYPE) );

  INIT_BARRIER(StartBarrier,NumWorkers+1);

  FinishBarrier = (BARRIER_TYPE*) SharedMalloc( sizeof(BARRIER_TYPE) );
  INIT_BARRIER(FinishBarrier,NumWorkers);
#else
  if ( NumWorkers > 1 ) {
    FinishBarrier = (BARRIER_TYPE*) SharedMalloc( sizeof(BARRIER_TYPE) );
    INIT_BARRIER(FinishBarrier,NumWorkers);

    StartBarrier  = (BARRIER_TYPE*) SharedMalloc( sizeof(BARRIER_TYPE) );

    INIT_BARRIER(StartBarrier,NumWorkers);
    }
#endif

  BytesNeeded   = sizeof(struct WorkerInfo) * NumWorkers;
  AllWorkerInfo = (struct WorkerInfo *) SharedMalloc( BytesNeeded );

#ifndef ALLIANT
#ifndef CRAY
#ifndef SGI
  p_procnum = 0;  /* FOR FIBRE PROCESSING??? */
#endif
#endif
#endif

#ifdef SGI
  GetProcId = 0;
#endif

  for ( WorkerCount = NumWorkers ; WorkerCount > 0; WorkerCount-- ) {
    InfoPtr = &(AllWorkerInfo[ WorkerCount - 1 ]);

    InfoPtr->FlopInfo       = 0.0;
    InfoPtr->FlopCountA     = 0.0;
    InfoPtr->FlopCountL     = 0.0;
    InfoPtr->FlopCountI     = 0.0;

    InfoPtr->CopyInfo       = 0.0;
    InfoPtr->ATAttempts     = 0.0;
    InfoPtr->ATCopies       = 0.0;
    InfoPtr->ANoOpAttempts  = 0.0;
    InfoPtr->ANoOpCopies    = 0.0;
    InfoPtr->RNoOpAttempts  = 0.0;
    InfoPtr->RNoOpCopies    = 0.0;
    InfoPtr->ADataCopies    = 0.0;

    InfoPtr->DsaHelp        = 0;
    InfoPtr->StorageUsed    = 0;
    InfoPtr->StorageWanted  = 0;

    InfoPtr->SharedReads       = 0.0;
    InfoPtr->PrivateReads      = 0.0;

    InfoPtr->pr_DsaHelp        = 0;
    InfoPtr->pr_StorageUsed    = 0;
    InfoPtr->pr_StorageWanted  = 0;
    }
}


void LeaveWorker( ShutDown )
int ShutDown;
{
  register int Index;

#ifdef BBN
  if ( GatherPerfInfo && (GetProcId == 0) )
#else
  if ( GatherPerfInfo )
#endif
    StopTimer();

  if ( ShutDown )
    for ( Index = 0; Index < NumWorkers; Index++ )
      SisalShutDown[Index] = TRUE;

#ifdef BBN
  WAIT_BARRIER(FinishBarrier);
#else
  if ( NumWorkers > 1 ) {
    WAIT_BARRIER(FinishBarrier);
    }
#endif

}

void EnterWorker( ProcId )
int ProcId;
{

#ifdef BBN
  WAIT_BARRIER(StartBarrier);
#else
  if ( NumWorkers > 1 ) {
    WAIT_BARRIER(StartBarrier);
    }
#endif

#ifdef BBN
  if ( GatherPerfInfo && (ProcId == 0) )
#else
  if ( GatherPerfInfo )
#endif
    StartTimer();

  if ( ProcId != 0 )
    Wait( FOR_SHUTDOWN );
}
