/* Output from p2c, the Pascal-to-C translator */
/* From input file "../util/strutl.h" */


/* copyright (C) 1986 by the Regents of the University of California */

/* STRUTL has no data dependancies ...  first in .makeo file */

/* Pad String pads a string constant to a M4 known size  - pjm 1/88*/





/* copyright (C) 1986 by the Regents of the University of California */

/* STRUTL has no data dependancies ...  first in .makeo file */

/* Pad String pads a string constant to a M4 known size  - pjm 1/88*/




#include "di.h"


/*#TITLE  STRUTL  CONSTANTS       Jan82   String Handling Routines.*/

#define maxstringchars  80
/* changed from 132 */
/*mlw*/

#define blankstring     "                                                                                "

#define maxbigint       LONG_MAX



/*#TITLE  STRUTL  TYPES           Jan82   String Handling Routines.*/

typedef Char stryngar[maxstringchars];

typedef struct stryng {
  char len;
  stryngar str;
} stryng;

typedef Char str10[10];
typedef Char str20[20];

/*strutl has no vars */


/*#TITLE  STRUTL  ROUTINES        Jan83   String Handling Routines.*/

/* macro function IsDigit( C: char ): boolean */

/* macro function IsHexOnly( C: char ): boolean */

/* macro function IsLowerCase( C: char ): boolean */

/* macro function IsUpperCase( C: char ): boolean */

/* macro procedure MakeLowerCase( var C: char ) */

/* macro procedure MakeUpperCase( var C: char ) */

/* macro function StringLength( S: Stryng ): integer */

/* macro function IsEmptyString( S: Stryng ): boolean */


extern Char stringchar PP((stryng *s, long n));

extern Void clearstring PP((stryng *s, int first, int last));

/* rky Oct87 */
extern Void clearstringtoend PP((stryng *s));

/* macro procedure InitString( S: Stryng )  */

extern Void insertchar PP((stryng *s, int c, int p));

extern Void concatchar PP((stryng *s, int c));

extern Void concatnchars PP((stryng *s, int c, long n));

/* macro procedure CharString( S: Stryng; C: Char ) */

extern Void stripspaces PP((stryng *s));

extern Void string10 PP((stryng *s, Char *s10));

extern Void string20 PP((stryng *s, Char *s20));

extern Void stringn PP((stryng *s, Char *sn, long count));

extern Void insertstring PP((stryng *s, stryng *t, int p));

/* macro procedure ConcatString( var S: Stryng; T: Stryng ) */

extern Void readstring PP((FILE **fil, stryng *s));

extern boolean readstringok PP((FILE **fil, stryng *s));

/* reads a string of the form [Letter | Digit]* */
extern Void readidentifier PP((FILE **fil, stryng *s));

extern Void readifstring PP((FILE **fil, stryng *s));

extern Void readliteralstring PP((FILE **fil, stryng *s));

extern Void writestring PP((FILE **fil, stryng *s));

extern Void writenstring PP((FILE **fil, stryng s, long n));

extern Void substring PP((stryng *t, stryng *s, int first, long last));

extern Void deletestring PP((stryng *s, int first, long last));

extern Char uppercase PP((int c));

extern Void stringuppercase PP((stryng *s));

extern Char lowercase PP((int c));

extern Void stringlowercase PP((stryng *s));

extern boolean matchstrings PP((stryng *s1, stryng *s2, int pos));

extern boolean equalstrings PP((stryng *s1, stryng *s2));

/* True iff S1=S2 ignoring case differences.  Doesn't change S1 or S2.
   rky added 25May88.  Gotos are fun! */
extern boolean equivstrings PP((stryng *s1, stryng *s2));

extern long findchar PP((int c, stryng *s, int pos));

extern long findstring PP((stryng *s, stryng *t, int pos));

extern long findlastchar PP((int c, stryng *s));

extern Void numberstring PP((stryng *s, long n, long base));

extern Void integerstring PP((stryng *s, long n, long width));

extern long charval PP((int ch));

extern long stringnumber PP((stryng *s, long *pos, long base));


/* macro function StringNumber( S: Stryng; Pos: integer ): integer */

/* SETUTL has on data dependancies ...
   second in .makeo file */


/* copyright (C) 1986 by the Regents of the University of California */

/* SETUTL has on data dependancies ...
   second in .makeo file */

/* Constants from setutl.m4 */
/* The maximum size of a set of integers */

#define maxsetsize      6000   /*mlw*/


/* Types from setutl.m4 */
typedef uchar bitbucket[(maxsetsize + 7) / 8];   /*mlw*/
/*mlw*/

typedef struct setofint {
  short count;   /* number of elements in the set */
  short maxsize;   /* max numb of elements set can hold */
  bitbucket inset;   /* bit vector, true means ele in set */
} setofint;

/*setutl has no vars*/



/* Procedures and Functions from setutl.m4 */


extern Void makeemptyset PP((setofint *iset, int size));

/* macro function SizeOfSet ( Iset : SetOfInt ) : integer; */
/* pre  : none
   post : returns cardinality of this set */

/* macro function IsEmptySet ( Iset : SetOfInt ) : boolean; */
/* pre  : none
   post : returns true only if (cardinality = 0)  */

extern Void addtoset PP((int element, setofint *iset));

extern Void removefromset PP((int element, setofint *iset));

extern boolean isinset PP((int element, setofint iset));

extern Void getsetelement PP((short *element, setofint *iset));

extern boolean issubset PP((setofint subset, setofint bigset));

extern Void setunion PP((setofint set1, setofint set2, setofint *newset));

extern Void setdifference PP((setofint set1, setofint set2, setofint *newset));


/* IF1INIT no dependancies..
   third in .makeo file */


/* copyright (C) 1986 by the Regents of the University of California */

/* IF1INIT no dependancies..
   third in .makeo file */


/*#TITLE  IF1INIT CONSTANTS       Oct83   Standard IF1 Constants*/
/*Constants derived from v9.me 84/7/26 by sks*/

#define ifmaxnamelen    15   /* dlz -8/87 for the name tables */

#define ifmaxnode       195

/*Node */
#define ifnforall       0
#define ifnselect       1
#define ifntagcase      2
#define ifnloopa        3
#define ifnloopb        4
#define ifnifthenelse   5   /*mlw - 2/3/86*/
#define ifniter         6
#define ifnmodule       20   /* jwrg */
#define ifngraph        21   /* jwrg */

#define ifnaaddh        100
#define ifnaaddl        101
#define ifnaextract     102
#define ifnabuild       103
#define ifnacatenate    104
#define ifnaelement     105
#define ifnafill        106
#define ifnagather      107
#define ifnaisempty     108
#define ifnalimh        109
#define ifnaliml        110
#define ifnaremh        111
#define ifnareml        112
#define ifnareplace     113
#define ifnascatter     114
#define ifnasetl        115
#define ifnasize        116
#define ifnabs          117
#define ifnbindarguments  118
#define ifnbool         119
#define ifncall         120
#define ifnchar         121
#define ifndiv          122
#define ifndouble       123
#define ifnequal        124
#define ifnexp          125
#define ifnfirstvalue   126
#define ifnfinalvalue   127
#define ifnfloor        128
#define ifnint          129
#define ifniserror      130
#define ifnless         131
#define ifnlessequal    132
#define ifnmax          133
#define ifnmin          134
#define ifnminus        135
#define ifnmod          136
#define ifnneg          137
#define ifnnoop         138
#define ifnnot          139
#define ifnnotequal     140
#define ifnplus         141
#define ifnrangegenerate  142
#define ifnrbuild       143
#define ifnrelements    144
#define ifnrreplace     145
#define ifnredleft      146
#define ifnredright     147
#define ifnredtree      148
#define ifnreduce       149
#define ifnallbutlastvalue  150
#define ifnsingle       151
#define ifntimes        152
#define ifntrunc        153
#define ifnaprefixsize  154
#define ifnareplacen    160
#define ifnspawn        161
#define ifnfilter       168
#define ifnashift       169

/*IF2 Nodes*/

#define ifnaaddlat      170
#define ifnaaddhat      171
#define ifnabufpartition  172
#define ifnabuildat     173
#define ifnabufscatter  174
#define ifnacatenateat  175
#define ifnaelementsat  176
#define ifnaextractat   177
#define ifnafillat      178
#define ifnagatherat    179
#define ifnaremhat      180
#define ifnaremlat      181
#define ifnareplaceat   182
#define ifnarraytobuf   183
#define ifnasetlat      184
#define ifndefarraybuf  185
#define ifndefrecordbuf  186
#define ifnfinalvalueat  187
#define ifnmemalloc     188
#define ifnrbufelements  189
#define ifnrbuildat     190
#define ifnrecordtobuf  191
#define ifnrelementsat  192
#define ifnreduceat     193
#define ifnshiftbuffer  194
#define ifncondsetrefcnt  195

#define ifmaxerror      12

/*ErrorType */
/* genuine errors must be all < IFENoError */
#define ifebroken       0
#define ifeerror        1
#define ifemiselt       2
#define ifenegover      3
#define ifenegunder     4
#define ifeposover      5
#define ifeposunder     6
#define ifeundef        7
#define ifeunknown      8
#define ifezerodivide   9
#define ifenoerror      10   /*rky, means value present, not an error */
#define ifenovalue      11
    /*rky, means no value present, not even an error */
#define ifmrnovalue     12   /*dlz no min reeval previous value */

/*TypeTableEntry */

#define ifmaxtype       11

#define iftarray        0
#define iftbasic        1
#define iftfield        2
#define iftfunctiontype  3
#define iftmultiple     4
#define iftrecord       5
#define iftstream       6
#define ifttag          7
#define ifttuple        8
#define iftunion        9
#define iftwild         10
#define iftbuffer       11

/*BasicType */

#define ifmaxbasic      6

#define ifbboolean      0
#define ifbcharacter    1
#define ifbdouble       2
#define ifbinteger      3
#define ifbnull         4
#define ifbreal         5
#define ifbwild         6

/* types of reduction operations */
#define ifmaxreduction  5

#define ifrsum          0
#define ifrproduct      1
#define ifrleast        2
#define ifrgreatest     3
#define ifrcatenate     4
#define ifrappend       5
    /* rky 10dec84. AGather is just a kind of multiple reduction */


/*#TITLE  IF1INIT TYPES             IFNAug83   Standard IF1 Types*/

/* Printable Name */
typedef Char printable[16];


/* Nodes */

/* Error Values */

/* Type Values */

/* Basic Values */

/* Types for reduction operations */

typedef enum {
  ifgfunction, ifgselector, ifgalternative, ifgvariant, ifgloopainit,
  ifgloopabody, ifgloopatest, ifgloopareturns, ifgloopbinit, ifgloopbbody,
  ifgloopbtest, ifgloopbreturns, ifgforallgenerator, ifgforallbody,
  ifgforallreturns, ifgifpredicate, ifgiftrue, ifgiffalse, ifgiterbody
} ifgraphtype;


/*dlz - 8/87*/
typedef enum {
  unaryalgeb, binaryalgeb, multiplereduct, multiplefilter, multiplegenr,
  structureaccess, structurebuild, indexchange, bufferaccess, bufferbuild,
  bufferreduct, buffergenr, bufferdefine, controlabstr, functioninvoke,
  graphnode, unclassified, unknown
} ndclasstype;




/*#TITLE  IF1INIT VARIABLES         IFNAug83   Standard IF1 Variables*/

extern printable nodename[ifmaxnode + 1];

extern printable errvname[ifmaxerror + 1];

extern printable typename[ifmaxtype + 1];

extern printable basename[ifmaxbasic + 1];

extern printable graphname[19];

extern ndclasstype nodeclass[ifmaxnode + 1];   /* dlz - 8/87 */





/*#TITLE  IF1INIT ROUTINES          IFNAug83   Standard IF1 Routines*/

extern Void initnames PV();


/* FILUTL depends on STRUTL,
   Include fourth in .makeo files */


/* copyright (C) 1986 by the Regents of the University of California */

/* FILUTL depends on STRUTL,
   Include fourth in .makeo files */
/*filutl has no consts*/



extern long startclock, startsysclock;




/* copyright (C) 1986 by the Regents of the University of California */


extern long creat PP((Char *name, long mode));

extern long open PP((Char *name, long mode));

extern long close PP((long fildes));

extern Void exit_ PP((long code));

/*#TITLE  FILUTL  ROUTINES        Jul83   File Handling Routines.*/

/*
**  Code for BuildName and Splitname tends to be common to all systems
*/

extern Void buildname PP((stryng *newname, stryng dev, stryng name,
			  stryng ext));


extern Void splitname PP((stryng *origname, stryng *dev, stryng *name,
			  stryng *ext));

extern Void defaultfilename PP((stryng *name, stryng *defname));

/*
**  The rest of the functions tend to be system specific
*/





extern boolean openread PP((FILE **fil, stryng *nom));

extern boolean openintread PP((FILE **fil, stryng *nom));

extern Void starttimer PV();

extern Void recordtime PV();

extern boolean canread PP((stryng *nom));

/* procedure CloseRead( var Fil: Text ); is a no-op on Unix*/



extern boolean openwrite PP((FILE **fil, stryng *nom));

extern boolean canwrite PP((stryng *nom));

/* procedure CloseWrite( var Fil: Text ); is a no-op on Unix*/



extern Void flushwrite PP((FILE **fil));


/* procedure Page( var Fil: Text ); is defined on unix */

extern Void gettermline PP((stryng *termline, stryng *termtext));

extern Void getcommandline PP((stryng *cmdline));

extern Void dfexit PV();





/* PARUTL depends on STRUTL, FILUTL,
   Include fifth in .makeo files   */


/* copyright (C) 1986 by the Regents of the University of California */

/* PARUTL depends on STRUTL, FILUTL,
   Include fifth in .makeo files   */

/* PARUTL TYPESApril 84Parameter Handling Constants*/

#define maxinfile       9

#define parflagchar     "-"
#define parsepchar      " "
#define parsplitchar    " "
#define parargchar      " "



/*#TITLE  PARUTL  TYPES           Jan82   Parameter Handling Routines.*/

typedef enum {
  intpar, boolpar, strpar, ifilpar, ofilpar, flagpar, restpar
} partyp;
typedef struct parrec *infilelist[maxinfile];

typedef struct parrec {
  str10 longname, shortname;
  partyp partype;
  long normpos, specpos;
  stryng parvalue;
  struct parrec *nextpar;
} parrec;



extern FILE *source, *diag;
extern infilelist infile;
extern parrec *outfile;
extern boolean timingflag;




/*#TITLE  PARUTL  ROUTINES        Oct82   Parameter Handling Routines.*/

extern parrec *defineparameter PP((parrec **parlist, Char *long_,
				   Char *short_, partyp parsort, long pos1,
				   long pos2));

/*macro procedure InitParameter( Param: ParRef ); */

extern Void setparameter PP((parrec *param, stryng *paramvalue));

/*macro function ParamSet( Par: ParRef ): Boolean; */

/*macro procedure StrParValue( var Str: Stryng; Par: ParRef ); */

extern boolean boolparvalue PP((parrec *par));

extern long intparvalue PP((parrec *par));

extern Char gettoken PP((stryng *token, stryng *cmd));

extern boolean parsecommandline PP((parrec *parlist));


extern Void getparamvalue PP((parrec *param, stryng prompt));


extern Void defaultext PP((stryng *name, stryng *oldname, Char *ext));


extern Void askparam PP((parrec *par, Char *prompt));


extern Void askordefault PP((parrec *par, stryng *def, int inter,
			     Char *prompt));

extern Void readcommandline PP((parrec **infile, parrec **outfile,
				parrec **paramlist, boolean *timingflag));

extern boolean openinputfile PP((stryng *filename, FILE **source));

extern boolean openoutputfile PP((stryng *filename, FILE **source));

extern boolean openlistingfile PP((stryng listfilename, FILE **list));


extern boolean openuncompfile PP((stryng uncompfilename, FILE **uncomp));


/* Graph.m4 depends on STRUTL, IF1INIT, SETUTL.
   Include sixth in the .makeo file      */



/* copyright (C) 1986 by the Regents of the University of California */

/* Graph.m4 depends on STRUTL, IF1INIT, SETUTL.
   Include sixth in the .makeo file      */



/*dlz - 8/87 added new functions: NewTypeAlloc, NewEdgeAlloc, and
  NewNodeAlloc to consolidate and replace various allocation and
  initialization sequences throughout.  Also, made compilation
  of vivek's extra edge and node fields conditional.  Some new
  macros, etc. for simplification, fixed errors in some existing
  macro definitions, general "cleanup" and correction */


/* Constants from graph.m4 */
/* The number of the first Atomic node sort */

#define firstatom       100

/* The maximum number of Type Table Entries handled */
#define entrymax        1000

/* Constant for internal pragmas (for Vivek) */
#define extrainfomax    15

/* for Bit Marks set in node record */
#define maxbitrange     29



/* Types from graph.m4 */
/* Type Table Entries
      STId -a special value used for dumping out if1 programs and
              for checking multiple definitions.
      STLabel - The label of the IF1 type entry.  Also used for type
                smashing.
      STEquivChain - Used for type smashing.
      STLiteral - The name of the type (if there is one).
      STSize - Amount of memory an object of this type requires. Used
               in IF1offset.
      STRecurFlag - Whether or not this type is recursive.
*/


typedef struct stentry {
  long stid, stlabel;   /*sks*/
  struct stentry *stequivchain;   /*sks*/
  stryng stliteral;   /*mlw*/
  long stsize;
  boolean strecurflag;   /*jef 10/1/85*/
  char stsort;
  union {
    char stbasic;
    struct {
      struct stentry *starg, *stres;
    } U3;
    struct stentry *stbasetype;
    struct {
      struct stentry *stelemtype, *stnext;
    } U2;
  } UU;
} stentry;


typedef double extrainfo[extrainfomax];   /*for vivek*/

/* Ports
   Each node has a list of input and output ports.  A single structure is
   used for Literals and Edges.  Edges have some extra fields descibing
   the source Port.  The fields are used as follows:
     PTType - points to a symbol table entry giving the type of the
                port.
     PTToNode - points to the node which is destination of the edge or
                literal.
     PTToPort - gives the number of this port.
     PTToNext - points to the next input port for the destination node.
     PTName - gives the a symbolic name associated with this edge (if avail.)
     PTIF1Line - the line number of the if1 file that defined this edge.
     PTSrcLine - the line number of the SISAL text file where this edge is
                 created.
     PTWiLine - the column of the SISAL text file where this edge is
                 created.
     PTId - Global ID for this edge.  Does not correspond to anything in
            the IF1 test file.
     PTMark - ByValue, ByReference or Destroy pragma.
               Destoy means this is the last reference and the value may be removed.
     PTDFAddr - AR offset pragma.
     PTLBound, PTUBound - lower and upper bound pragma.
     PTNextEdge - Used by DI for associating similar edges.
     PTClass - ???
   Extra fields for Edges:
     PTFrNode - points to the origin node.
     PTFrPort - indicates the number of the output port.
     PTFrNext - points to the next output port for the origin node.
   Extra fields for Literals:
     PTLitValue - value of the literal edge stored in Stryng format.
 */

typedef enum {
  byref, byval, destroy
} egmark;   /***NEW** no ByDefault*/

typedef enum {
  ptlit, ptedge, ptdep, ptundef
} portsort;

typedef enum {
  pcuncoded, pccoded
} portclass;


/*mlw - more descriptive name*/

typedef struct port {
  stentry *pttype;
  struct node *pttonode;
  long pttoport;
  egmark ptmark;   /*mlw  - pass by value or reference */
  long ptif1line;   /* sks for structure analysis reporting */
  long ptsrcline, ptwiline;
  struct port *pttonext;
  stryng ptname;   /*mlw*/
  long ptid;   /*mlw*/
  long ptlbound, ptubound;   /* mlw, lower and upper bounds pragmas */
  long ptsetrc, ptconmodrc, ptprodmodrc;
      /* rjs, set & modify ref count pragmas */
  long ptdfaddr, ptmraddr;   /* dlz, for MinReeval offsets */
  struct port *ptnextedge;
  portclass ptclass;

  portsort ptsort;
  union {
    struct {
      struct node *ptfrnode;
      long ptfrport;
      struct port *ptfrnext;
    } U1;
    stryng ptlitvalue;
  } UU;
} port;

/* Graphs
   Each compound node has a list of subsidiary graphs. Each graph is
   accessed via the special Graph node.
 */


typedef struct graph {
  struct node *grnode;
  struct graph *grnext;
} graph;

/* Nodes
    Nodes are either Simple nodes, Compound nodes, or Graph nodes.
    Further, a Graph node may be a Function graph (in which case it
    has an associated Linkage record) or a subgraph of a compound node.

    NDId - A global identifier with no counterpart in IF1 text files.
    NDCode - The opcode of this node, e.g. IFNPlus, IFNSelect, IFNGraph.
    NDMisc - an integer (or set of bits) for miscellaneous use.
    NDLabel - Label of the node within a graph.  Graph nodes always have
              a label of zero.
    NDLine - Line number in the IF1 text file where this node was defined.
    NDSrcLine - Line number within the SISAL text file that defined this
                node.
    NDWiLine - column number in SISAL text file where this node was defined.
    NDXCoord, NDYCoord - (X,Y) coordinate pargmas
    NDParent - If the node is Simple or Compound then Parent is the
               graph node corresponding to the graph immediately containing
               this node.  If the node is a Graph node representing a
               subgraph of a compound node the Parent is the compound
               node.If the node is a Function graph node then the
               parent is the dummy compound node called "Module".
    NDNext - The nodes of a graph are connected in a linked list.  This
             field points to the next node in the list.  The NDNext
             fields of Graph nodes point to the first (simple or compound)
             node of the graph it defines.
    NDNextInLine - A pointer to the next node of the IF1 graph that
                   came from the same source line.  Used by DI.
    NDIList - A pointer to the list of input edges of the node.  CAUTION:
              No fan-in is allowed.  Therefore, the input edges of a
              GRAPH node are the edges where the values LEAVE the graph.
    NDOList - A pointer to the list of output edges of the node.  On a
              GRAPH node, these are the edges where values ENTER the graph.
    NDDepIList - A pointer to the list of dependence edges that are input
              to the node.  NOTE: there can be fan-in of dependence edges.
              The input port of all dep edges is port 0.
    NDDepOList - A pointer to the list of dependence edges that are output
              by the node.  The output port of all dep edges is port 0.
 Fields for Graph nodes only:
    NDLink - A pointer to the Linkage record if this node represents a
             function graph node.
    NDType - A pointer into the type table used only for Function graph
             nodes.  Subgraphs of Compound nodes have a nil type.
 Fields for Compound nodes only:
    NDSubsid - a pointer to a list of subgraphs.
    NDAssoc - a pointer to an association list used to associate tag
              numbers with subgraphs of a TAGCASE nodes.
*/


typedef struct assoclist {
  long graphnum;
  struct assoclist *next;
} assoclist;

typedef enum {
  ndatomic, ndgraph, ndcompound, ndundef
} nodesort;



typedef union intbitset {
  long numb;
  long bits;
} intbitset;

typedef struct node {
  long ndid, ndcode;
  intbitset ndmisc;   /* dlz (new) -- for miscellaneous uses */
  long ndlabel;   /* sks for structure analysis reporting */
  long ndline;   /* sks for structure analysis reporting */
  long ndsrcline, ndwiline;   /* mlw, Source Line and Within Line markers */
  long ndxcoord, ndycoord;   /* mlw, X and Y coordinates - graphics */
  struct node *ndparent, *ndnext;
  port *ndilist, *ndolist, *nddepilist, *nddepolist;
  struct node *ndnextinline;
  double ndfrequency;   /*rjs, pragma for vivek */
  long ndexpanded;   /* rjs, pragma for vivek */

  nodesort ndsort;
  union {
    struct {
      struct linkrec *ndlink;
      stentry *ndtype;
      long ndfirstmro, ndlastmro;   /* dlz, added for MR */
    } U1;
    struct {
      graph *ndsubsid;
      assoclist *ndassoc;
    } U2;
  } UU;
} node;

/* Linkage Records
   Each Function in a compilation unit has a record associating the
   appropriate Graph node with a string used to identify the function
   in literals.
   LKSort - Is it a Local (G), Imported (I), or Exported (X) function.
   LKGraph - a pointer to the Function graph node.
   LKName - The name of the function.
   LKModuleName - Name of the Module this function resides in
   LKARSize - Number of DATUMS in an AR for this function (pragma).
   LKMRSize - Number of Datums in an MRV for this function (someday a pragma?)
   LKExpand - Marked to be expanded inline or not (pragma).
   LKARIndex - a field for DI internal use.
   LKNext - pointer to the next linkage record in this module.
 */

typedef enum {
  lslocal, lsimported, lsexported
} linksort;

typedef struct linkrec {
  linksort lksort;
  node *lkgraph;
  stryng lkname, lkmodulename;
  long lkarsize;   /*mlw - Size of activation record for this fun*/
  long lkmrsize;   /*dlz - Size of MR value record for this fun */
  boolean lkexpand;   /*mlw - Is this function inline expandable? */
  long lkarindex;
  struct linkrec *lknext;
} linkrec;




/* these vars are needed by module using the graph */
extern stentry *typetable[entrymax];
extern long tthwm;   /* symbol table high water mark */
extern long univmodulecnt, univnodecnt, univedgecnt;
extern linkrec *funclist;
extern node *firstfunction, *module;
extern stryng stamp['[' - 'A'];
extern long stampset[9];






extern stentry *newtypealloc PP((int sort));

extern port *newedgealloc PP((portsort sort));

extern node *newnodealloc PP((nodesort sort));


extern Void initstamps PV();

extern Void removestamp PP((int ch));

extern Void addstamp PP((int ch, stryng str));

extern boolean stampisset PP((int ch));

extern boolean stampismissing PP((int ch));


/* The following function give information about Nodes */

/* macro function NodeId ( gnode : NDPtr) : integer; */

/* macro function IsSimple( N: NdPtr ) : boolean */

/* macro function IsCompound( N: NdPtr ) : boolean */

/* macro function IsGraph( N: NdPtr ) : boolean */

/* macro function IsEmptyGraph( N: NdPtr ) : boolean */
/* IsEmptyGraph returns true if the graph has no internal nodes
   Assumes:(graph^.NDSort = NDGraph)       */

/*macro function IsLastNodeInGraph( N: NdPtr ) : boolean */

/*macro function NotEndOfGraph( N: NdPtr ) : boolean */

/*macro function IsFirstNodeInGraph( N: NdPtr ) : boolean */
/* assumes N <> nil */

extern long numbofsubgraphs PP((node *cnode));

extern long numbnodesingraph PP((node *gnode));

extern Void directancestors PP((node *n, setofint *nodesabove));

/* macro procedure NameOfGraph( var S: stryng; G: NdPtr ) */

/* macro function NumbOfAlternatives( N: NDPtr ) : integer */
/* NumbOfAlternatives assumes (N^.NDSort = NDCompound)
 One child graph is the selector graph, the others are Alternatives */

/* macro function NodeKind( N: NDPtr ) : integer */

extern long numberofwiredinputports PP((node *n));

extern long numberofwiredoutputports PP((node *n));

extern long largestinputportnumber PP((node *n));

extern long largestoutputportnumber PP((node *n));

extern long nodelabel PP((node *n));

/* macro function FunctionKind( F : NDPtr ) : LinkSort; */


/* macro function IsLocalFunction( fungraph: NDPtr) : boolean; */
/* Assumes fungraph <> nil and fungraph is a function graph */

/* macro function IsGlobalFunction( fungraph: NDPtr) : boolean; */
/* Assumes fungraph <> nil and fungraph is a function graph */

/* The following functions give information about edges */

/* macro function IsEdge( E: EGPtr ) : boolean */

/* macro function IsLiteral( E: EGPtr ) : boolean */

/* macro function IsDependence( E: EGPtr ) : boolean */


extern boolean isboundaryedge PP((port *e));

/* macro function EdgeId( E: EGPtr ) : integer */

/* macro procedure NameOfEdge( var S: stryng; E: EGPtr ) */

/* macro procedure ValueOfLiteral( var S: stryng; E: EGPtr ) */

/* macro function ValueOfSetRC( E : EGPtr ) : integer; */

/* macro function ValueOfModRC(E : EGPtr ) : integer; */

/* macro function ValueOfProdRC(E : EGPtr ) : integer; */

/* macro function ConsumerNodeOfEdge( E : EGPtr ) : NDPtr; */

extern node *producernodeofedge PP((port *e));

/* macro TypeOfEdge( E: EGPtr ) : STPtr */

/* macro DataSizeOfEdge( E: EGPtr ) : real */

/* macro SetDataSizeOfEdge( E : EGPtr; Value : real ); */

/* macro CardinalityOfEdge( E: EGPtr ) : real */

/* macro SetCardinalityOfEdge( E : EGPtr; Value : real ); */

/* macro SetCommOfEdge( E : EGPtr; Value : boolean); */

/* macro IsEdgeCommunicated( E : EGptr) : boolean;  */


/* macro SetRCOfEdge( E : EGPtr; Value : integer); */

/* macro SetProdModRCOfEdge( E : EGPtr; Value : integer); */

/* macro SetConModRCOfEdge( E : EGPtr; Value : integer); */

extern long producerportnumber PP((port *e));

/* macro ConsumerPortNumber( E: EGPtr ) : integer */
/* Assumes E <> nil */

/* The following functions are used to traverse the graph */

extern node *tonamedgraph PP((stryng name));

/* macro function ToFirstNodeInGraph( N: NdPtr ) : integer */
/* toFirstNodeInGraph assumes (graph^.NDSort = NDGraph)
 returns the first scheduled to be executed in this graph,
 if the Graph is empty thein it returns nil       */

/* macro ExecTimeOfNode( N : NDPtr ) : real */

/* macro SetExecTimeOfNode( N : NDPtr; Value : real ); */

/* macro ProcNumberOfNode( N : NDPtr ) : integer */

/* macro SetProcNumberOfNode( N : NDPtr; Value : integer ); */

/* macro SchedNumberOfNode( N : NDPtr ) : integer */

/* macro SetSchedNumberOfNode( N : NDPtr; Value : integer ); */

/* macro FrequencyOfNode( N : NDPtr ) : real */

/* macro SetFrequencyOfNode( N : NDPtr; Value : real ); */

/* macro IsNodeExpanded( N : NDPtr) : boolean; */

/* macro SetExpandedValueOfNode(N : NDPtr; Val : boolean); */


extern node *tolastnodeingraph PP((node *n));

/*macro function ToNextNode( N: NdPtr ) : NdPtr */
/* ToNextNode assumes gnode <> nil
   Returns next node in this graph to be executed,
   returns nil if no next node*/

extern node *toprevnode PP((node *n));

/*macro ToEnclosingGraph( GNode: NdPtr ) : NdPtr */
/* ToEnclosingGraph assumes gnode <> nil and ( not (gnode^.NDSort = NDGraph))
 returns a pointer to the graphnode surrounding this one. */

/*macro function N: NdPtr ^.NDNext : NdPtr */
/* ^.NDNext assumes gnode <> nil
   Returns next node in this graph to be executed,
   returns nil if no next node*/

/*macro function ToFirstChildGraph( cnode : NDPtr) : NDPtr */
/* Assumes (cnode^.NDSort = NDCompound), with at least one subgraph.
   Result is a pointer to first subgraph of this compound node.  rky 8/87 */

extern node *tonextchildgraph PP((node *child));

extern node *tochildgraph PP((node *cnode, long gindex));


extern node *toenclosingcompound PP((node *gnode));

extern node *toenclosingfunction PP((node *n));

extern node *toinitgraph PP((node *n));

extern node *tobodygraph PP((node *n));

extern node *totestgraph PP((node *n));

extern node *toreturnsgraph PP((node *n));

extern node *toiterbodygraph PP((node *n));

extern node *toselectorgraph PP((node *n));

extern node *toalternativegraph PP((node *n, long i));

extern node *toforallgeneratorgraph PP((node *n));

extern node *toforallbodygraph PP((node *n));

extern node *toforallreturnsgraph PP((node *n));

extern node *totagcasesubgraph PP((node *t, long tagnum));

/* macro function NumberOfPredicates( C : NDPtr ) : integer */
/*C is an IfThenElse node.  Returns the number of predicate subgraphs */

/* macro function ToNthPredicateGraph( C : NDPtr; N : integer ) : NDPtr */
/*C is an IfThenElse node, N = 1, 2, ....      */
/*Returns a pointer to the N'th predicate subgraph      */

/* macro function ToNthTrueGraph( C : NDPtr; N : integer ) : NDPtr */
/*C is an IfThenElse node, N = 0, 1, ....      */
/*Returns a pointer to the N'th true subgraph      */

/* macro function ToFalseGraph( N : NDPtr ) : NDPtr */
/* N is an IfThenElse node.Returns a pointer to the false subgraph */

extern port *getinputedge PP((node *n, long portnum));

extern port *getoutputedge PP((node *n, long portnum));

extern port *nextoutputedgesameport PP((port *e));

/* Assumes N <> nil */

/* Assumes N <> nil */

/* Assumes E <> nil */

/* Assumes N <> nil */

/* Assumes N <> nil */

/* Assumes E <> nil */

/* dlz - 8/87 instead of for-loops */
/* over port range      */


extern port *nextinputedgenextport PP((port *e, long p));

extern port *nextoutputedgenextport PP((port *e));


extern port *inputedgegeport PP((node *n, long p));

extern port *outputedgegeport PP((node *n, long p));

extern node *getnodewithlabel PP((node *n, long l));

extern node *getnodewithid PP((node *f, long id));

extern node *tonextfunction PP((node *f));

/* Functions used to examine and add to the type table */

/* macro function NameOfType( T: STPtr ) : Stryng */

/* macro WhichEntryType( S: STPtr ) : STENtry */

/* macro WhichBasicType( S: STPtr ) : STPtr */

/* macro function TypeOfGraph( G : NDPtr ) : STPtr; */


/* macro function BaseOfMultipleType( M: STPtr ) : STPtr; */


/* macro function BaseOfArrayType( M: STPtr ) : STPtr; */


/* macro function BaseOfTupleType( M: STPtr ) : STPtr; */


/* macro function BaseOfBufferType( M: STPtr ) : STPtr; */


/* macro function BaseOfStreamType( S: STPtr ) : STPtr; */


/* macro function GetFirstFunRes( N: NDPtr ) : STPtr; */


/* macro function GetFirstFunArg( N: NDPtr ) : STPtr; */


extern stentry *getnextfunarg PP((stentry *s));

extern stentry *getnextfunres PP((stentry *s));

extern long numberoffunargs PP((stentry *t));

extern long numberoffunres PP((stentry *t));

/* Return the type of the Nth function input argument */
extern stentry *typeofnthfunarg PP((stentry *f, long n));

/* Returns the type of the Nth function output argument */
extern stentry *typeofnthfunres PP((stentry *f, long n));

extern long largestfieldnumberofrecord PP((stentry *r));

/* Pre:  R is a RECORD type entry and N is an integer greater
        than or equal to zero.
  Post: The type and name of the Nth field ofrecord R are placed in
        FType and FName.
  Note:  If R is not a record entry, or N < 0, or N > the largest
         field number defined for this record (using a zero based
         numbering scheme) then Nil is placed in FType and FName is
         empty
*/
extern Void typeandnameofnthfield PP((stentry *r, long n, stentry **ftype,
				      stryng *fname));

/* Pre:  R is a RECORD type entry and N is an integer greater
        than or equal to zero.
  Post: The type of the Nth field ofrecord R is returned
  Note:  If R is not a record entry, or N < 0, or N > the largest
         field number defined for this record (using a zero based
         numbering scheme) then Nil is returned.
*/
extern stentry *typeofnthfield PP((stentry *r, long n));

/* Returns the number of Tags defined for this Union type */
extern long largesttagnumberofunion PP((stentry *u));

/* Pre:  U is a UNION type entry and N is an integer greater
        than or equal to zero.
  Post: The type of the Nth tag of the union type U is placed in TType and
        the name of the Nth tag is placed in TName.
  Note:  If U is not a union entry, or N < 0, or N > the largest
         tag defined for this union then TType = nil and TName is
         empty.
*/
extern Void typeandnameofnthtag PP((stentry *u, long n, stentry **ttype,
				    stryng *tname));

/* Pre:  U is a UNION type entry and N is an integer greater
        than or equal to zero.
  Post: The type of the Nth tag of the union type U is returned
  Note:  If U is not a union entry, or N < 0, or N > the largest
         tag defined for this union then Nil is returned.
*/
extern stentry *typeofnthtag PP((stentry *u, long n));

/* The following is a collection of functions that allow run-time additions
   to the Type Table.  Entries are constructed, then smashed into the table
   before being assigned to data objects.
 */

/*macro function MakeFunctionType () : STPtr;*/

/*macro function MakeRecordType () : STPtr;*/

/*macro function MakeUnionType () : STPtr;*/


extern stentry *searchtypetable PP((int kind, stentry *x, stentry *y,
				    stryng name));


extern Void addfunargtype PP((stentry *f, stentry *arg));

extern Void addfunrestype PP((stentry *f, stentry *res));

/* -------------------------------------------------------------------- */
/* --------------------------- SmashTypes ----------------------------- */
extern Void smashtypes PV();

/* --------------------------- SmashTypes ----------------------------- */
/* -------------------------------------------------------------------- */

extern Void adjustgraphptrs PV();

extern Void compacttypetable PP((long *tthwm, long oldtthwm));

extern stentry *getbasictype PP((int base));

extern stentry *getwildtype PV();

extern stentry *getconstructortype PP((int kind, stentry *base));


extern Void addfieldtype PP((stentry *r, stentry *fld));

extern Void addtagtype PP((stentry *u, stentry *tg));

extern Void putintable PP((stentry **typ));

extern stentry *addtotypetable PP((stentry *typ));

/* Construct a function type definition for the given graph
   and add the definition to the global type table.
   NOTE:  Unused ports get defined as wild types.
 */
extern stentry *makefuntypefromgraph PP((node *g));

/* Functions that read and set pragma values */




/* GetEdgeBounds( E : EGPtr; var Lo, Hi : integer );   Assumes E <> nil */


/* macro function GetSourceLine( N: NDPtr ) : integer assumes N <> nil */

/* macro function GetWithinLine ( N : NDPtr) : integer; Assumes N <> nil */

/* macro function EdgeMark( E: EGPtr ) : EGMark */

/* macro procedure SetEdgeMark( var E: EGPtr ; M: EGMark */

/* macro function IsInlineExpandable( fungraph: NDPtr) : boolean; */
/* Assumes fungraph <> nil and fungraph is a function graph */

/* macro procedure SetInlinePragma( fungraph: NDPtr; V: boolean ); */
/* Assumes fungraph <> nil and fungraph is a function graph */



/* Functions needed specifically by the interpreter (DI) */

extern Void linkcallnodetofunction PP((node *cnode, node *fgraph));

extern node *tocalledgraph PP((node *callnode));

/* macro function NumbFunLocals( F: NdPtr ) : integer */
/* NumbFunLocals assumes funnode is the graph node of a function */

/* macro procedure SetNumbFunLocals( F: NdPtr, n: integer ) */
/* SetNumbFunLocals assumes funnode is the graph node of a function */

/* macro function DatumAddr ( E : EGPtr) : integer; */
/* Assumes E is not nil */

/* macro procedure SetDatumAddr( E: EGPtr, n: integer ) */
/* SetDatumAddr assumes E is not nil */

/* macro function MRDatumAddr ( E : EGPtr ) : integer */

/* macro procedure SetMRDatumAddr( E : EGPtr, N : integer ) */


/* ^.NDLink^.LKARIndex :=  assumes F <> nil and F points to a function graph */


/* ^.NDLink^.LKARIndex assumes F <> nil and F points to a function graph */

/* macro function NextSimilarEdge( E : EGPtr ) : EGPtr; */

/* macro procedure LinkToSimilarEdge( List, NewLink : EGPtr ); */

/* macro function NextNodeInLine( N : NDPtr ) : NDPtr; */

/* macro procedure LinkToNextNodeInLine( List, NewLink : NDPtr ); */

/* macro procedure SetFunctionModule( F : NDPtr; Name : Stryng ); */

/* macro procedure ModuleNameOfFunction( var Name : Stryng; F : NDPtr); */

/******************************************************************/
/* These function must come last in the files due to dependencies */

extern ifgraphtype graphkind PP((node *g));

extern char reductionop PP((node *n));

extern Void loopranges PP((node *c, long *k, long *l, long *t));

extern long fanout PP((node *n, long portnum));





/* copyright (C) 1986 by the Regents of the University of California */


/*graph2 has no consts, types or vars*/



/* Graph2.m4 contains graph routines that alter the structure of the
   graph and are only used by some of the optimization routines.
   These were removed from the graph.m4 file since they are "Special"
   and not everyone needs them. */

/*dlz - 8/87 updated to use new allocation routines in graph.m4,
  some cleanup, ***still confusion/glitch (?) in CopyEdges, CopyGraph*/


/*in out*/
/* ----------------------------------------------------
   DisconnectEdgeFromSource
        - Completely unlinks E from it's source node's
          output edge list
        - nills out all pointer fields having to do with
          it's source node.
   ---------------------------------------------------- */
extern Void disconnectedgefromsource PP((port *e));

/*in out*/
/* -------------------------------------------------------
   DisconnectEdgeFromDest
       - Unlinks E from it's destination node's input list
       - nills out all pointer fields having to do with
         E's destination node
   ------------------------------------------------------- */
extern Void disconnectedgefromdest PP((port *e));

/* -------------------------------------------------
   RemoveEdge
       - Removes E from graph leaving graph valid
       - nills out all pointer fields
       - returns pointer to completely unlinked edge
   ------------------------------------------------- */
extern Void removeedge PP((port **e));

extern Void removeinputedges PP((node *n));

/* macro procedure ChangeEdgeName( E : EGPtr; S : Stryng ) */

/* macro procedure ChangeLiteralValue( E : EGPtr; S : Stryng ) */

/*  Remove Node :
      - if N is a compound node it removes the subgraphs first.
      - removes all input edges
      - removes all output edges
      - completely disconnects N from the graph
*/
extern Void removenode PP((node *n));

/* Create a Simple node with the opcode given.
   The new node will have no input or output edges and will
   not be connected to any graph.
 */
extern node *createsimplenode PP((long opcode));

/* Create a Compound node with the opcode given.
   The new node will have no input or output edges and will
   not be connected to any graph.
 */
extern node *createcompoundnode PP((long opcode));

/* Inserts NewNode into graph of ParentNode after PrevNode.
   If Prevnode = nil then the NewNode is inserted as the first
   in the graph headed by ParentNode.
 */
extern Void insertnode PP((node *parentnode, node *prevnode, node *newnode));

/* -----------------------------------------------------------------
   Step 1  Removes E from it's current destination node's input list
           ( if it is in one) and
   Step 2  Adds it to NewDestNode's input list at port number
           NewDestPort
   NOTE:   This operation may cause Fan-In.
   ----------------------------------------------------------------- */
extern Void changeedgedest PP((port *e, node *newdestnode, long newdestport));

/* -----------------------------------------------------------------
   Step 1  Removes E from it's current source node's output list
           ( if it is in one) and
   Step 2  Adds it to NewSrcNode's input list at port number
           NewSrcPort
   ----------------------------------------------------------------- */
extern Void changeedgesrc PP((port *e, node *newsrcnode, long newsrcport));

extern port *insertedge PP((node *fromnode, long fromport, node *tonode,
			    long toport, stentry *etype, stryng name));

extern port *insertliteral PP((node *tonode, long toport, stentry *etype,
			       stryng lvalue, stryng lname));

/* Walks the graph G renumbering then nodes as it comes to them.
   If Recurse = true then it recursively renumbers the
   subgraphs of the compound nodes of G otherwise, it simple
   renumbers the nodes of G.
 */
extern Void renumbergraph PP((node *g, int recurse));

/* Assumes N <> nil and not IsGraph(N) */
/* Inserts the node InTransit in front of the node N */
extern Void putnodebefore PP((node *n, node *intransit));

/* Shifts the port numbers of the input edges of N, starting from
   port StartPort and shifting by Amount.
 */
extern Void shiftinputports PP((node *n, long startport, long amount));

/* Shifts the port numbers of the output edges of N, starting from
   port StartPort and shifting by Amount.
 */
extern Void shiftoutputports PP((node *n, long startport, long amount));

extern node *copygraph PP((node *oldg));

extern node *copycompound PP((node *oldn));

/* Create and return a new node identical to N except without any
   input or output edges and detached from any surrounding graph.
   N is not changed in any way.
   If N is a graph node or a compound node, it copys the graph
   structure or the entire compound node.
 */
extern node *copynode PP((node *n));

/* This routine links the node into the graph pointed to by
   Parent after the node Prev.  It then changes the Labels
   of all the nodes from this point on to avoid having two
   nodes in the graph with the same Label.
   Note:  Assumes the graph is ordered.
   Note:  if prev = nil then adds N as the first node in the graph.
 */
extern Void linknodeintograph PP((node *n, node *parent, node *prev));

/* macro procedure ChangeEdgeType( E : EGPtr; T : STPtr ); */
/* Changes the type of the edge E to T */


/* macro procedure ChangeNextNode( CurrentNode, NextNode : NDPtr ); */
/* Assumes CurrentNode <> nil */


/* Disconnects the given function from the environment and
 removes all its nodes.  */
extern Void removefunction PP((node *fungraph));




extern Void cleanupnewiter PP((node *loop));


extern Void cleanupiterloop PP((node *loop));

extern Void cleanupselect PP((node *n));

extern Void cleanuptagcase PP((node *n));

extern Void cleanupifthenelse PP((node *n));

extern Void cleanupgraph PP((node *g));


extern Void removedeadcode PP((int messageson));

extern Void removenoop PP((node *g));

extern Void pushliteralsinside PP((node *n));

extern Void swapinputports PP((node *n, long p1, long p2));

extern Void swapoutputports PP((node *n, long p1, long p2));

extern Void compactports PP((node *c));

extern Void replacecallwithgraph PP((node **cnode, node *fgraph));

extern Void replacefunctiongraph PP((node *newfg, node *oldfg));


#define stacksize       300

#define ident           "$Header: offset.m4,v 1.2 86/05/22 10:05:00 welcome Exp $"


/* Local variables for asgnar: */
struct LOC_asgnar {
  long specialsizenodes[ifmaxnode / 32 + 2];
  long specialnodes[ifmaxnode / 32 + 2];
  port *stack[stacksize];
  short stackptr;
} ;

Local Void moveup PP((port *e, struct LOC_asgnar *LINK));
Local Void movedown PP((port *e, struct LOC_asgnar *LINK));

/* ----------------------------------------------------------------- */

Local Void initoffsets(g, LINK)
node *g;
struct LOC_asgnar *LINK;
{
  /* Initialize all edges in the graph to have offsets of -1 */
  long gnum;
  node *n;
  port *e;
  long FORLIM;

  n = g;
  while (n != NULL) {
    /* init the input edges of N */
    e = n->ndilist;
    while (e != NULL) {
      e->ptdfaddr = -1;
      e = e->pttonext;
    }
    if (n->ndsort == ndcompound) {
      FORLIM = numbofsubgraphs(n);
      for (gnum = 0; gnum < FORLIM; gnum++)
	initoffsets(tochildgraph(n, gnum), LINK);
    }
    n = n->ndnext;
  }
}  /* InitOffsets */

Local Void insertnoop(g, e)
node *g;
port *e;
{
  /* -----------------------------------------------------------
     Looks at last node in graph G
       - if G empty or last node <> NoOp then insert a NoOp node
         otherwise the last node is already a NoOp.
       - Change the destination of E so that it is connected to
         this noop node at the first available input port.
       - Add a new edge from this NoOp node to the graph
         boundary where E used to be connected.  Give this
         edge the same name and type as E
       - Works for either Literals or Edges
     ------------------------------------------------------------ */
  port *newedge;
  node *newnode, *prev;
  boolean insert;
  stryng ename;
  stentry *etype;
  long toport, newport;

  prev = tolastnodeingraph(g);
  if (prev == NULL)
    insert = true;
  else if (prev->ndcode != ifnnoop)
    insert = true;
  else
    insert = false;
  if (insert) {
    newnode = createsimplenode((long)ifnnoop);
    insertnode(g, prev, newnode);
    newport = 1;
  } else {
    newnode = prev;
    newport = largestinputportnumber(newnode) + 1;
  }
  ename = e->ptname;
  etype = e->pttype;
  toport = e->pttoport;
  changeedgedest(e, newnode, newport);
  memcpy(e->ptname.str, blankstring, sizeof(stryngar));
  e->ptname.len = 0;
  newedge = insertedge(newnode, newport, g, toport, etype, ename);
}  /* InsertNoOp */

Local Void checkliteral(e, g)
port *e;
node *g;
{
  /* There are certain cases when a NoOp node must be inserted between */
  /* a literal and the input ports of a Graph node.  If this is not    */
  /* done, the address of the literal would, in certain cases be the   */
  /* same as an edges in a different subgraph and the value may be     */
  /* changed.  Literals are supposed to be constant.                   */
  switch (graphkind(g)) {

  case ifgfunction:
  case ifgselector:
  case ifgloopatest:
  case ifgloopbtest:
  case ifgforallbody:
  case ifgifpredicate:   /* literals ok */
    break;

  case ifgvariant:
  case ifgloopareturns:
  case ifgloopbreturns:
  case ifgalternative:
  case ifgloopainit:
  case ifgloopbinit:
  case ifgforallgenerator:
  case ifgforallreturns:
  case ifgloopabody:
  case ifgloopbbody:
  case ifgiftrue:
  case ifgiffalse:
  case ifgiterbody:
    insertnoop(g, e);
    break;
  }/* case */
}  /* CheckLiteral */


Local Void checkedge(e, g)
port *e;
node *g;
{
  /* As mentioned above, a direct edge from the import to the outport */
  /* of a subgraph may cause input and output edges of the surrounding*/
  /* compound node to have the same address.                          */
  long portnum, k, l;

  switch (graphkind(g)) {

  case ifgfunction:
  case ifgselector:
  case ifgloopatest:
  case ifgloopbtest:
  case ifgforallbody:
  case ifgifpredicate:   /* direct edges ok */
    break;

  case ifgforallgenerator:
  case ifgforallreturns:
  case ifgiftrue:
  case ifgiffalse:
  case ifgloopainit:
  case ifgloopbinit:
  case ifgloopareturns:
  case ifgloopbreturns:
  case ifgvariant:
  case ifgalternative:
  case ifgiterbody:
    insertnoop(g, e);
    break;

  case ifgloopabody:
  case ifgloopbbody:
    k = largestinputportnumber(toenclosingcompound(g));
    l = largestinputportnumber(g);
    if (l == 0)
      l = k;
    portnum = producerportnumber(e);
    if (portnum <= l)
      insertnoop(g, e);
    break;

  }/* case */
}  /* CheckEdge */

Local Void addnoops(g, LINK)
node *g;
struct LOC_asgnar *LINK;
{
  /* Find places in the graph where NoOp nodes must be inserted in */
  /* order to insure that all the input addresses of a node are    */
  /* distinct from the output addresses.                           */
  long srcport, numloopvals, portnum, graphnum;
  port *srce, *e;
  node *srcnode, *n;
  long FORLIM;
  ifgraphtype TEMP1;

  FORLIM = largestinputportnumber(g);
  /* First check the graphs input list */
  for (portnum = 1; portnum <= FORLIM; portnum++) {
    e = getinputedge(g, portnum);
    if (e != NULL) {
      if (e->ptsort == ptlit)
	checkliteral(e, g);
      else if (producernodeofedge(e) == g)
	checkedge(e, g);
    }
  }

  TEMP1 = graphkind(g);
  /* Make sure that no two loop values will be assigned the
     same offset.  This only applies to the INIT graphs of
     the LoopA and LoopB nodes and the Generator graph of
     the Forall node. */
  /* 11/25/85:  Added IFGAlternative and IFGVariant to
     this class for the following reason:
        if X < 5 then X+1, X+1 else X+1, X-1 end if
     in the true branch, fanout implies both results have the
     same offset.  In the false branch, they must have different
     offsets.
   */

  if (((1L << ((long)TEMP1)) & ((1L << ((long)ifgloopbinit)) |
	 (1L << ((long)ifgloopainit)) | (1L << ((long)ifgforallgenerator)) |
	 (1L << ((long)ifgalternative)) | (1L << ((long)ifgvariant)) |
	 (1L << ((long)ifgiftrue)) | (1L << ((long)ifgiffalse)))) != 0) {
/* p2c: offset.p, line 839: Note:
 * Line breaker spent 4.9+1.16 seconds, 1742 tries on line 1808 [251] */
    FORLIM = largestinputportnumber(g);
    for (portnum = 1; portnum <= FORLIM; portnum++) {
      e = getinputedge(g, portnum);
      if (e != NULL) {
	if (e->ptsort == ptedge) {
	  srcnode = producernodeofedge(e);
	  srcport = producerportnumber(e);
	  if (fanout(srcnode, srcport) > 1) {
	    /* Count the number of Loop Values generated
	       at node = SrcNode and port = SrcPort */
	    numloopvals = 0;
	    srce = getoutputedge(srcnode, srcport);
	    while (srce != NULL) {
	      if (srce->pttonode == g)
		numloopvals++;
	      srce = nextoutputedgesameport(srce);
	    }
	    if (numloopvals > 1)
	      insertnoop(g, e);
	  }
	}
      }
    }
  }

  /* now walk the graph looking for compound nodes and
     check the graphs of each subgraph */
  n = g->ndnext;
  while (n != NULL) {
    if (n->ndsort == ndcompound) {
      FORLIM = numbofsubgraphs(n);
      for (graphnum = 0; graphnum < FORLIM; graphnum++)
	addnoops(tochildgraph(n, graphnum), LINK);
    }
    n = n->ndnext;
  }
}  /* AddNoOps */

Local Void push(e, LINK)
port *e;
struct LOC_asgnar *LINK;
{
  /* Push the edge E on the current stack of edges */
  if (LINK->stackptr == stacksize)
    printf("INTERNAL ERROR:  Stack overflow in Offsetter\n");
  else {
    LINK->stackptr++;
    LINK->stack[LINK->stackptr - 1] = e;
  }
}  /* Push */

Local port *pop(LINK)
struct LOC_asgnar *LINK;
{
  /* Pop the next edge off the current stack of edges.  If the */
  /* stack is empty, return a nil pointer.                     */
  port *Result;

  if (LINK->stackptr == 0)
    return NULL;
  Result = LINK->stack[LINK->stackptr - 1];
  LINK->stack[LINK->stackptr - 1] = NULL;
  LINK->stackptr--;
  return Result;
}  /* Pop */

Local Void initstack(LINK)
struct LOC_asgnar *LINK;
{
  LINK->stackptr = 0;
}  /* InitStack */

Local Void clearstack(LINK)
struct LOC_asgnar *LINK;
{
  /* Clears the stack.  IF the program works properly, this routine
     should be a NoOp. */
  while (LINK->stackptr > 0) {
    LINK->stack[LINK->stackptr - 1] = NULL;
    LINK->stackptr--;
  }
}  /* ClearStack */

Local Void dumpstack(LINK)
struct LOC_asgnar *LINK;
{
  /* This if for debugging purposes.  It lists all edges currently on
     the edge stack.  All edges on the stack are equivalent in that
     they should be assigned the same offset. */
  long pid, i;
  port *e;
  node *cn, *pn;
  long FORLIM;
  FILE *TEMP1;

  FORLIM = LINK->stackptr;
  for (i = 0; i < FORLIM; i++) {
    e = LINK->stack[i];
    printf("%4ld: ", e->ptif1line);
    cn = e->pttonode;
    pid = 0;
    if (e->ptsort == ptlit)
      printf("L%12c", ' ');
    else {
      pn = producernodeofedge(e);
      pid = pn->ndid;
      printf("E  %3ld  %2ld   ", pn->ndlabel, e->UU.U1.ptfrport);
    }
    printf("%3ld  %2ld  T=%ld  ",
	   cn->ndlabel, e->pttoport, e->pttype->stlabel);
    TEMP1 = stdout;
/* p2c: offset.p, line 351:
 * Note: Taking address of stdout; consider setting VarFiles = 0 [144] */
    writestring(&TEMP1, &e->ptname);
    printf("  PI=%ld  CI=%ld\n", pid, cn->ndid);
  }
}  /* DumpStack */

Local Void mark_(e, LINK)
port *e;
struct LOC_asgnar *LINK;
{
  /* Mark that edge E has been visited and pushed on the edge stack */
  e->ptdfaddr = 0;
}  /* Mark */

Local boolean notmarked(e, LINK)
port *e;
struct LOC_asgnar *LINK;
{
  /* Returns true if edge E has not yet been marked. */
  return (e->ptdfaddr < 0);
}  /* NotMarked */

Local Void gatherup(e, LINK)
port *e;
struct LOC_asgnar *LINK;
{
  /* if E <> nil and E has not been marked then GatherUp will do two things:
      (1) Mark and Push all sibling edges, and call MoveDown on them
      (2) Mark and Push E and call MoveUp with E
  */
  node *pn;
  long pp;
  port *se;

  if (e == NULL)
    return;
  if (!notmarked(e, LINK))
    return;
  mark_(e, LINK);
  push(e, LINK);
  if (e->ptsort != ptedge)
    return;
  pn = producernodeofedge(e);
  pp = producerportnumber(e);
  se = getoutputedge(pn, pp);   /* sibling edge */
  while (se != NULL) {
    if (notmarked(se, LINK) && se != e) {
      mark_(se, LINK);
      push(se, LINK);
      movedown(se, LINK);
    }
    se = nextoutputedgesameport(se);
  }  /* while */
  moveup(e, LINK);
}  /* GatherUp */

Local Void gatherdown(e, LINK)
port *e;
struct LOC_asgnar *LINK;
{
  /* If E <> nil and is not already Marked then GatherDown marks and pushes
     all sibling edges of E.  It also calls MoveDown with each. */
  node *pn;
  long pp;
  port *se;

  if (e == NULL)
    return;
  if (!notmarked(e, LINK))
    return;
  mark_(e, LINK);
  push(e, LINK);
  movedown(e, LINK);
  if (e->ptsort != ptedge) {
    return;
  }  /* (^.PTSort = PTEdge) */
  pn = producernodeofedge(e);
  pp = producerportnumber(e);
  se = getoutputedge(pn, pp);
  while (se != NULL) {
    if (notmarked(se, LINK)) {
      mark_(se, LINK);
      push(se, LINK);
      movedown(se, LINK);
    }
    se = nextoutputedgesameport(se);
  }  /* while SE */
}  /* GatherDown */

/* Local variables for moveup: */
struct LOC_moveup {
  struct LOC_asgnar *LINK;
  long pp;
} ;

/* ---------------------------------------------------------- */
Local Void atconstantport(n, g, p, LINK)
node *n, *g;
long p;
struct LOC_moveup *LINK;
{
  long gnum;
  node *subg;
  long FORLIM;

  FORLIM = numbofsubgraphs(n);
  for (gnum = 0; gnum < FORLIM; gnum++) {
    subg = tochildgraph(n, gnum);
    if (subg != g)
      gatherdown(getoutputedge(subg, p), LINK->LINK);
  }  /* for */
  gatherup(getinputedge(n, p), LINK->LINK);
}  /* AtConstantPort */

Local Void atforallreturns(n, g, p, LINK)
node *n, *g;
long p;
struct LOC_moveup *LINK;
{
  node *geng, *bodyg;
  long l;

  geng = toforallgeneratorgraph(n);
  bodyg = toforallbodygraph(n);
  l = largestinputportnumber(geng);
  if (l == 0)
    l = largestinputportnumber(n);
  if (p <= l) {   /* Multiple generated in generator graph */
    gatherup(getinputedge(geng, LINK->pp), LINK->LINK);
    gatherdown(getoutputedge(bodyg, LINK->pp), LINK->LINK);
  } else  /* value generated in body graph */
    gatherup(getinputedge(bodyg, LINK->pp), LINK->LINK);
}  /* AtForallReturns */

Local Void attestorret(n, g, p, LINK)
node *n, *g;
long p;
struct LOC_moveup *LINK;
{
  /* At the top of the Returns or Test graph of a while loop */
  node *initg, *testg, *bodyg, *retg;

  initg = toinitgraph(n);
  testg = totestgraph(n);
  bodyg = tobodygraph(n);
  retg = toreturnsgraph(n);
  gatherup(getinputedge(initg, p), LINK->LINK);
  gatherup(getinputedge(bodyg, p), LINK->LINK);
  if (g == testg)
    gatherdown(getoutputedge(retg, p), LINK->LINK);
  else
    gatherdown(getoutputedge(testg, p), LINK->LINK);
}  /* AtTestOrRet */

Local Void atloopatest(n, testg, p, LINK)
node *n, *testg;
long p;
struct LOC_moveup *LINK;
{
  node *initg, *bodyg, *retg;
  long l;

  initg = toinitgraph(n);
  bodyg = tobodygraph(n);
  retg = toreturnsgraph(n);
  gatherup(getinputedge(bodyg, p), LINK->LINK);
  l = largestinputportnumber(initg);
  if (l == 0)
    l = largestinputportnumber(n);
  if (p <= l) {   /* is a loop value */
    gatherup(getinputedge(initg, p), LINK->LINK);
    gatherdown(getoutputedge(retg, p), LINK->LINK);
  }
}  /* AtLoopATest */

Local Void moveup(e, LINK)
port *e;
struct LOC_asgnar *LINK;
{
  /*( E : EGPtr)*/
  /* Pre:  E has already been marked and saved on the stack.
     Action: The producer node of E (if it has one) is examined.
             If it is a simple node then no equivalent edges can be
               found above and no action is taken.
             If it is a compound node then we gather all edges equivalent
               to E within the subgraphs.
             If it is a graph node then the action is to examine what
               kind of graph node it is and gather equivalent edges
               in sibling subgraphs (if any).  */
  struct LOC_moveup V;
  long k, gnum, lastgraph;
  node *n, *pn, *subg;
  ifgraphtype gkind;
  long FORLIM;

  /* ---------------------------------------------------------- */

  V.LINK = LINK;
  if (e->ptsort != ptedge) {
    return;
  }  /* (^.PTSort = PTEdge) */
  pn = producernodeofedge(e);
  V.pp = producerportnumber(e);
  if (pn->ndsort == ndatomic)  /* do nothing */
    return;
  if (pn->ndsort == ndcompound) {
    switch (pn->ndcode) {

    case ifnselect:
      FORLIM = numbofsubgraphs(pn);
      for (gnum = 1; gnum < FORLIM; gnum++) {
	subg = tochildgraph(pn, gnum);
	gatherup(getinputedge(subg, V.pp), LINK);
      }
      break;
      /* Select */

    case ifnifthenelse:
      lastgraph = numbofsubgraphs(pn) - 1;
      for (gnum = 0; gnum <= lastgraph; gnum++) {
	if (gnum == lastgraph || (gnum & 1) == 0)
	{  /* only move up into true and false branches */
	  subg = tochildgraph(pn, gnum);
	  gatherup(getinputedge(subg, V.pp), LINK);
	}
      }
      break;
      /* IfThenElse */

    case ifntagcase:
      FORLIM = numbofsubgraphs(pn);
      for (gnum = 0; gnum < FORLIM; gnum++) {
	subg = tochildgraph(pn, gnum);
	gatherup(getinputedge(subg, V.pp), LINK);
      }
      break;
      /* Tagcase */

    case ifnforall:
      subg = toforallreturnsgraph(pn);
      gatherup(getinputedge(subg, V.pp), LINK);
      break;
      /* IFNForall */

    case ifnloopb:
    case ifnloopa:
      subg = toreturnsgraph(pn);
      gatherup(getinputedge(subg, V.pp), LINK);
      break;
      /* IFNLoopB, IFNLoopA */

    case ifniter:
      subg = toiterbodygraph(pn);
      gatherup(getinputedge(subg, V.pp), LINK);
      break;
    }/* case ^.NDCode */
    return;
  }  /* (^.NDSort = NDCompound) */
  gkind = graphkind(pn);
  if (gkind == ifgfunction)
    return;
  n = toenclosingcompound(pn);
  k = largestinputportnumber(n);
  if (V.pp <= k) {   /* at a constant port of the compound node */
    if (V.pp != 1 || gkind != ifgvariant)   /* do nothing */
      atconstantport(n, pn, V.pp, &V);
    return;
  }
  switch (gkind) {

  case ifgforallbody:
    gatherup(getinputedge(toforallgeneratorgraph(n), V.pp), LINK);
    gatherdown(getoutputedge(toforallreturnsgraph(n), V.pp), LINK);
    break;
    /* Forall Body */

  case ifgforallreturns:
    atforallreturns(n, pn, V.pp, &V);
    break;

  case ifgloopareturns:
  case ifgloopbtest:
  case ifgloopbreturns:
    attestorret(n, pn, V.pp, &V);
    break;

  case ifgloopabody:
  case ifgloopbbody:
  case ifgiterbody:   /* do nothing */
    break;

  case ifgloopatest:
    atloopatest(n, pn, V.pp, &V);
    break;
  }/* case */

  /* (PN ^.NDSort = NDGraph) */
  /* at a Loop value or temporary port of a loop node */
  /* (^.NDSort = NDGraph) */
}  /* MoveUp */

/* Local variables for movedown: */
struct LOC_movedown {
  struct LOC_asgnar *LINK;
} ;

/* --------------------------------------------------------------- */
Local Void atalternative(n, g, p, LINK)
node *n, *g;
long p;
struct LOC_movedown *LINK;
{
  /* Handles Select Alternative graphs and Tagcase Variant graphs */
  long gnum;
  node *subg;
  long FORLIM;

  FORLIM = numbofsubgraphs(n);
  for (gnum = 0; gnum < FORLIM; gnum++) {
    subg = tochildgraph(n, gnum);
    if ((subg != g) & (graphkind(subg) != ifgselector))
      gatherup(getinputedge(subg, p), LINK->LINK);
  }  /* for */
  /* now walk output edges of N */
  gatherdown(getoutputedge(n, p), LINK->LINK);
}  /* AtAlternative */

/* --------------------------------------------------------------- */

Local Void attruefalsegraph(n, g, p, LINK)
node *n, *g;
long p;
struct LOC_movedown *LINK;
{
  /* Handles IfThenElse True and False branches */
  long lastgraph, gnum;
  node *subg;

  lastgraph = numbofsubgraphs(n) - 1;
  for (gnum = 0; gnum <= lastgraph; gnum++) {
    if (gnum == lastgraph || (gnum & 1) == 0) {
      subg = tochildgraph(n, gnum);
      if (subg != g)
	gatherup(getinputedge(subg, p), LINK->LINK);
    }  /* for */
  }
  /* now walk output edges of N */
  gatherdown(getoutputedge(n, p), LINK->LINK);
}  /* AtTrueFalseGraph */

Local Void movedown(e, LINK)
port *e;
struct LOC_asgnar *LINK;
{
  /*( E : EGPtr )*/
  /* Similar to MoveUp except that we examine the consumer node of E
     rather than the producer node. */
  struct LOC_movedown V;
  node *cn, *n, *subg;
  long l, cp, gnum;
  ifgraphtype gkind;
  long FORLIM;

  /* --------------------------------------------------------------- */

  V.LINK = LINK;
  cn = e->pttonode;
  cp = e->pttoport;
  if (cn->ndsort == ndatomic)  /* do nothing */
    return;
  if (cn->ndsort == ndcompound) {
    if (cp == 1 && cn->ndcode == ifntagcase || cn->ndcode == ifniter)
	  /* do nothing */
	    return;
    FORLIM = numbofsubgraphs(cn);
    for (gnum = 0; gnum < FORLIM; gnum++) {
      subg = tochildgraph(cn, gnum);
      gatherdown(getoutputedge(subg, cp), LINK);
    }
    return;
  }  /* (^.NDSort = NDCompound) */
  gkind = graphkind(cn);
  if (gkind != ifgfunction)
    n = toenclosingcompound(cn);
  switch (gkind) {

  case ifgfunction:
  case ifgselector:
  case ifgloopbtest:
  case ifgloopatest:
  case ifgifpredicate:
    break;
    /* Do Nothing */

  case ifgalternative:
  case ifgvariant:
    atalternative(n, cn, cp, &V);
    break;

  case ifgiftrue:
  case ifgiffalse:
    attruefalsegraph(n, cn, cp, &V);
    break;

  case ifgforallgenerator:
    gatherdown(getoutputedge(toforallbodygraph(n), cp), LINK);
    gatherdown(getoutputedge(toforallreturnsgraph(n), cp), LINK);
    break;
    /* ForallGenerator */

  case ifgforallbody:
    gatherdown(getoutputedge(toforallreturnsgraph(n), cp), LINK);
    break;

  case ifgforallreturns:
  case ifgloopbreturns:
  case ifgloopareturns:
    gatherdown(getoutputedge(n, cp), LINK);
    break;

  case ifgiterbody:
    gatherdown(getoutputedge(n, cp), LINK);
    break;

  case ifgloopainit:
  case ifgloopbinit:
    gatherdown(getoutputedge(totestgraph(n), cp), LINK);
    gatherup(getinputedge(tobodygraph(n), cp), LINK);
    gatherdown(getoutputedge(toreturnsgraph(n), cp), LINK);
    break;
    /* LoopB Init */

  case ifgloopbbody:
    gatherup(getinputedge(toinitgraph(n), cp), LINK);
    gatherdown(getoutputedge(totestgraph(n), cp), LINK);
    gatherdown(getoutputedge(toreturnsgraph(n), cp), LINK);
    break;
    /* LoopB Body */

  case ifgloopabody:
    subg = toinitgraph(n);
    gatherdown(getoutputedge(totestgraph(n), cp), LINK);
    l = largestinputportnumber(subg);
    if (l == 0)
      l = largestinputportnumber(n);
    if (cp <= l) {   /* Loop value */
      gatherup(getinputedge(subg, cp), LINK);   /* the Init graph */
      gatherdown(getoutputedge(toreturnsgraph(n), cp), LINK);
    }
    break;
    /* LoopA Body */
  }/* case */

  /* (CN ^.NDSort = NDGraph) */
  /* (^.NDSort = NDGraph) */
}  /* MoveDown */

/* Local variables for offsetgraph: */
struct LOC_offsetgraph {
  struct LOC_asgnar *LINK;
} ;

Local Void assignoffset(e, addr, LINK)
port *e;
long addr;
struct LOC_offsetgraph *LINK;
{
  e->ptdfaddr = addr;
}  /* AssignOffset */

Local long sizeofedge(e, LINK)
port *e;
struct LOC_offsetgraph *LINK;
{
  long s;
  node *pn;

  s = 1;
  if (e->ptsort != ptedge)
    return s;
  pn = producernodeofedge(e);
  if (P_inset((int)pn->ndcode, LINK->LINK->specialsizenodes))
    s *= 2;
  return s;
}  /* SizeOfEdge */

Local Void offsetgraph(g, offset, LINK)
node *g;
long *offset;
struct LOC_asgnar *LINK;
{
  /* The input edges of each node of G (including G itself) are
     walked.  For each edge, all equivalent nodes are gathered and
     stored in the edge stack.  Each edge in the stack is assigned
     the same offset and its size requirements are computed.  Finally,
     the running offset variable is incremented by the maximum of
     the edge sizes. */
  struct LOC_offsetgraph V;
  node *n;
  long startport, p, size, maxsize, gnum;
  port *ie, *e;
  long FORLIM;

  V.LINK = LINK;
  n = g;
  while (n != NULL) {
    /* process input edges of N */
    if (P_inset((int)n->ndcode, LINK->specialnodes))
      startport = 2;
    else
      startport = 1;
    FORLIM = largestinputportnumber(n);
    for (p = startport; p <= FORLIM; p++) {
      ie = getinputedge(n, p);
      if (ie != NULL) {
	if (notmarked(ie, LINK)) {
	  clearstack(LINK);
	  gatherdown(ie, LINK);
	  moveup(ie, LINK);
	  /* now the stack contains all edges equivalent to IE */
	  maxsize = 0;
	  e = pop(LINK);
	  while (e != NULL) {
	    assignoffset(e, *offset, &V);
	    size = sizeofedge(e, &V);
	    if (size > maxsize)
	      maxsize = size;
	    e = pop(LINK);
	  }
	  *offset += maxsize;
	}  /* NotMarked */
      }
    }  /* for */
    if (n->ndsort == ndcompound) {
      FORLIM = numbofsubgraphs(n);
      for (gnum = 0; gnum < FORLIM; gnum++)
	offsetgraph(tochildgraph(n, gnum), offset, LINK);
    }
    n = n->ndnext;
  }
}  /* OffsetGraph */





int asgnar()
{

  /*-------------------------------------------------------------------*/
  /* The LLNL IF1 interpreter executes function graphs that have been  */
  /* translated from SISAL to IF1.  Since several activations of a     */
  /* particular function may be in existence at one time the           */
  /* interpreter keeps a seperate data space or activation record (AR) */
  /* for each function instantiation.  Each edge and literal within    */
  /* a function graph must then be assigned an offset within an AR     */
  /* where its value will be stored.  IF1Offset is the program that    */
  /* assigns these offsets.  This program works in three passes of     */
  /* each function graph, the passes are:      */
  /*  (I) Insertion of NoOp nodes are certain places.  This insures    */
  /*      the functional semantics of IF1.  See the doccumentation     */
  /*      for a complete description.      */
  /*  (II) Initialization of offsets.  Each edge and literal of each   */
  /*       function graph is assigned an initial offset of -1.  This   */
  /*       indicates that the true offset (a positive integer) has not */
  /*       yet been assigned.      */
  /*  (III) Assignment of offsets.  For each previously unmarked arc   */
  /*        of the graph (edge or literal with an offset of -1) we     */
  /*        perform several steps: (1) gather all equivalent arcs,     */
  /*        (2) assign each the current offset, and (3) compute the    */
  /*        AR space requirement for each edge and increment the       */
  /*        running offset by the maximum of these sizes.              */
  /* NOTE:  The offset assigned to each edge and literal is stored as  */
  /*        the %of pragma.  The size of an activation record required */
  /*        by a function graph is stored as the %ar pragma.           */
  /*-------------------------------------------------------------------*/
  struct LOC_asgnar V;
  stryng offsetstamp;
  long offset;
  node *func;

  /* ----------------------------------------------------------------- */

  if (stampismissing('C')) {
    printf("Error: Not all files have been Structure Checked\n");
    return false;
  } else {
    /* These are the old special size nodes (pre 9/26/85)
          SpecialSizeNodes := [ IFNAGather, IFNReduce, IFNRedLeft, IFNRedRight,
                                IFNRedTree, IFNFirstValue, IFNFinalValue,
                                IFNAllButLastValue ];
    */
    P_addset(P_expset(V.specialsizenodes, 0L), ifnallbutlastvalue);
    P_addset(P_expset(V.specialnodes, 0L), ifncall);
    P_addset(V.specialnodes, ifnspawn);
    P_addset(V.specialnodes, ifnreduce);
    P_addset(V.specialnodes, ifnredleft);
    P_addset(V.specialnodes, ifnredright);
    P_addset(V.specialnodes, ifnredtree);

    func = firstfunction;
    while (func != NULL) {
      addnoops(func, &V);
      initoffsets(func, &V);
      offset = 1;
      initstack(&V);
      offsetgraph(func, &offset, &V);
      func->UU.U1.ndlink->lkarsize = offset - 1;
      func = tonextfunction(func);
    }
    string20(&offsetstamp, " Offsets Assigned   ");
    addstamp('O', offsetstamp);
    return true;
  }


}  /* AssAR */

#undef stacksize
#undef ident





/* End. */
