#include "world.h"


PINFO  ihead  = NULL;                      /* SYMBOL TABLE HEAD POINTER   */
PINFO  itail  = NULL;                      /* SYMBOL TABLE TAIL POINTER   */
PNODE  nhead  = NULL;                      /* NODE LIST HEAD POINTER      */
PNODE  ntail  = NULL;                      /* NODE LIST TAIL POINTER      */

char  *stamps[128] =                          /* STAMPS FOR ANY CHARACTER */
    { NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
      NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
      NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
      NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
      NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
      NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
      NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
      NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
      NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
      NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
      NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL };

static int tbase = 0;                 /* TYPE LABEL BASE FOR CURRENT FILE */
static int tmax  = 0;                 /* TYPE LABEL BASE FOR NEXT FILE    */

char *sfile;                               /* SISAL FILE BEING READ       */
char *sfunct;                              /* SISAL FUNCTION BEING BUILT  */


/**************************************************************************/
/* GLOBAL **************    AssignSourceFileName   ************************/
/**************************************************************************/
/* PURPOSE: IF PRESENT, REPLACE FILE NAME n's ".if1" SUFFIX WITH ".sis".  */
/*          N is UPDATED IN SITU AND ASSIGNED TO sfile.                   */
/**************************************************************************/

void AssignSourceFileName( n )
char *n;
{
    register char *p;

    for ( p = n + (strlen( n ) - 1); p != n; p-- )
        if ( *p == '.' )
	    if ( strcmp( p, ".if1" ) == 0 ) {
	        *(++p) = 's'; *(++p) = 'i'; *(++p) = 's';
	        break;
	        }

    sfile = n;
}


/**************************************************************************/
/* GLOBAL **************     PrepareForNextFile    ************************/
/**************************************************************************/
/* PURPOSE: PREPARE TO READ THE NEXT IF1 FILE AND BUILD ITS INTERNAL FORM.*/
/*          SO THAT ALL TYPE LABELS DEFINED IN THE MONOLITH ARE UNIQUE    */
/*          AND CONSECUTIVE, tbase IS SET TO THE LAST LABEL ENCOUNTERED   */
/*          IN THE PREVIOUS FILE.                                         */
/**************************************************************************/

void PrepareForNextFile()
{
    tbase  = tmax;
}


/**************************************************************************/
/* LOCAL  **************       LookupInfo          ************************/
/**************************************************************************/
/* PURPOSE: UTILITY USED BY FindInfo TO LOCATE AN INFO NODE WITH LABEL    */
/*          label in THE INFO LIST HEADED BY ihead. IF IT IS NOT IN THE   */
/*          LIST, THEN A NEW INFO NODE IS ALLOCATED, APPENDED TO THE END, */
/*          AND RETURNED.                                                 */
/**************************************************************************/

static PINFO LookupInfo( label, type )
int   label;
int   type;
{
    register PINFO i;

    for ( i = ihead; i != NULL; i = i->next )
        if ( label == i->label ) {
            if ( i->type == IF_NONTYPE )
                i->type = type;

            return( i );
            }

    i = InfoAlloc( label, type );

    itail->next = i;
    itail       = i;

    return( i );
}


/**************************************************************************/
/* LOCAL  **************        FindInfo           ************************/
/**************************************************************************/
/* PURPOSE: LOCATE AND RETURN THE INFO NODE WITH LABEL label + tbase IN   */
/*          THE INFO LIST HEADED BY ihead.  IF THE NODE DOES NOT EXIST,   */
/*          IT IS ALLOCATED AND INSERTED INFO THE LIST. NULL IS RETURNED  */
/*          IF THE REQUESTED LABEL IS 0. Tbase IS ADDED TO ALL LABELS TO  */
/*          MAKE THEM UNIQUE ACROSS ALL FILES.  Tmax  IS USED  TO DEFINE  */
/*          tbase FOR THE NEXT READ FILE.                                 */
/**************************************************************************/

static PINFO FindInfo( label, type )
int label;
int type;
{
    if ( label <= 0 )
        return( NULL );

    label += tbase;

    if ( tmax < label )
	tmax = label;

    if ( ihead == NULL )
        return( ihead = itail = InfoAlloc( label, type ) );

    return( LookupInfo( label, type ) );
}


/**************************************************************************/
/* GLOBAL **************        MakeInfo           ************************/
/**************************************************************************/
/* PURPOSE: MAKE AN INFO NODE AND INITIALIZE IT (LINKING IT TO OTHER INFO */
/*          NODES IF REQUIRED BY ITS TYPE. IF BUILDING A BASIC TYPE THEN  */
/*          ADJUST IT SO THAT ALL TYPE IDENTIFIERS ARE UNIQUE. THE LABEL  */
/*          IS ADJUSTED SO TO BE UNIQUE ACROSS THE MONOLITH AND THE       */
/*          LARGEST ENCOUNTERED LABEL IS REMEMBERED.                      */
/**************************************************************************/

void MakeInfo( label, type, ref1, ref2 )
int   label;
int   type;
int   ref1;
int   ref2;
{
    register PINFO i;
    register PINFO i1;
    register PINFO i2;

    switch ( type ) {
	case IF_BASIC:
            type = ref1 + BASIC_TYPE_START;
	    break;

	case IF_UNKNOWN:
	    break;

        default:
            i1 = FindInfo( ref1, IF_NONTYPE );
            i2 = FindInfo( ref2, IF_NONTYPE );
	    break;
        }

    i = FindInfo( label, type );

    AssignPragmas( i ); 
    i->sf = FALSE; i->fn = FALSE;                   /* JUST EXTRA BAGGAGE */

    switch ( type ) {
        case IF_FUNCTION:
            i->F_IN  = i1;
            i->F_OUT = i2;
            break;

        case IF_STREAM:
        case IF_MULTPLE:
        case IF_ARRAY:
            i->A_ELEM = i1;
            break;

        case IF_UNION:
        case IF_RECORD:
            i->R_FIRST = i1;
            break;

        case IF_TUPLE: 
        case IF_FIELD:
        case IF_TAG:
            i->L_SUB  = i1;
            i->L_NEXT = i2;
            break;

        default:
            break;
        }
}


/**************************************************************************/
/* LOCAL  **************       AddToNodeList       ************************/
/**************************************************************************/
/* PURPOSE: ADD NODE n TO THE END OF THE NODE LIST.                       */
/**************************************************************************/

static void AddToNodeList( n )
register PNODE n;
{
    n->next = NULL;

    if ( ntail != NULL )
	ntail->next = n;
    else
	nhead = n;

    ntail = n;
}


/**************************************************************************/
/* GLOBAL **************       MakeCompound        ************************/
/**************************************************************************/
/* PURPOSE: MAKE A COMPOUND NODE AND ADD IT TO THE NODE LIST.             */
/**************************************************************************/

void MakeCompound( type, alst )
int   type;
char *alst;
{
    register PNODE n;

    n = NodeAlloc( 0, type );

    n->CoNsT = alst;

    AssignPragmas( n );
    AddToNodeList( n );
}


/**************************************************************************/
/* GLOBAL **************         MakeNode          ************************/
/**************************************************************************/
/* PURPOSE: MAKE A SIMPLE NODE AND ADD IT TO THE NODE LIST.               */
/**************************************************************************/

void MakeNode( label, type )
int   label;
int   type;
{
    register PNODE n;

    n = NodeAlloc( label, type );

    AssignPragmas( n );
    AddToNodeList( n );
}


/**************************************************************************/
/* GLOBAL **************         MakeGraph         ************************/
/**************************************************************************/
/* PURPOSE: MAKE A NEW GRAPH NODE AND ADD IT TO THE NODE LIST. DEPENDING  */
/*          ON THE GRAPH NODE, AN ENTRY IS MADE IN THE APPROPRIATE NAME   */
/*          LIST (USED TO IDENTIFY UNDEFINED FUNCTIONS). NOTE, INTRINSICS */
/*          ARE NOT ADDED TO THE IMPORT NAME LIST AND NODE LIST; HENCE    */
/*          ARE NOT PLACED BACK INTO THE MONOLITH.                        */
/**************************************************************************/

void MakeGraph( type, label, name )
int   type;
int   label;
char *name;
{
    register PNODE n;

    n = NodeAlloc( 0, type );

    if ( type != IFSGraph ) {
	sfunct   = name;
        n->info  = FindInfo( label, IF_FUNCTION );
	n->CoNsT = LowerCase( name );
	}

    AssignPragmas( n );

    if ( type != IFIGraph && type != IFSGraph )
      AddToNameList( n );

    if ( type == IFIGraph ) {
        AddToImportList( n, n->CoNsT, n->info );
	return;
	}

    AddToNodeList( n );
}


/**************************************************************************/
/* GLOBAL **************         MakeEdge          ************************/
/**************************************************************************/
/* PURPOSE: MAKE AN EDGE AND ADD IT TO THE NODE LIST.                     */
/**************************************************************************/

void MakeEdge( snode, eport, dnode, iport, label )
int   snode, eport;
int   dnode, iport;
int   label;
{
    register PNODE n;

    n = NodeAlloc( 0, IFEdge );

    AssignPragmas( n );
    n->sf = FALSE; n->fn = FALSE;                   /* JUST EXTRA BAGGAGE */

    n->snode = snode;
    n->eport = eport;
    n->dnode = dnode;
    n->iport = iport;
    n->info  = FindInfo( label, IF_NONTYPE );

    AddToNodeList( n );
}


/**************************************************************************/
/* GLOBAL **************         MakeConst         ************************/
/**************************************************************************/
/* PURPOSE: MAKE A CONSTANT EDGE AND ADD IT TO THE NODE LIST.             */
/**************************************************************************/

void MakeConst( dnode, iport, label, CoNsT )
int    dnode;
int    iport;
int    label;
char  *CoNsT;
{
    register PNODE n;

    n = NodeAlloc( 0, IFLiteral );

    AssignPragmas( n );
    n->sf = FALSE; n->fn = FALSE;                   /* JUST EXTRA BAGGAGE */

    n->dnode = dnode;
    n->iport = iport;
    n->info  = FindInfo( label, IF_NONTYPE );
    n->CoNsT = CoNsT;

    AddToNodeList( n );
}


/**************************************************************************/
/* GLOBAL **************         AddStamp          ************************/
/**************************************************************************/
/* PURPOSE: ADD STAMP stamp WITH COMMENTAY s TO THE STAMP TABLE.          */
/**************************************************************************/

void AddStamp( stamp, s )  char stamp; char *s; { stamps[ stamp ] = s; }
