#include "world.h"


/**************************************************************************/
/* GLOBAL **************      IsIntrinsic          ************************/
/**************************************************************************/
/* PURPOSE: RETURN TRUE IF nm IS AN INTRINSIC.                            */
/**************************************************************************/

int IsIntrinsic( nm, i )
char  *nm;
PINFO  i;
{
  register char *p;

  p = LowerCase( nm );

  /* MAP TO C OPERATORS! */
  if ( strcmp( p, "or" ) == 0 ) goto DyadicInt;
  if ( strcmp( p, "xor" ) == 0 ) goto DyadicInt;
  if ( strcmp( p, "and" ) == 0 ) goto DyadicInt;
  if ( strcmp( p, "shiftl" ) == 0 ) goto DyadicInt;
  if ( strcmp( p, "shiftr" ) == 0 ) goto DyadicInt;
  if ( strcmp( p, "not" ) == 0 ) goto MonadicInt;

  /* From math.h */
  if ( strcmp( p, "log" ) == 0 ) goto MonadicMix;
  if ( strcmp( p, "log10" ) == 0 ) goto MonadicMix;
  if ( strcmp( p, "etothe" ) == 0 ) goto MonadicMix;
  if ( strcmp( p, "sin" ) == 0 ) goto MonadicMix;
  if ( strcmp( p, "cos" ) == 0 ) goto MonadicMix;
  if ( strcmp( p, "tan" ) == 0 ) goto MonadicMix;
  if ( strcmp( p, "asin" ) == 0 ) goto MonadicMix;
  if ( strcmp( p, "acos" ) == 0 ) goto MonadicMix;
  if ( strcmp( p, "atan" ) == 0 ) goto MonadicMix;
  if ( strcmp( p, "sqrt" ) == 0 ) goto MonadicMix;

  goto ErrExit;

MonadicInt:
  if ( i->F_IN == NULL ) goto ErrExit;
  if ( i->F_IN->L_NEXT != NULL ) goto ErrExit;
  if ( !IsInteger( i->F_IN->L_SUB ) ) goto ErrExit;
  if ( i->F_OUT->L_NEXT != NULL ) goto ErrExit;
  if ( !IsInteger( i->F_OUT->L_SUB ) ) goto ErrExit;

  free( p );
  return( TRUE );

DyadicInt:
  if ( i->F_IN == NULL ) goto ErrExit;
  if ( i->F_IN->L_NEXT == NULL ) goto ErrExit;
  if ( i->F_IN->L_NEXT->L_NEXT != NULL ) goto ErrExit;
  if ( !IsInteger( i->F_IN->L_SUB ) ) goto ErrExit;
  if ( !IsInteger( i->F_IN->L_NEXT->L_SUB ) ) goto ErrExit;

  if ( i->F_OUT->L_NEXT != NULL ) goto ErrExit;
  if ( !IsInteger( i->F_OUT->L_SUB ) ) goto ErrExit;

  free( p );
  return( TRUE );

MonadicMix:
  if ( i->F_IN == NULL ) goto ErrExit;
  if ( i->F_IN->L_NEXT != NULL ) goto ErrExit;
  if ( !IsArithmetic( i->F_IN->L_SUB ) ) goto ErrExit;
  if ( i->F_OUT->L_NEXT != NULL ) goto ErrExit;
  if ( !IsArithmetic( i->F_OUT->L_SUB ) ) goto ErrExit;

  free( p );
  return( TRUE );

ErrExit:
  free( p );
  return( FALSE );
}


/**************************************************************************/
/* GLOBAL **************        IsEntryPoint       ************************/
/**************************************************************************/
/* PURPOSE: RETURN THE INDEX OF nm IF IT IS IN THE ENTRY POINT TABLE,     */
/*          ELSE RETURN -1.                                               */
/**************************************************************************/

int IsEntryPoint( nm )
char *nm;
{
  register int   i;
  register char *p;
  register int   ans;

  p = LowerCase( nm );
  ans = -1;

  for ( i = 0; i <= etop; i++ )
    if ( strcmp( p, entryt[i] )  == 0 ) {
      ans = i;
      break;
      }

  free( p );
  return( ans );
}


/**************************************************************************/
/* GLOBAL **************    IsFortranInterface     ************************/
/**************************************************************************/
/* PURPOSE: RETURN TRUE IF nm IS A FORTRAN INTERFACE FUNCTION.            */
/**************************************************************************/

int IsFortranInterface( nm )
char *nm;
{
  register char *p;
  register int   i;
  register int   ans;

  p = LowerCase( nm );
  ans = FALSE;

  for ( i = 0; i <= ftop; i++ )
    if ( strcmp( p, fortt[i] )  == 0 ) {
      ans = TRUE;
      break;
      }

  free( p );
  return( ans );
}


/**************************************************************************/
/* GLOBAL **************       IsCInterface        ************************/
/**************************************************************************/
/* PURPOSE: RETURN TRUE IF nm IS A C INTERFACE FUNCTION.                  */
/**************************************************************************/

int IsCInterface( nm )
char *nm;
{
  register char *p;
  register int   i;
  register int   ans;

  p = LowerCase( nm );
  ans = FALSE;

  for ( i = 0; i <= ctop; i++ )
    if ( strcmp( p, ct[i] )  == 0 ) {
      ans = TRUE;
      break;
      }

  free( p );
  return( ans );
}


/**************************************************************************/
/* GLOBAL **************        CopyString         ************************/
/**************************************************************************/
/* PURPOSE: RETURN A COPY OF THE INPUT STRING s.                          */
/**************************************************************************/

char *CopyString( s ) 
char *s;
{
    return( strcpy( MyAlloc( strlen( s ) + 1 ), s ) );
}


/**************************************************************************/
/* GLOBAL **************          Error1           ************************/
/**************************************************************************/
/* PURPOSE: PRINT AN ERROR MEASAGE TO stderr AND ABORT EXECUTION.         */
/**************************************************************************/

void Error1( msg1 )
char *msg1;
{
    fprintf( stderr, "%s: E - %s\n", program, msg1 );
    Stop( ERROR );
}


/**************************************************************************/
/* GLOBAL **************          Error2           ************************/
/**************************************************************************/
/* PURPOSE: PRINT TWO ERROR MEASAGES TO stderr AND ABORT EXECUTION.       */
/**************************************************************************/

void Error2( msg1, msg2 )
char *msg1;
char *msg2;
{
    fprintf( stderr, "%s: E - %s %s\n", program, msg1, msg2 );
    Stop( ERROR );
}


/**************************************************************************/
/* GLOBAL **************          MyAlloc          ************************/
/**************************************************************************/
/* PURPOSE: ALLOCATE AND RETURN A POINTER TO size BYTES OF MEMORY. IF THE */
/*          ALLOCATION FAILS, AN ERROR MESSAGE IS PRINTED AND EXECUTION   */
/*          TERMINATES.                                                   */
/**************************************************************************/

char *MyAlloc( size )
int size;
{
    char *p;

    if ( (p = malloc( size )) == NULL )
	Error1( "MALLOC FAILED" );

    return( p );
}


/**************************************************************************/
/* GLOBAL **************         NodeAlloc         ************************/
/**************************************************************************/
/* PURPOSE: ALLOCATE, INITIALIZE, AND RETURN A NODE.                      */
/**************************************************************************/

PNODE NodeAlloc( label, type )
int   label;
int   type;
{
    register PNODE n;

    n = (PNODE) MyAlloc( sizeof(NODE) );

    n->label = label;
    n->type  = type;
    n->next  = NULL;

    InitPragmas( n );

    return( n );
}


/**************************************************************************/
/* GLOBAL **************         InfoAlloc         ************************/
/**************************************************************************/
/* PURPOSE: ALLOCATE, INITIALIZE, AND RETURN AN INFO NODE.                */
/**************************************************************************/

PINFO InfoAlloc( label, type )
int   label;
int   type;
{
    register PINFO i;

    i = (PINFO) MyAlloc( sizeof(INFO) );

    i->label = label;
    i->type  = type;

    i->info1 = NULL;
    i->info2 = NULL;

    i->next  = NULL;
    i->print = TRUE;

    InitPragmas( i );

    return( i );
}


/**************************************************************************/
/* GLOBAL **************         NameAlloc         ************************/
/**************************************************************************/
/* PURPOSE: ALLOCATE, INITIALIZE, AND RETURN A NAME NODE.                 */
/**************************************************************************/

PNAME NameAlloc( n, name, t )
PNODE  n;
char  *name;
PINFO  t;
{
    register PNAME p;

    p = (PNAME) MyAlloc( sizeof(INFO) );

    p->name  = name;
    p->next  = NULL;
    p->usucc = NULL;
    p->info  = t;
    p->node  = n;

    p->mk = FALSE;
    p->mark = ' ';

    return( p );
}


/**************************************************************************/
/* GLOBAL **************         LowerCase         ************************/
/**************************************************************************/
/* PURPOSE: RETURN A COPY OF STRING n WITH THE UPPER CASE LETTERS IN      */
/*          LOWER CASE.                                                   */
/**************************************************************************/

char *LowerCase( n )
char *n;
{
  register char *u;
  register char *p;

  for ( u = p = CopyString( n ); *p != '\0'; p++ )
    if ( (*p >= 'A') && (*p <= 'Z') )
      *p = 'a' + (*p - 'A'); 

  return( u );
}
